/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;

class HPyDispatchers {
    private HPyDispatchers() {
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class UnaryHPySlotDispatcherNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, PythonContext var3, PythonContext.PythonThreadState var4, Object var5, Object var6);

        @Specialization
        static Object doIt(VirtualFrame frame, PythonContext ctx, PythonContext.PythonThreadState threadState, Object nativeSlotCallable, Object self, @Cached(value="createFor(this)") IndirectCallData callData, @Cached(inline=false) GraalHPyNodes.HPyAsHandleNode toHandleNode, @CachedLibrary(limit="3") InteropLibrary lib) {
            GraalHPyNativeContext hpyCtx = ctx.getHPyContext().getBackend();
            Object state = ExecutionContext.IndirectCallContext.enter(frame, threadState, callData);
            try {
                Object object = lib.execute(nativeSlotCallable, new Object[]{hpyCtx, toHandleNode.execute(self)});
                return object;
            }
            catch (InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                if (frame != null) {
                    PArguments.setException((Frame)frame, threadState.getCaughtException());
                }
                ExecutionContext.IndirectCallContext.exit(frame, threadState, state);
            }
        }
    }
}

