/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PGuards.class, SpecialMethodSlot.class, ExternalFunctionNodes.PExternalFunctionWrapper.class})
@GenerateInline(value=false)
@GenerateUncached
public abstract class PySequenceGetItemNode
extends Node {
    public abstract Object execute(Frame var1, Object var2, int var3);

    public final Object execute(Object object, int index) {
        return this.execute(null, object, index);
    }

    @Specialization
    static Object doGeneric(VirtualFrame frame, Object object, int index, @Bind(value="this") Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached IndexForSqSlotInt indexForSqSlot, @Cached TpSlotSizeArgFun.CallSlotSizeArgFun callSqItem, @Cached PRaiseNode.Lazy raiseNode) {
        TpSlots slots = getSlotsNode.execute(inliningTarget, object);
        index = indexForSqSlot.execute(frame, inliningTarget, object, slots, index);
        if (slots.sq_item() != null) {
            return callSqItem.execute(frame, inliningTarget, slots.sq_item(), object, index);
        }
        throw PySequenceGetItemNode.raiseNotSupported(object, inliningTarget, raiseNode, slots);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseNotSupported(Object object, Node inliningTarget, PRaiseNode.Lazy raiseNode, TpSlots slots) {
        TruffleString message = ErrorMessages.OBJ_DOES_NOT_SUPPORT_INDEXING;
        if (slots.mp_subscript() != null) {
            message = ErrorMessages.IS_NOT_A_SEQUENCE;
        }
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, message, object);
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class IndexForSqSlotInt
    extends Node {
        IndexForSqSlotInt() {
        }

        public abstract int execute(VirtualFrame var1, Node var2, Object var3, TpSlots var4, int var5);

        @Specialization(guards={"index >= 0"})
        static int doInt(Object object, TpSlots slots, int index) {
            return index;
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static int doNegativeInt(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, int index, @Cached InlinedConditionProfile negativeIndexProfile, @Cached TpSlotLen.CallSlotLenNode callLenSlot) {
            if (negativeIndexProfile.profile(inliningTarget, index < 0) && slots.sq_length() != null) {
                int len = callLenSlot.execute(frame, inliningTarget, slots.sq_length(), object);
                index += len;
            }
            return index;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class IndexForSqSlot
    extends Node {
        IndexForSqSlot() {
        }

        public abstract int execute(VirtualFrame var1, Node var2, Object var3, TpSlots var4, Object var5);

        @Specialization
        static int doInt(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, int index, @Cached.Exclusive @Cached IndexForSqSlotInt indexForSqSlotInt) {
            return indexForSqSlotInt.execute(frame, inliningTarget, object, slots, index);
        }

        @Specialization(replaces={"doInt"})
        @HostCompilerDirectives.InliningCutoff
        static int doGeneric(VirtualFrame frame, Node inliningTarget, Object object, TpSlots slots, Object indexObj, @Cached PyIndexCheckNode checkNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Exclusive @Cached IndexForSqSlotInt indexForSqSlotInt, @Cached PRaiseNode.Lazy raiseNode) {
            if (!checkNode.execute(inliningTarget, indexObj)) {
                raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.SEQUENCE_INDEX_MUST_BE_INT_NOT_P, indexObj);
            }
            int index = asSizeNode.executeExact((Frame)frame, inliningTarget, indexObj, PythonBuiltinClassType.IndexError);
            return indexForSqSlotInt.execute(frame, inliningTarget, object, slots, index);
        }
    }
}

