/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.modules.io.PBuffered;

public class BufferedIOUtil {
    protected static final int SEEK_SET = 0;
    protected static final int SEEK_CUR = 1;
    protected static final int SEEK_END = 2;

    protected static boolean isValidWriteBuffer(PBuffered self) {
        return self.isWritable() && self.getWriteEnd() != -1;
    }

    protected static int safeDowncast(PBuffered self) {
        return self.isReadable() && self.getReadEnd() != -1 ? self.getReadEnd() - self.getPos() : 0;
    }

    protected static boolean isValidReadBuffer(PBuffered self) {
        return self.isReadable() && self.getReadEnd() != -1;
    }

    protected static int readahead(PBuffered self) {
        return self.isReadable() && BufferedIOUtil.isValidReadBuffer(self) ? self.getReadEnd() - self.getPos() : 0;
    }

    protected static long rawOffset(PBuffered self) {
        return (BufferedIOUtil.isValidReadBuffer(self) || BufferedIOUtil.isValidWriteBuffer(self)) && self.getRawPos() >= 0L ? self.getRawPos() - (long)self.getPos() : 0L;
    }

    protected static int minusLastBlock(PBuffered self, int size) {
        return self.getBufferMask() != 0 ? size & ~self.getBufferMask() : self.getBufferSize() * (size / self.getBufferSize());
    }
}

