/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.strings.TruffleString;

public class NFIZlibSupport {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(NFIZlibSupport.class);
    public static final int NO_ERROR = 0;
    public static final int DEFLATE_INIT_ERROR = 101;
    public static final int DEFLATE_END_ERROR = 102;
    public static final int DEFLATE_DICT_ERROR = 103;
    public static final int DEFLATE_OBJ_ERROR = 104;
    public static final int DEFLATE_FLUSH_ERROR = 105;
    public static final int DEFLATE_COPY_ERROR = 106;
    public static final int DEFLATE_ERROR = 107;
    public static final int INFLATE_INIT_ERROR = 201;
    public static final int INFLATE_END_ERROR = 202;
    public static final int INFLATE_DICT_ERROR = 203;
    public static final int INFLATE_OBJ_ERROR = 204;
    public static final int INFLATE_FLUSH_ERROR = 205;
    public static final int INFLATE_COPY_ERROR = 206;
    public static final int INFLATE_ERROR = 207;
    public static final int INCOMPLETE_ERROR = 99;
    public static final int MEMORY_ERROR = 999;
    public static final int OUTPUT_OPTION = 0;
    public static final int UNUSED_DATA_OPTION = 1;
    public static final int UNCONSUMED_TAIL_OPTION = 2;
    public static final int ZDICT_OPTION = 3;
    private static final String SUPPORTING_NATIVE_LIB_NAME = "zsupport";
    private final PythonContext pythonContext;
    private final NativeLibrary.TypedNativeLibrary<ZlibNativeFunctions> typedNativeLib;
    @CompilerDirectives.CompilationFinal
    private boolean available;

    private NFIZlibSupport(PythonContext context, NativeLibrary.NFIBackend backend, String noNativeAccessHelp) {
        if (context.useNativeCompressionModules()) {
            this.pythonContext = context;
            this.typedNativeLib = NativeLibrary.create((String)PythonContext.getSupportLibName(SUPPORTING_NATIVE_LIB_NAME), (Enum[])ZlibNativeFunctions.values(), (NativeLibrary.NFIBackend)backend, (String)noNativeAccessHelp, (boolean)true);
            this.available = true;
        } else {
            this.pythonContext = null;
            this.typedNativeLib = null;
            this.available = false;
        }
    }

    public static NFIZlibSupport createNative(PythonContext context, String noNativeAccessHelp) {
        return new NFIZlibSupport(context, NativeLibrary.NFIBackend.NATIVE, noNativeAccessHelp);
    }

    public static NFIZlibSupport createLLVM(PythonContext context, String noNativeAccessHelp) {
        return new NFIZlibSupport(context, NativeLibrary.NFIBackend.LLVM, noNativeAccessHelp);
    }

    @CompilerDirectives.TruffleBoundary
    public void notAvailable() {
        if (this.available) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            CompilerAsserts.neverPartOfCompilation((String)"Checking NFIZlibSupport availability should only be done during initialization.");
            this.available = false;
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    @CompilerDirectives.TruffleBoundary
    public void setAvailable() {
        if (!this.available && this.typedNativeLib != null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            CompilerAsserts.neverPartOfCompilation((String)"Checking NFIZlibSupport availability should only be done during initialization.");
            this.available = true;
        }
    }

    public Object zlibVersion() {
        return this.typedNativeLib.callUncached(this.pythonContext, ZlibNativeFunctions.zlib_get_version, new Object[0]);
    }

    public Object zlibRuntimeVersion() {
        return this.typedNativeLib.callUncached(this.pythonContext, ZlibNativeFunctions.zlib_get_runtime_version, new Object[0]);
    }

    public Object getTimeElapsed(Object zst) {
        return this.typedNativeLib.callUncached(this.pythonContext, ZlibNativeFunctions.zlib_get_timeElapsed, zst);
    }

    public Object gcReleaseHelper(Object zst) {
        return this.typedNativeLib.callUncached(this.pythonContext, ZlibNativeFunctions.zlib_gc_helper, zst);
    }

    public long crc32(long crc, byte[] buf, int len, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this.typedNativeLib, ZlibNativeFunctions.zlib_crc32, crc, buf, len);
    }

    public long adler32(long crc, byte[] buf, int len, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this.typedNativeLib, ZlibNativeFunctions.zlib_adler32, crc, buf, len);
    }

    public Object createStream(NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.call(this.typedNativeLib, ZlibNativeFunctions.zlib_create_zlib_stream, new Object[0]);
    }

    public void deallocateStream(Object zst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        invokeNode2.call(this.typedNativeLib, ZlibNativeFunctions.zlib_free_stream, zst);
    }

    public int getErrorFunction(Object zst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_get_error_type, zst);
    }

    public TruffleString getStreamErrorMsg(Object zst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callString(this.typedNativeLib, ZlibNativeFunctions.zlib_get_stream_msg, zst);
    }

    public int hasStreamErrorMsg(Object zst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_has_stream_msg, zst);
    }

    public int getEOF(Object zst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_get_eof, zst);
    }

    public int getIsInitialised(Object zst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_get_is_initialised, zst);
    }

    public int getBufferSize(Object zst, int option, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_get_buffer_size, zst, option);
    }

    public void getBuffer(Object zst, int option, byte[] dest, NativeLibrary.InvokeNativeFunction invokeNode2) {
        invokeNode2.call(this.typedNativeLib, ZlibNativeFunctions.zlib_get_off_heap_buffer, zst, option, dest);
    }

    public Object createCompObject(NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.call(this.typedNativeLib, ZlibNativeFunctions.zlib_create_compobject, new Object[0]);
    }

    public int deflateOffHeap(Object zst, byte[] in, long in_len, long buf_size, int level, int wbits, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_deflate_off_heap, zst, in, in_len, buf_size, level, wbits);
    }

    public int inflateOffHeap(Object zst, byte[] in, long in_len, long buf_size, int wbits, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_inflate_off_heap, zst, in, in_len, buf_size, wbits);
    }

    public int compressObjInitWithDict(Object zst, int level, int method, int wbits, int memLevel, int strategy, byte[] dict, long dict_len, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_Compress_init, zst, level, method, wbits, memLevel, strategy, dict, dict_len);
    }

    public int compressObjInit(Object zst, int level, int method, int wbits, int memLevel, int strategy, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_Compress_init_no_dict, zst, level, method, wbits, memLevel, strategy);
    }

    public int compressObj(Object zst, Object in, long in_len, long buf_size, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_Compress_obj, zst, in, in_len, buf_size);
    }

    public int compressObjFlush(Object zst, byte[] in, long buf_size, int mode, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_Compress_flush, zst, in, buf_size, mode);
    }

    public int compressObjCopy(Object zst, Object new_copy, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_Compress_copy, zst, new_copy);
    }

    public int decompressObjInitWithDict(Object zst, int wbits, byte[] dict, long dict_len, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_Decompress_init, zst, wbits, dict, dict_len);
    }

    public int decompressObjInit(Object zst, int wbits, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_Decompress_init_no_dict, zst, wbits);
    }

    public int decompressObj(Object zst, byte[] in, long in_len, long buf_size, long max_length, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_Decompress_obj, zst, in, in_len, buf_size, max_length);
    }

    public int decompressObjFlush(Object zst, long length, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_Decompress_flush, zst, length);
    }

    public int decompressObjCopy(Object zst, Object new_copy, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_Decompress_copy, zst, new_copy);
    }

    public int decompressor(Object zst, byte[] data, long len, long max_length, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, ZlibNativeFunctions.zlib_decompress, zst, data, len, max_length);
    }

    static enum ZlibNativeFunctions implements NativeLibrary.NativeFunction
    {
        zlib_get_version("(): STRING"),
        zlib_get_runtime_version("(): STRING"),
        zlib_crc32("(UINT64, [UINT8], UINT32): UINT64"),
        zlib_adler32("(UINT64, [UINT8], UINT32): UINT64"),
        zlib_create_zlib_stream("(): POINTER"),
        zlib_get_timeElapsed("(POINTER): DOUBLE"),
        zlib_free_stream("(POINTER): VOID"),
        zlib_gc_helper("(POINTER): VOID"),
        zlib_get_error_type("(POINTER): SINT32"),
        zlib_get_stream_msg("(POINTER): STRING"),
        zlib_has_stream_msg("(POINTER): SINT32"),
        zlib_get_eof("(POINTER): SINT32"),
        zlib_get_is_initialised("(POINTER): SINT32"),
        zlib_get_buffer_size("(POINTER, SINT32): UINT32"),
        zlib_get_off_heap_buffer("(POINTER, SINT32, [UINT8]): VOID"),
        zlib_create_compobject("(): POINTER"),
        zlib_deflate_off_heap("(POINTER, [UINT8], SINT64, SINT64, SINT32, SINT32): SINT32"),
        zlib_inflate_off_heap("(POINTER, [UINT8], SINT64, SINT64, SINT32): SINT32"),
        zlib_Compress_init("(POINTER, SINT32, SINT32, SINT32, SINT32, SINT32, [UINT8], UINT64): SINT32"),
        zlib_Compress_init_no_dict("(POINTER, SINT32, SINT32, SINT32, SINT32, SINT32): SINT32"),
        zlib_Compress_obj("(POINTER, [UINT8], SINT64, SINT64): SINT32"),
        zlib_Compress_flush("(POINTER, [UINT8], SINT64, SINT32): SINT32"),
        zlib_Compress_copy("(POINTER, POINTER): SINT32"),
        zlib_Decompress_init("(POINTER, SINT32, [UINT8], UINT64): SINT32"),
        zlib_Decompress_init_no_dict("(POINTER, SINT32): SINT32"),
        zlib_Decompress_obj("(POINTER, [UINT8], SINT64, SINT64, SINT64): SINT32"),
        zlib_Decompress_flush("(POINTER, SINT64): SINT32"),
        zlib_Decompress_copy("(POINTER, POINTER): SINT32"),
        zlib_decompress("(POINTER, [UINT8], SINT64, SINT64): SINT32");

        private final String signature;

        private ZlibNativeFunctions(String signature) {
            this.signature = signature;
        }

        @Override
        public String signature() {
            return this.signature;
        }
    }

    public static class Pointer
    extends AsyncHandler.SharedFinalizer.FinalizableReference {
        private final NFIZlibSupport lib;

        public Pointer(Object referent, Object ptr, NFIZlibSupport lib) {
            super(referent, ptr, lib.pythonContext.getSharedFinalizer());
            this.lib = lib;
        }

        protected void doRelease() {
            this.lib.gcReleaseHelper(this.getReference());
        }

        @Override
        public AsyncHandler.AsyncAction release() {
            if (!this.isReleased()) {
                return new PointerReleaseCallback(this);
            }
            return null;
        }
    }

    static class PointerReleaseCallback
    implements AsyncHandler.AsyncAction {
        private final Pointer pointer;

        public PointerReleaseCallback(Pointer pointer) {
            this.pointer = pointer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(PythonContext context) {
            Pointer pointer = this.pointer;
            synchronized (pointer) {
                if (this.pointer.isReleased()) {
                    return;
                }
                try {
                    this.pointer.doRelease();
                    this.pointer.markReleased();
                    LOGGER.finest("NFIZlibSupport pointer has been freed");
                }
                catch (Exception e) {
                    LOGGER.severe("Error while trying to free NFIZlibSupport pointer: " + e.getMessage());
                }
            }
        }
    }
}

