/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.hisp.dhis.Dhis2AsyncRequest;
import org.hisp.dhis.Dhis2Config;
import org.hisp.dhis.model.Dhis2Objects;
import org.hisp.dhis.model.IdentifiableObject;
import org.hisp.dhis.model.completedatasetregistration.CompleteDataSetRegistrationImportOptions;
import org.hisp.dhis.model.datavalueset.DataValueSetImportOptions;
import org.hisp.dhis.model.event.EventsResult;
import org.hisp.dhis.model.validation.Validation;
import org.hisp.dhis.query.Filter;
import org.hisp.dhis.query.Operator;
import org.hisp.dhis.query.Order;
import org.hisp.dhis.query.Paging;
import org.hisp.dhis.query.Query;
import org.hisp.dhis.query.RootJunction;
import org.hisp.dhis.query.analytics.AnalyticsQuery;
import org.hisp.dhis.query.analytics.Dimension;
import org.hisp.dhis.query.completedatasetregistration.CompleteDataSetRegistrationQuery;
import org.hisp.dhis.query.datavalue.DataValueQuery;
import org.hisp.dhis.query.datavalue.DataValueSetQuery;
import org.hisp.dhis.query.event.EventsQuery;
import org.hisp.dhis.query.validations.DataSetValidationQuery;
import org.hisp.dhis.response.BaseHttpResponse;
import org.hisp.dhis.response.Dhis2ClientException;
import org.hisp.dhis.response.HttpStatus;
import org.hisp.dhis.response.Response;
import org.hisp.dhis.response.Status;
import org.hisp.dhis.response.completedatasetregistration.CompleteDataSetRegistrationResponse;
import org.hisp.dhis.response.object.ObjectResponse;
import org.hisp.dhis.response.objects.ObjectsResponse;
import org.hisp.dhis.util.CollectionUtils;
import org.hisp.dhis.util.HttpUtils;
import org.hisp.dhis.util.JacksonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDhis2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseDhis2.class);
    protected static final String FIELDS_PARAM = "fields";
    protected static final String SKIP_SHARING_PARAM = "skipSharing";
    protected static final String ID_FIELDS = "id,code,name,created,lastUpdated,attributeValues";
    protected static final String NAME_FIELDS = String.format("%s,shortName,description", "id,code,name,created,lastUpdated,attributeValues");
    private static final String SEP_DIM = ";";
    protected static final String OPTION_SET_FIELDS = String.format("%s,valueType,version", "id,code,name,created,lastUpdated,attributeValues");
    protected static final String DATA_ELEMENT_FIELDS = String.format("%1$s,aggregationType,valueType,domainType,url,legendSets[%1$s],optionSet[%2$s]", NAME_FIELDS, OPTION_SET_FIELDS);
    protected static final String DATA_ELEMENT_GROUP_SET_FIELDS = String.format("%1$s,compulsory,dataDimension,dimensionType,dataElementGroups[%1$s]", NAME_FIELDS);
    protected static final String CATEGORY_OPTION_FIELDS = String.format("%1$s,shortName,startDate,endDate,formName,categories[%1$s],organisationUnits[%1$s]", NAME_FIELDS);
    protected static final String CATEGORY_OPTION_COMBO_FIELDS = String.format("%1$s,ignoreApproval,dimensionItem,categoryOptions[%1$s]", "id,code,name,created,lastUpdated,attributeValues");
    protected static final String CATEGORY_OPTION_GROUP_FIELDS = String.format("%1$s,dataDimensionType,dimensionItemType,categoryOptions[%2$s],groupSets[%2$s]", NAME_FIELDS, "id,code,name,created,lastUpdated,attributeValues");
    protected static final String CATEGORY_OPTION_GROUP_SET_FIELDS = String.format("%1$s,dataDimension,dataDimensionType,categoryOptionGroups[%2$s]", NAME_FIELDS, "id,code,name,created,lastUpdated,attributeValues");
    protected static final String CATEGORY_COMBO_FIELDS = String.format("%1$s,dataDimensionType,skipTotal,categories[%1$s],categoryOptionCombos[%2$s]", "id,code,name,created,lastUpdated,attributeValues", CATEGORY_OPTION_COMBO_FIELDS);
    protected static final String CATEGORY_FIELDS = String.format("%1$s,dataDimensionType,dataDimension,categoryOptions[%2$s],categoryCombos[%2$s]", NAME_FIELDS, "id,code,name,created,lastUpdated,attributeValues");
    protected static final String INDICATOR_TYPE_FIELDS = String.format("%s,factor,number", NAME_FIELDS);
    protected static final String INDICATOR_FIELDS = String.format("%1$s,annualized,numerator,numeratorDescription,denominator,denominatorDescription,url,indicatorType[%2$s]", NAME_FIELDS, INDICATOR_TYPE_FIELDS);
    protected static final String INDICATOR_GROUP_SET_FIELDS = String.format("%1$s,compulsory,indicatorGroups[%1$s]", NAME_FIELDS);
    protected static final String DATA_SET_FIELDS = String.format("%1$s,formName,displayFormName,categoryCombo[%1$s],dataSetElements[dataSet[%1$s],dataElement[%1$s],categoryCombo[%1$s]],dimensionItem,openFuturePeriods,expiryDays,timelyDays,url,formType,periodType,version,dimensionItemType,aggregationType,favorite,compulsoryFieldsCompleteOnly,skipOffline,validCompleteOnly,dataElementDecoration,openPeriodsAfterCoEndDate,notifyCompletingUser,noValueRequiresComment,fieldCombinationRequired,mobile,dataEntryForm[%2$s]", NAME_FIELDS, "id,code,name,created,lastUpdated,attributeValues");
    protected static final String ORG_UNIT_FIELDS = String.format("%s,path,level,parent[%s],openingDate,closedDate,comment,url,contactPerson,address,email,phoneNumber", NAME_FIELDS, NAME_FIELDS);
    protected static final String ORG_UNIT_GROUP_SET_FIELDS = String.format("%1$s,dataDimension,compulsory,organisationUnitGroups[%2$s]", NAME_FIELDS, "id,code,name,created,lastUpdated,attributeValues");
    protected static final String TRACKED_ENTITY_ATTRIBUTE_FIELDS = String.format("%s,valueType,confidential,unique", NAME_FIELDS);
    protected static final String PROGRAM_STAGE_DATA_ELEMENT_FIELDS = String.format("%s,dataElement[%s],compulsory,displayInReports,skipSynchronization,skipAnalytics", NAME_FIELDS, DATA_ELEMENT_FIELDS);
    protected static final String TRACKED_ENTITY_TYPE_FIELDS = String.format("%s,trackedEntityTypeAttributes[id,trackedEntityAttribute[%s],displayInList,mandatory,searchable]", NAME_FIELDS, TRACKED_ENTITY_ATTRIBUTE_FIELDS);
    protected static final String PROGRAM_FIELDS = String.format("%1$s,programType,trackedEntityType[%2$s],categoryCombo[%1$s,categories[%3$s]],programStages[%1$s,programStageDataElements[%4$s]],programTrackedEntityAttributes[id,code,name,trackedEntityAttribute[%5$s]]", NAME_FIELDS, TRACKED_ENTITY_TYPE_FIELDS, CATEGORY_FIELDS, PROGRAM_STAGE_DATA_ELEMENT_FIELDS, TRACKED_ENTITY_ATTRIBUTE_FIELDS);
    protected static final String DASHBOARD_FIELDS = String.format("%1$s,embedded[*]", NAME_FIELDS);
    protected static final String ME_FIELDS = String.format("%1$s,username,surname,firstName,email,settings,programs,dataSets,authorities,organisationUnits[%2$s]", "id,code,name,created,lastUpdated,attributeValues", ORG_UNIT_FIELDS);
    private static final String LOG_LEVEL_SYSTEM_PROPERTY = "log.level.dhis2";
    private static final String LOG_LEVEL_INFO = "info";
    private static final String LOG_LEVEL_WARN = "warn";
    private static final Set<Integer> ERROR_STATUS_CODES = Set.of(Integer.valueOf(401), Integer.valueOf(403), Integer.valueOf(404));
    protected static final String DATA_SET_PARAM = "dataSet";
    protected static final String VALIDATION_SIDE_FIELDS = "expression,description,displayDescription,slidingWindow,missingValueStrategy";
    protected static final String VALIDATION_RULE_FIELDS = String.format("%1$s,dimensionItem,instruction,importance,periodType,displayDescription,displayInstruction,displayName,leftSide[%2$s],operator,rightSide[%2$s],skipFormValidation,legendSets", NAME_FIELDS, "expression,description,displayDescription,slidingWindow,missingValueStrategy");
    protected static final String DATA_SET_VALIDATION_FIELDS = String.format("id,leftsideValue,rightsideValue,dayInPeriod,notificationSent,validationRule[%1$s],period[%2$s],organisationUnit[%2$s],attributeOptionCombo[%2$s]", VALIDATION_RULE_FIELDS, "id,code,name,created,lastUpdated,attributeValues");
    protected final Dhis2Config config;
    protected final ObjectMapper objectMapper;
    protected final CloseableHttpClient httpClient;

    public BaseDhis2(Dhis2Config config) {
        Objects.requireNonNull(config, "Config must be specified");
        this.config = config;
        this.objectMapper = JacksonUtils.getObjectMapper();
        this.httpClient = HttpClients.createDefault();
    }

    protected <T> T getObject(URIBuilder uriBuilder, Query query, Class<T> type) {
        URI url = this.getObjectQuery(uriBuilder, query);
        return this.getObjectFromUrl(url, type);
    }

    protected boolean objectExists(URIBuilder uriBuilder) {
        boolean bl;
        block8: {
            HttpHead request = this.withAuth(new HttpHead(HttpUtils.build(uriBuilder)));
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);
            try {
                boolean bl2 = bl = HttpStatus.OK.value() == response.getCode();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    protected URI getObjectQuery(URIBuilder uriBuilder, Query query) {
        List<Order> orders;
        Paging paging;
        for (Filter filter : query.getFilters()) {
            String filterValue = String.format("%s:%s:%s", filter.getProperty(), filter.getOperator().value(), this.getQueryValue(filter));
            uriBuilder.addParameter("filter", filterValue);
        }
        if (!query.getFilters().isEmpty() && query.getRootJunction() == RootJunction.OR) {
            uriBuilder.addParameter("rootJunction", "OR");
        }
        if ((paging = query.getPaging()).hasPaging()) {
            if (paging.hasPage()) {
                uriBuilder.addParameter("page", String.valueOf(paging.getPage()));
            }
            if (paging.hasPageSize()) {
                uriBuilder.addParameter("pageSize", String.valueOf(paging.getPageSize()));
            }
        } else {
            uriBuilder.addParameter("paging", "false");
        }
        if (!(orders = query.getOrder()).isEmpty()) {
            String orderValue = query.getOrder().stream().map(Order::toValue).collect(Collectors.joining(","));
            uriBuilder.addParameter("order", orderValue);
        }
        return HttpUtils.build(uriBuilder);
    }

    protected <T> T getDataValueSetResponse(URIBuilder uriBuilder, DataValueSetQuery query, Class<T> type) {
        URI url = this.getDataValueSetQuery(uriBuilder, query);
        return this.getObjectFromUrl(url, type);
    }

    protected Validation getDataSetValidationResponse(URIBuilder uriBuilder, DataSetValidationQuery query) {
        URI url = this.getDataSetValidationQuery(uriBuilder, query);
        return this.getObjectFromUrl(url, Validation.class);
    }

    protected String getDataValueFileResponse(URIBuilder uriBuilder, DataValueQuery query) {
        URI url = this.getDataValueQuery(uriBuilder, query);
        return this.getObjectFromUrl(url, String.class);
    }

    protected <T> T getAnalyticsResponse(URIBuilder uriBuilder, AnalyticsQuery query, Class<T> type) {
        URI url = this.getAnalyticsQuery(uriBuilder, query);
        return this.getObjectFromUrl(url, type);
    }

    protected URI getAnalyticsQuery(URIBuilder uriBuilder, AnalyticsQuery query) {
        for (Dimension dimension : query.getDimensions()) {
            this.addParameter(uriBuilder, "dimension", dimension.getDimensionValue());
        }
        for (Dimension filter : query.getFilters()) {
            this.addParameter(uriBuilder, "filter", filter.getDimensionValue());
        }
        this.addParameter(uriBuilder, "aggregationType", (Object)query.getAggregationType());
        this.addParameter(uriBuilder, "startDate", query.getStartDate());
        this.addParameter(uriBuilder, "endDate", query.getEndDate());
        this.addParameter(uriBuilder, "skipMeta", query.getSkipMeta());
        this.addParameter(uriBuilder, "skipData", query.getSkipData());
        this.addParameter(uriBuilder, "skipRounding", query.getSkipRounding());
        this.addParameter(uriBuilder, "ignoreLimit", query.getIgnoreLimit());
        this.addParameter(uriBuilder, "tableLayout", query.getTableLayout());
        this.addParameter(uriBuilder, "showHierarchy", query.getShowHierarchy());
        this.addParameter(uriBuilder, "includeNumDen", query.getIncludeNumDen());
        this.addParameter(uriBuilder, "includeMetadataDetails", query.getIncludeMetadataDetails());
        this.addParameter(uriBuilder, "outputIdScheme", query.getOutputIdScheme());
        this.addParameter(uriBuilder, "outputOrgUnitIdScheme", query.getOutputOrgUnitIdScheme());
        this.addParameter(uriBuilder, "outputDataElementIdScheme", query.getOutputDataElementIdScheme());
        this.addParameter(uriBuilder, "inputIdScheme", query.getInputIdScheme());
        if (query.hasColumns()) {
            this.addParameter(uriBuilder, "columns", String.join((CharSequence)SEP_DIM, query.getColumns()));
        }
        if (query.hasRows()) {
            this.addParameter(uriBuilder, "rows", String.join((CharSequence)SEP_DIM, query.getRows()));
        }
        return HttpUtils.build(uriBuilder);
    }

    protected URI getDataValueSetImportQuery(URIBuilder uriBuilder, DataValueSetImportOptions options) {
        this.addParameter(uriBuilder, "async", "true");
        this.addParameter(uriBuilder, "dataElementIdScheme", options.getDataElementIdScheme());
        this.addParameter(uriBuilder, "orgUnitIdScheme", options.getOrgUnitIdScheme());
        this.addParameter(uriBuilder, "categoryOptionComboIdScheme", options.getCategoryOptionComboIdScheme());
        this.addParameter(uriBuilder, "idScheme", options.getIdScheme());
        this.addParameter(uriBuilder, "dryRun", options.getDryRun());
        this.addParameter(uriBuilder, "preheatCache", options.getPreheatCache());
        this.addParameter(uriBuilder, "skipAudit", options.getSkipAudit());
        return HttpUtils.build(uriBuilder);
    }

    protected CompleteDataSetRegistrationResponse saveCompleteDataSetRegistrations(HttpEntity entity, CompleteDataSetRegistrationImportOptions options) {
        URIBuilder builder = this.config.getResolvedUriBuilder().appendPath("completeDataSetRegistrations");
        URI url = this.getCompleteDataSetRegistrationsImportQuery(builder, options);
        HttpPost request = this.getPostRequest(url, entity);
        Dhis2AsyncRequest asyncRequest = new Dhis2AsyncRequest(this.config, this.httpClient, this.objectMapper);
        return asyncRequest.post(request, CompleteDataSetRegistrationResponse.class);
    }

    protected EventsResult getEventsResponse(URIBuilder uriBuilder, EventsQuery query) {
        URI url = this.getEventsQuery(uriBuilder, query);
        return this.getObjectFromUrl(url, EventsResult.class);
    }

    protected URI getEventsQuery(URIBuilder uriBuilder, EventsQuery query) {
        this.addParameter(uriBuilder, "program", query.getProgram());
        this.addParameter(uriBuilder, "programStage", query.getProgramStage());
        this.addParameter(uriBuilder, "programStatus", (Object)query.getProgramStatus());
        this.addParameter(uriBuilder, "followUp", query.getFollowUp());
        this.addParameter(uriBuilder, "trackedEntityInstance", query.getTrackedEntityInstance());
        this.addParameter(uriBuilder, "orgUnit", query.getOrgUnit());
        this.addParameter(uriBuilder, "ouMode", (Object)query.getOuMode());
        this.addParameter(uriBuilder, "status", (Object)query.getStatus());
        this.addParameter(uriBuilder, "occuredAfter", query.getOccurredAfter());
        this.addParameter(uriBuilder, "occuredBefore", query.getOccurredBefore());
        this.addParameter(uriBuilder, "scheduledAfter", query.getScheduledAfter());
        this.addParameter(uriBuilder, "scheduledBefore", query.getScheduledBefore());
        this.addParameter(uriBuilder, "updatedAfter", query.getUpdatedAfter());
        this.addParameter(uriBuilder, "updatedBefore", query.getUpdatedBefore());
        this.addParameter(uriBuilder, "dataElementIdScheme", query.getDataElementIdScheme());
        this.addParameter(uriBuilder, "categoryOptionComboIdScheme", query.getCategoryOptionComboIdScheme());
        this.addParameter(uriBuilder, "orgUnitIdScheme", query.getOrgUnitIdScheme());
        this.addParameter(uriBuilder, "programIdScheme", query.getProgramIdScheme());
        this.addParameter(uriBuilder, "programStageIdScheme", query.getProgramStageIdScheme());
        this.addParameter(uriBuilder, "idScheme", query.getIdScheme());
        return HttpUtils.build(uriBuilder);
    }

    protected URI getDataValueSetQuery(URIBuilder uriBuilder, DataValueSetQuery query) {
        for (String dataElement : query.getDataElements()) {
            this.addParameter(uriBuilder, "dataElement", dataElement);
        }
        for (String orgUnit : query.getOrgUnits()) {
            this.addParameter(uriBuilder, "orgUnit", orgUnit);
        }
        for (String period : query.getPeriods()) {
            this.addParameter(uriBuilder, "period", period);
        }
        for (String dataSet : query.getDataSets()) {
            this.addParameter(uriBuilder, DATA_SET_PARAM, dataSet);
        }
        for (String dataElementGroup : query.getDataElementGroups()) {
            this.addParameter(uriBuilder, "dataElementGroup", dataElementGroup);
        }
        for (String orgUnitGroup : query.getOrgUnitGroups()) {
            this.addParameter(uriBuilder, "orgUnitGroup", orgUnitGroup);
        }
        for (String attributeOptionCombo : query.getAttributeOptionCombos()) {
            this.addParameter(uriBuilder, "attributeOptionCombo", attributeOptionCombo);
        }
        this.addParameter(uriBuilder, "startDate", query.getStartDate());
        this.addParameter(uriBuilder, "endDate", query.getEndDate());
        this.addParameter(uriBuilder, "children", query.getChildren());
        this.addParameter(uriBuilder, "includeDeleted", query.getIncludeDeleted());
        this.addParameter(uriBuilder, "lastUpdated", query.getLastUpdated());
        this.addParameter(uriBuilder, "lastUpdatedDuration", query.getLastUpdatedDuration());
        this.addParameter(uriBuilder, "limit", query.getLimit());
        this.addParameter(uriBuilder, "dataElementIdScheme", query.getDataElementIdScheme());
        this.addParameter(uriBuilder, "orgUnitIdScheme", query.getOrgUnitIdScheme());
        this.addParameter(uriBuilder, "categoryOptionComboIdScheme", query.getCategoryOptionComboIdScheme());
        this.addParameter(uriBuilder, "attributeOptionComboIdScheme", query.getAttributeOptionComboIdScheme());
        this.addParameter(uriBuilder, "dataSetIdScheme", query.getDataSetIdScheme());
        this.addParameter(uriBuilder, "categoryIdScheme", query.getCategoryIdScheme());
        this.addParameter(uriBuilder, "categoryOptionIdScheme", query.getCategoryOptionIdScheme());
        this.addParameter(uriBuilder, "idScheme", query.getIdScheme());
        this.addParameter(uriBuilder, "inputOrgUnitIdScheme", query.getInputOrgUnitIdScheme());
        this.addParameter(uriBuilder, "inputDataSetIdScheme", query.getInputDataSetIdScheme());
        this.addParameter(uriBuilder, "inputDataElementGroupIdScheme", query.getInputDataElementGroupIdScheme());
        this.addParameter(uriBuilder, "inputDataElementIdScheme", query.getInputDataElementIdScheme());
        this.addParameter(uriBuilder, "inputIdScheme", query.getInputIdScheme());
        return HttpUtils.build(uriBuilder);
    }

    protected URI getDataValueQuery(URIBuilder uriBuilder, DataValueQuery query) {
        this.addParameter(uriBuilder, "de", query.getDe());
        this.addParameter(uriBuilder, "pe", query.getPe());
        this.addParameter(uriBuilder, "ou", query.getOu());
        this.addParameter(uriBuilder, "co", query.getCo());
        this.addParameter(uriBuilder, "cc", query.getCc());
        if (!query.getCp().isEmpty()) {
            this.addParameter(uriBuilder, "cp", String.join((CharSequence)SEP_DIM, query.getCp()));
        }
        this.addParameter(uriBuilder, "ds", query.getDs());
        return HttpUtils.build(uriBuilder);
    }

    protected URI getDataSetValidationQuery(URIBuilder uriBuilder, DataSetValidationQuery query) {
        this.addParameter(uriBuilder, "pe", query.getPe());
        this.addParameter(uriBuilder, "ou", query.getOu());
        return HttpUtils.build(uriBuilder);
    }

    protected URI getCompleteDataSetRegistrationQuery(URIBuilder uriBuilder, CompleteDataSetRegistrationQuery query) {
        for (String dataSet : query.getDataSets()) {
            this.addParameter(uriBuilder, DATA_SET_PARAM, dataSet);
        }
        for (String period : query.getPeriods()) {
            this.addParameter(uriBuilder, "period", period);
        }
        this.addParameter(uriBuilder, "startDate", query.getStartDate());
        this.addParameter(uriBuilder, "endDate", query.getEndDate());
        this.addParameter(uriBuilder, "created", query.getCreated());
        this.addParameter(uriBuilder, "createdDuration", query.getCreatedDuration());
        for (String orgUnit : query.getOrgUnits()) {
            this.addParameter(uriBuilder, "orgUnit", orgUnit);
        }
        this.addParameter(uriBuilder, "orgUnitGroup", query.getOrgUnitGroup());
        this.addParameter(uriBuilder, "children", query.getChildren());
        this.addParameter(uriBuilder, "limit", query.getLimit());
        this.addParameter(uriBuilder, "idScheme", query.getIdScheme());
        this.addParameter(uriBuilder, "orgUnitIdScheme", query.getOrgUnitIdScheme());
        this.addParameter(uriBuilder, "dataSetIdScheme", query.getDataSetIdScheme());
        this.addParameter(uriBuilder, "attributeOptionComboIdScheme", query.getAttributeOptionComboIdScheme());
        return HttpUtils.build(uriBuilder);
    }

    private URI getCompleteDataSetRegistrationsImportQuery(URIBuilder uriBuilder, CompleteDataSetRegistrationImportOptions options) {
        this.addParameter(uriBuilder, "async", "true");
        this.addParameter(uriBuilder, "dataSetIdScheme", options.getDataSetIdScheme());
        this.addParameter(uriBuilder, "orgUnitIdScheme", options.getOrgUnitIdScheme());
        this.addParameter(uriBuilder, "attributeOptionComboIdScheme", options.getAttributeOptionComboIdScheme());
        this.addParameter(uriBuilder, "idScheme", options.getIdScheme());
        this.addParameter(uriBuilder, "preheatCache", options.getPreheatCache());
        this.addParameter(uriBuilder, "dryRun", options.getDryRun());
        this.addParameter(uriBuilder, "importStrategy", (Object)options.getImportStrategy());
        this.addParameter(uriBuilder, "skipExistingCheck", options.getSkipExistingCheck());
        return HttpUtils.build(uriBuilder);
    }

    private void addParameter(URIBuilder uriBuilder, String parameter, Object value) {
        if (value != null) {
            uriBuilder.addParameter(parameter, value.toString());
        }
    }

    private Object getQueryValue(Filter filter) {
        if (Operator.IN == filter.getOperator()) {
            return "[" + String.valueOf(filter.getValue()) + "]";
        }
        return filter.getValue();
    }

    protected <T> T getObject(String path, String id, Class<T> type) {
        try {
            URI url = this.config.getResolvedUriBuilder().appendPath(path).appendPath(id).build();
            return this.getObjectFromUrl(url, type);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected <T extends BaseHttpResponse> T executeJsonPostPutRequest(HttpUriRequestBase request, Object object, Class<T> type) {
        this.validateRequestObject(object);
        String requestBody = this.toJsonString(object);
        this.log("Request URI: '{}', body: '{}'", HttpUtils.getUriAsString((BasicHttpRequest)request), requestBody);
        StringEntity entity = new StringEntity(requestBody, StandardCharsets.UTF_8);
        request.setHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.getMimeType());
        request.setEntity((HttpEntity)entity);
        return this.executeRequest(request, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends BaseHttpResponse> T executeRequest(HttpUriRequestBase request, Class<T> type) {
        this.withAuth(request);
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);){
            this.handleErrors((HttpResponse)response, request.getRequestUri());
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            this.log("Response body: '{}'", responseBody);
            BaseHttpResponse responseMessage = (BaseHttpResponse)this.objectMapper.readValue(responseBody, type);
            responseMessage.setHeaders(CollectionUtils.asList(response.getHeaders()));
            responseMessage.setHttpStatusCode(response.getCode());
            BaseHttpResponse baseHttpResponse = responseMessage;
            return (T)baseHttpResponse;
        }
        catch (IOException ex) {
            throw this.newDhis2ClientException(ex);
        }
        catch (ParseException ex) {
            throw new Dhis2ClientException("HTTP response could not be parsed", ex);
        }
    }

    protected Response executeRequest(HttpUriRequestBase request) {
        Response response;
        block8: {
            this.withAuth(request);
            CloseableHttpResponse response2 = this.httpClient.execute((ClassicHttpRequest)request);
            try {
                this.handleErrors((HttpResponse)response2, request.getRequestUri());
                HttpStatus httpStatus = HttpStatus.valueOf(response2.getCode());
                Status status = httpStatus != null && httpStatus.is2xxSuccessful() ? Status.OK : Status.ERROR;
                Response resp = new Response();
                resp.setHeaders(CollectionUtils.asList(response2.getHeaders()));
                resp.setStatus(status);
                resp.setHttpStatusCode(response2.getCode());
                response = resp;
                if (response2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw this.newDhis2ClientException(ex);
                }
            }
            response2.close();
        }
        return response;
    }

    protected HttpPost getPostRequest(URI url, HttpEntity entity) {
        HttpPost request = this.withAuth(new HttpPost(url));
        request.setHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.getMimeType());
        request.setEntity(entity);
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T getObjectFromUrl(URI url, Class<T> type) {
        try (CloseableHttpResponse response = this.getJsonHttpResponse(url);){
            this.handleErrors((HttpResponse)response, url.toString());
            this.handleErrorsForGet(response, url.toString());
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            this.log("Response body: '{}'", responseBody);
            if (type == String.class) {
                String string = responseBody;
                return (T)string;
            }
            T t = this.readValue(responseBody, type);
            return t;
        }
        catch (IOException ex) {
            throw new Dhis2ClientException("Failed to fetch object", ex);
        }
        catch (ParseException ex) {
            throw new Dhis2ClientException("HTTP response could not be parsed", ex);
        }
    }

    protected CloseableHttpResponse getJsonHttpResponse(URI url) {
        HttpGet request = this.withAuth(new HttpGet(url));
        request.setHeader("Accept", (Object)ContentType.APPLICATION_JSON.getMimeType());
        this.log("Get request URL: '{}'", HttpUtils.asString(url));
        try {
            return this.httpClient.execute((ClassicHttpRequest)request);
        }
        catch (IOException ex) {
            throw new Dhis2ClientException("Request failed", ex);
        }
    }

    private void handleErrors(HttpResponse response, String url) {
        int code = response.getCode();
        if (ERROR_STATUS_CODES.contains(code)) {
            String message = String.format("%s (%d)", this.getErrorMessage(code), code);
            this.log("Error URL: '{}'", url);
            throw new Dhis2ClientException(message, code);
        }
    }

    private void handleErrorsForGet(CloseableHttpResponse response, String url) throws IOException, ParseException {
        int code = response.getCode();
        if (409 == code) {
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            this.log("Conflict response body: '{}'", responseBody);
            Response objectResponse = this.readValue(responseBody, Response.class);
            throw new Dhis2ClientException(objectResponse.getMessage(), code);
        }
    }

    protected <T> T readValue(String content, Class<T> type) throws IOException {
        return (T)this.objectMapper.readValue(content, type);
    }

    private String getErrorMessage(int code) {
        if (401 == code) {
            return "Authentication failed";
        }
        if (403 == code) {
            return "Access was denied";
        }
        if (404 == code) {
            return "Object not found";
        }
        if (409 == code) {
            return "Conflict";
        }
        if (code >= 400 && code < 500) {
            return "Client error";
        }
        if (code >= 500 && code < 600) {
            return "Server error";
        }
        return "Error";
    }

    private void validateRequestObject(Object object) {
        if (object == null) {
            throw new Dhis2ClientException("Request object is null", 400);
        }
    }

    protected void writeToFile(CloseableHttpResponse response, File file) {
        try (FileOutputStream fileOut = FileUtils.openOutputStream((File)file);
             InputStream in = response.getEntity().getContent();){
            IOUtils.copy((InputStream)in, (OutputStream)fileOut);
        }
        catch (IOException ex) {
            throw new Dhis2ClientException("Failed to write to file", ex);
        }
    }

    protected <T extends HttpUriRequestBase> T withAuth(T request) {
        return HttpUtils.withAuth(request, this.config);
    }

    protected String toJsonString(Object object) {
        try {
            String json = this.objectMapper.writeValueAsString(object);
            this.log("Object JSON: '{}'", json);
            return json;
        }
        catch (IOException ex) {
            throw new Dhis2ClientException("Failed to deserialize JSON", ex);
        }
    }

    protected Dhis2ClientException newDhis2ClientException(IOException ex) {
        int statusCode = -1;
        if (ex instanceof HttpResponseException) {
            statusCode = ((HttpResponseException)ex).getStatusCode();
        }
        return new Dhis2ClientException(ex.getMessage(), ex.getCause(), statusCode);
    }

    protected ObjectResponse saveMetadataObject(String path, IdentifiableObject object) {
        return this.saveObject(path, (Object)object, ObjectResponse.class);
    }

    protected <T extends BaseHttpResponse> T saveObject(String path, Object object, Class<T> type) {
        URI url = this.config.getResolvedUrl(path);
        return this.executeJsonPostPutRequest((HttpUriRequestBase)new HttpPost(url), object, type);
    }

    protected <T extends BaseHttpResponse> T saveObject(URIBuilder uriBuilder, Object object, Class<T> type) {
        URI url = HttpUtils.build(uriBuilder);
        return this.executeJsonPostPutRequest((HttpUriRequestBase)new HttpPost(url), object, type);
    }

    protected ObjectsResponse saveMetadataObjects(Dhis2Objects objects) {
        URI url = this.config.getResolvedUrl("metadata");
        return this.executeJsonPostPutRequest((HttpUriRequestBase)new HttpPost(url), objects, ObjectsResponse.class);
    }

    protected ObjectResponse updateMetadataObject(String path, IdentifiableObject object) {
        Map<String, String> params = Map.of(SKIP_SHARING_PARAM, "true");
        return this.updateObject(path, params, object, ObjectResponse.class);
    }

    protected <T extends BaseHttpResponse> T updateObject(String path, Map<String, String> params, Object object, Class<T> type) {
        try {
            URI url = this.config.getResolvedUriBuilder().appendPath(path).addParameters(this.toNameValuePairs(params)).build();
            return this.executeJsonPostPutRequest((HttpUriRequestBase)new HttpPut(url), object, type);
        }
        catch (URISyntaxException ex) {
            throw new Dhis2ClientException("Invalid URI syntax", ex);
        }
    }

    protected ObjectResponse removeMetadataObject(String path) {
        return this.removeObject(path, ObjectResponse.class);
    }

    protected <T extends BaseHttpResponse> T removeObject(String path, Class<T> type) {
        URI url = this.config.getResolvedUrl(path);
        return this.executeRequest((HttpUriRequestBase)new HttpDelete(url), type);
    }

    protected <T> T getObject(String path, Class<T> type) {
        return this.getObjectFromUrl(this.config.getResolvedUrl(path), type);
    }

    protected List<NameValuePair> toNameValuePairs(Map<String, String> params) {
        return params.entrySet().stream().map(p -> new BasicNameValuePair((String)p.getKey(), (String)p.getValue())).collect(Collectors.toList());
    }

    protected Response addToCollection(String path, String id, String collection, String item) {
        URI url = HttpUtils.build(this.config.getResolvedUriBuilder().appendPath(path).appendPath(id).appendPath(collection).appendPath(item));
        Response response = this.executeRequest((HttpUriRequestBase)new HttpPost(url));
        Status status = response != null && response.getHttpStatus() != null && response.getHttpStatus().is2xxSuccessful() ? Status.OK : Status.ERROR;
        return new Response(status, response.getHttpStatusCode(), response.getMessage());
    }

    private void log(String format, Object ... arguments) {
        String logLevel = System.getProperty(LOG_LEVEL_SYSTEM_PROPERTY);
        if (LOG_LEVEL_INFO.equalsIgnoreCase(logLevel)) {
            log.info(format, arguments);
        } else if (LOG_LEVEL_WARN.equalsIgnoreCase(logLevel)) {
            log.warn(format, arguments);
        } else {
            log.debug(format, arguments);
        }
    }
}

