/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.hisp.dhis.auth.Authentication;
import org.hisp.dhis.auth.BasicAuthentication;
import org.hisp.dhis.response.Dhis2ClientException;

public class Dhis2Config {
    private final String url;
    private final Authentication authentication;

    public Dhis2Config(String url, String username, String password) {
        Objects.requireNonNull(url);
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        this.url = this.normalizeUrl(url);
        this.authentication = new BasicAuthentication(username, password);
    }

    public Dhis2Config(String url, Authentication authentication) {
        Objects.requireNonNull(url);
        Objects.requireNonNull(authentication);
        this.url = this.normalizeUrl(url);
        this.authentication = authentication;
    }

    private String normalizeUrl(String url) {
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    public URI getResolvedUrl(String path) {
        Objects.requireNonNull(path);
        try {
            return new URIBuilder(this.url).appendPath("api").appendPath(path).build();
        }
        catch (URISyntaxException ex) {
            throw new Dhis2ClientException(String.format("Invalid URI syntax: '%s'", this.url), ex);
        }
    }

    public URIBuilder getResolvedUriBuilder() {
        try {
            return new URIBuilder(this.url).appendPath("api");
        }
        catch (URISyntaxException ex) {
            throw new Dhis2ClientException(String.format("Invalid URI syntax: '%s'", this.url), ex);
        }
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Authentication getAuthentication() {
        return this.authentication;
    }
}

