/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.hisp.dhis.model.AttributeValue;

public class IdentifiableObject
implements Serializable {
    @JsonProperty
    protected String id;
    @JsonProperty
    protected String code;
    @JsonProperty
    protected String name;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss")
    protected Date created;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss")
    protected Date lastUpdated;
    @JsonProperty
    protected Set<AttributeValue> attributeValues = new HashSet<AttributeValue>();

    public boolean addAttributeValue(AttributeValue attributeValue) {
        return this.attributeValues.add(attributeValue);
    }

    public void updateAttributeValue(AttributeValue attributeValue) {
        this.removeAttributeValue(attributeValue.getAttribute().getId());
        this.addAttributeValue(attributeValue);
    }

    public AttributeValue getAttributeValue(String attribute) {
        return this.attributeValues.stream().filter(av -> av.getAttribute().getId().equals(attribute)).findFirst().orElse(null);
    }

    public boolean hasAttributeValue(String attribute) {
        return this.attributeValues.stream().anyMatch(av -> av.getAttribute().getId().equals(attribute));
    }

    public String getAttributeValueAsString(String attribute) {
        AttributeValue attributeValue = this.getAttributeValue(attribute);
        return attributeValue != null ? attributeValue.getValue() : null;
    }

    public boolean removeAttributeValue(String attribute) {
        return this.attributeValues.removeIf(av -> av.getAttribute().getId().equals(attribute));
    }

    public void clearAttributeValues() {
        this.attributeValues.clear();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        IdentifiableObject other = (IdentifiableObject)o;
        return Objects.equals(this.getId(), other.getId());
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Generated
    public Set<AttributeValue> getAttributeValues() {
        return this.attributeValues;
    }

    @JsonProperty
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @JsonProperty
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss")
    @Generated
    public void setCreated(Date created) {
        this.created = created;
    }

    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss")
    @Generated
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @JsonProperty
    @Generated
    public void setAttributeValues(Set<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    @Generated
    public String toString() {
        return "IdentifiableObject(id=" + this.getId() + ", code=" + this.getCode() + ", name=" + this.getName() + ", created=" + String.valueOf(this.getCreated()) + ", lastUpdated=" + String.valueOf(this.getLastUpdated()) + ", attributeValues=" + String.valueOf(this.getAttributeValues()) + ")";
    }
}

