/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hisp.dhis.model.CategoryCombo;
import org.hisp.dhis.model.DataElement;
import org.hisp.dhis.model.NameableObject;
import org.hisp.dhis.model.ProgramStage;
import org.hisp.dhis.model.ProgramType;
import org.hisp.dhis.model.trackedentity.ProgramTrackedEntityAttribute;
import org.hisp.dhis.model.trackedentity.TrackedEntityAttribute;
import org.hisp.dhis.model.trackedentity.TrackedEntityType;
import org.hisp.dhis.model.trackedentity.TrackedEntityTypeAttribute;
import org.hisp.dhis.util.CollectionUtils;

public class Program
extends NameableObject {
    @JsonProperty
    private ProgramType programType;
    @JsonProperty
    private TrackedEntityType trackedEntityType;
    @JsonProperty
    private CategoryCombo categoryCombo;
    @JsonProperty
    private List<ProgramTrackedEntityAttribute> programTrackedEntityAttributes = new ArrayList<ProgramTrackedEntityAttribute>();
    @JsonProperty
    private List<ProgramStage> programStages = new ArrayList<ProgramStage>();

    public Program(String id, String name) {
        this.id = id;
        this.name = name;
    }

    @JsonIgnore
    public List<TrackedEntityAttribute> getTrackedEntityTypeAttributes() {
        if (ProgramType.WITHOUT_REGISTRATION == this.programType || this.trackedEntityType == null) {
            return List.of();
        }
        return this.trackedEntityType.getTrackedEntityTypeAttributes().stream().map(TrackedEntityTypeAttribute::getTrackedEntityAttribute).collect(Collectors.toUnmodifiableList());
    }

    public List<TrackedEntityAttribute> getNonConfidentialTrackedEntityTypeAttributes() {
        if (ProgramType.WITHOUT_REGISTRATION == this.programType || this.trackedEntityType == null) {
            return List.of();
        }
        return this.trackedEntityType.getTrackedEntityTypeAttributes().stream().map(TrackedEntityTypeAttribute::getTrackedEntityAttribute).filter(tea -> !tea.isConfidentialNullSafe()).collect(Collectors.toUnmodifiableList());
    }

    @JsonIgnore
    public List<TrackedEntityAttribute> getTrackedEntityAttributes() {
        return this.programTrackedEntityAttributes.stream().map(ProgramTrackedEntityAttribute::getTrackedEntityAttribute).collect(Collectors.toUnmodifiableList());
    }

    @JsonIgnore
    public List<TrackedEntityAttribute> getNonConfidentialTrackedEntityAttributes() {
        return this.programTrackedEntityAttributes.stream().map(ProgramTrackedEntityAttribute::getTrackedEntityAttribute).filter(tea -> !tea.isConfidentialNullSafe()).collect(Collectors.toUnmodifiableList());
    }

    @JsonIgnore
    public List<DataElement> getDataElements() {
        return this.programStages.stream().flatMap(ps -> ps.getDataElements().stream()).distinct().collect(Collectors.toUnmodifiableList());
    }

    @JsonIgnore
    public List<DataElement> getAnalyticsDataElements() {
        return this.programStages.stream().flatMap(ps -> ps.getAnalyticsDataElements().stream()).distinct().collect(Collectors.toUnmodifiableList());
    }

    @JsonIgnore
    public List<DataElement> getAnalyticsDataElementsWithLegendSet() {
        return this.programStages.stream().flatMap(ps -> ps.getAnalyticsDataElements().stream()).filter(de -> CollectionUtils.notEmpty(de.getLegendSets()) && de.getValueType().isNumeric()).distinct().collect(Collectors.toUnmodifiableList());
    }

    @JsonIgnore
    public boolean hasCategoryCombo() {
        return this.categoryCombo != null;
    }

    @JsonIgnore
    public boolean hasTrackedEntityType() {
        return this.trackedEntityType != null;
    }

    @JsonIgnore
    public boolean isTrackerProgram() {
        return ProgramType.WITH_REGISTRATION == this.programType;
    }

    @JsonIgnore
    public boolean isEventProgram() {
        return ProgramType.WITHOUT_REGISTRATION == this.programType;
    }

    @Generated
    public ProgramType getProgramType() {
        return this.programType;
    }

    @Generated
    public TrackedEntityType getTrackedEntityType() {
        return this.trackedEntityType;
    }

    @Generated
    public CategoryCombo getCategoryCombo() {
        return this.categoryCombo;
    }

    @Generated
    public List<ProgramTrackedEntityAttribute> getProgramTrackedEntityAttributes() {
        return this.programTrackedEntityAttributes;
    }

    @Generated
    public List<ProgramStage> getProgramStages() {
        return this.programStages;
    }

    @JsonProperty
    @Generated
    public void setProgramType(ProgramType programType) {
        this.programType = programType;
    }

    @JsonProperty
    @Generated
    public void setTrackedEntityType(TrackedEntityType trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
    }

    @JsonProperty
    @Generated
    public void setCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
    }

    @JsonProperty
    @Generated
    public void setProgramTrackedEntityAttributes(List<ProgramTrackedEntityAttribute> programTrackedEntityAttributes) {
        this.programTrackedEntityAttributes = programTrackedEntityAttributes;
    }

    @JsonProperty
    @Generated
    public void setProgramStages(List<ProgramStage> programStages) {
        this.programStages = programStages;
    }

    @Generated
    public Program() {
    }
}

