/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.hisp.dhis.model.DataElement;
import org.hisp.dhis.model.NameableObject;
import org.hisp.dhis.model.ProgramStageDataElement;

public class ProgramStage
extends NameableObject {
    @JsonProperty
    private List<ProgramStageDataElement> programStageDataElements = new ArrayList<ProgramStageDataElement>();

    public ProgramStage(String id, String name) {
        this.id = id;
        this.name = name;
    }

    @JsonIgnore
    public List<DataElement> getDataElements() {
        return this.programStageDataElements.stream().map(ProgramStageDataElement::getDataElement).collect(Collectors.toUnmodifiableList());
    }

    @JsonIgnore
    public List<DataElement> getAnalyticsDataElements() {
        return this.programStageDataElements.stream().filter(psde -> BooleanUtils.isFalse((Boolean)psde.getSkipAnalytics())).map(ProgramStageDataElement::getDataElement).collect(Collectors.toUnmodifiableList());
    }

    @Generated
    public List<ProgramStageDataElement> getProgramStageDataElements() {
        return this.programStageDataElements;
    }

    @JsonProperty
    @Generated
    public void setProgramStageDataElements(List<ProgramStageDataElement> programStageDataElements) {
        this.programStageDataElements = programStageDataElements;
    }

    @Generated
    public ProgramStage() {
    }
}

