/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model;

import java.io.Serializable;
import lombok.Generated;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class SystemVersion
implements Serializable {
    private final String version;

    public SystemVersion(String version) {
        this.version = version;
    }

    public String version() {
        return this.version;
    }

    public static SystemVersion of(String version) {
        return new SystemVersion(version);
    }

    public boolean isHigher(String version) {
        return this.compareThisTo(version) > 0;
    }

    public boolean isHigherOrEqual(String version) {
        return this.compareThisTo(version) >= 0;
    }

    public boolean isEqual(String version) {
        return this.compareThisTo(version) == 0;
    }

    public boolean isLowerOrEqual(String version) {
        return this.compareThisTo(version) <= 0;
    }

    public boolean isLower(String version) {
        return this.compareThisTo(version) < 0;
    }

    private int compareThisTo(String version) {
        return new ComparableVersion(this.version).compareTo(new ComparableVersion(version));
    }

    @Generated
    public String toString() {
        return "SystemVersion(version=" + this.version + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemVersion)) {
            return false;
        }
        SystemVersion other = (SystemVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.version;
        String other$version = other.version;
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SystemVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.version;
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

