/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model.event;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hisp.dhis.model.event.EventDataValue;
import org.hisp.dhis.model.event.EventStatus;
import org.hisp.dhis.util.GeoUtils;
import org.locationtech.jts.geom.Geometry;

public class Event
implements Serializable {
    @JsonProperty(value="event")
    private String id;
    @JsonProperty
    private String program;
    @JsonProperty
    private String trackedEntity;
    @JsonProperty
    private String programStage;
    @JsonProperty
    private String orgUnit;
    @JsonProperty
    private String attributeOptionCombo;
    @JsonProperty
    private EventStatus status = EventStatus.ACTIVE;
    @JsonProperty
    private Date createdAt;
    @JsonProperty
    private Date createdAtClient;
    @JsonProperty
    private Date updatedAt;
    @JsonProperty
    private Date updatedAtClient;
    @JsonProperty
    private Date scheduledAt;
    @JsonProperty
    private Date occurredAt;
    @JsonProperty
    private Date completedAt;
    @JsonProperty
    private String completedBy;
    @JsonProperty
    private String storedBy;
    @JsonProperty
    private Boolean followUp;
    @JsonProperty
    private Geometry geometry;
    @JsonProperty
    private Boolean deleted;
    @JsonProperty
    private List<EventDataValue> dataValues = new ArrayList<EventDataValue>();

    public Event(String id) {
        this.id = id;
    }

    public Event(String id, String programStage, String orgUnit, EventStatus status, Date occurredAt, List<EventDataValue> dataValues) {
        this(id);
        this.programStage = programStage;
        this.orgUnit = orgUnit;
        this.status = status;
        this.occurredAt = occurredAt;
        this.dataValues = dataValues;
    }

    public void setPointGeometry(double longitude, double latitude) {
        this.geometry = GeoUtils.toPoint(longitude, latitude);
    }

    @JsonIgnore
    public boolean isGeometryPoint() {
        return this.isGeometryType("Point");
    }

    public boolean isGeometryType(String type) {
        Objects.requireNonNull(type);
        return this.geometry != null && type.equals(this.geometry.getGeometryType());
    }

    public EventDataValue getEventDataValue(String dataElement) {
        return this.dataValues.stream().filter(dv -> dataElement.equals(dv.getDataElement())).findFirst().orElse(null);
    }

    public String getDataValue(String dataElement) {
        EventDataValue eventDataValue = this.getEventDataValue(dataElement);
        return eventDataValue != null ? eventDataValue.getValue() : null;
    }

    public void addDataValue(EventDataValue dataValue) {
        Objects.requireNonNull(dataValue);
        Objects.requireNonNull(dataValue.getDataElement());
        this.dataValues.removeIf(dv -> dv.getDataElement().equals(dataValue.getDataElement()));
        this.dataValues.add(dataValue);
    }

    public void addDataValue(String dataElement, String value) {
        this.addDataValue(new EventDataValue(dataElement, value));
    }

    public void addDataValues(List<EventDataValue> dataValues) {
        this.dataValues.addAll(dataValues);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getProgram() {
        return this.program;
    }

    @Generated
    public String getTrackedEntity() {
        return this.trackedEntity;
    }

    @Generated
    public String getProgramStage() {
        return this.programStage;
    }

    @Generated
    public String getOrgUnit() {
        return this.orgUnit;
    }

    @Generated
    public String getAttributeOptionCombo() {
        return this.attributeOptionCombo;
    }

    @Generated
    public EventStatus getStatus() {
        return this.status;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getCreatedAtClient() {
        return this.createdAtClient;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Date getUpdatedAtClient() {
        return this.updatedAtClient;
    }

    @Generated
    public Date getScheduledAt() {
        return this.scheduledAt;
    }

    @Generated
    public Date getOccurredAt() {
        return this.occurredAt;
    }

    @Generated
    public Date getCompletedAt() {
        return this.completedAt;
    }

    @Generated
    public String getCompletedBy() {
        return this.completedBy;
    }

    @Generated
    public String getStoredBy() {
        return this.storedBy;
    }

    @Generated
    public Boolean getFollowUp() {
        return this.followUp;
    }

    @Generated
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public List<EventDataValue> getDataValues() {
        return this.dataValues;
    }

    @JsonProperty(value="event")
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    @Generated
    public void setProgram(String program) {
        this.program = program;
    }

    @JsonProperty
    @Generated
    public void setTrackedEntity(String trackedEntity) {
        this.trackedEntity = trackedEntity;
    }

    @JsonProperty
    @Generated
    public void setProgramStage(String programStage) {
        this.programStage = programStage;
    }

    @JsonProperty
    @Generated
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    @JsonProperty
    @Generated
    public void setAttributeOptionCombo(String attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    @JsonProperty
    @Generated
    public void setStatus(EventStatus status) {
        this.status = status;
    }

    @JsonProperty
    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty
    @Generated
    public void setCreatedAtClient(Date createdAtClient) {
        this.createdAtClient = createdAtClient;
    }

    @JsonProperty
    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty
    @Generated
    public void setUpdatedAtClient(Date updatedAtClient) {
        this.updatedAtClient = updatedAtClient;
    }

    @JsonProperty
    @Generated
    public void setScheduledAt(Date scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    @JsonProperty
    @Generated
    public void setOccurredAt(Date occurredAt) {
        this.occurredAt = occurredAt;
    }

    @JsonProperty
    @Generated
    public void setCompletedAt(Date completedAt) {
        this.completedAt = completedAt;
    }

    @JsonProperty
    @Generated
    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    @JsonProperty
    @Generated
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    @JsonProperty
    @Generated
    public void setFollowUp(Boolean followUp) {
        this.followUp = followUp;
    }

    @JsonProperty
    @Generated
    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    @JsonProperty
    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @JsonProperty
    @Generated
    public void setDataValues(List<EventDataValue> dataValues) {
        this.dataValues = dataValues;
    }

    @Generated
    public Event() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Event(id=" + this.getId() + ", programStage=" + this.getProgramStage() + ", orgUnit=" + this.getOrgUnit() + ", attributeOptionCombo=" + this.getAttributeOptionCombo() + ")";
    }
}

