/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.query;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hisp.dhis.query.Operator;

public class Filter {
    private final String property;
    private final Operator operator;
    private final Object value;

    public static Filter eq(String property, Object value) {
        return new Filter(property, Operator.EQ, value);
    }

    public static Filter ge(String property, Object value) {
        return new Filter(property, Operator.GE, value);
    }

    public static Filter gt(String property, Object value) {
        return new Filter(property, Operator.GT, value);
    }

    public static Filter le(String property, Object value) {
        return new Filter(property, Operator.LE, value);
    }

    public static Filter lt(String property, Object value) {
        return new Filter(property, Operator.LT, value);
    }

    public static Filter isTrue(String property) {
        return new Filter(property, Operator.EQ, "true");
    }

    public static Filter isFalse(String property) {
        return new Filter(property, Operator.EQ, "false");
    }

    public static Filter like(String property, Object value) {
        return new Filter(property, Operator.LIKE, value);
    }

    public static Filter ilike(String property, Object value) {
        return new Filter(property, Operator.ILIKE, value);
    }

    public static Filter token(String property, Object value) {
        return new Filter(property, Operator.TOKEN, value);
    }

    public static Filter in(String property, List<String> values) {
        return new Filter(property, Operator.IN, StringUtils.join(values, (char)','));
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public Operator getOperator() {
        return this.operator;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public String toString() {
        return "Filter(property=" + this.getProperty() + ", operator=" + String.valueOf((Object)this.getOperator()) + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @Generated
    public Filter(String property, Operator operator, Object value) {
        this.property = property;
        this.operator = operator;
        this.value = value;
    }
}

