/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.query.analytics;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.hisp.dhis.model.AggregationType;
import org.hisp.dhis.model.IdScheme;
import org.hisp.dhis.query.analytics.Dimension;

public class AnalyticsQuery {
    private final List<Dimension> dimensions = new ArrayList<Dimension>();
    private final List<Dimension> filters = new ArrayList<Dimension>();
    private AggregationType aggregationType;
    private String startDate;
    private String endDate;
    private Boolean skipMeta;
    private Boolean skipData;
    private Boolean skipRounding;
    private Boolean ignoreLimit;
    private Boolean tableLayout;
    private Boolean showHierarchy;
    private Boolean includeNumDen;
    private Boolean includeMetadataDetails;
    private IdScheme outputIdScheme;
    private IdScheme outputOrgUnitIdScheme;
    private IdScheme outputDataElementIdScheme;
    private IdScheme inputIdScheme;
    private List<String> columns = new ArrayList<String>();
    private List<String> rows = new ArrayList<String>();

    private AnalyticsQuery() {
    }

    public static AnalyticsQuery instance() {
        return new AnalyticsQuery();
    }

    public AnalyticsQuery addDimension(Dimension dimension) {
        this.dimensions.add(dimension);
        return this;
    }

    public AnalyticsQuery addDimension(String dimension, List<String> items) {
        return this.addDimension(new Dimension(dimension, items));
    }

    public AnalyticsQuery addDataDimension(List<String> items) {
        return this.addDimension("dx", items);
    }

    public AnalyticsQuery addPeriodDimension(List<String> items) {
        return this.addDimension("pe", items);
    }

    public AnalyticsQuery addOrgUnitDimension(List<String> items) {
        return this.addDimension("ou", items);
    }

    public AnalyticsQuery addFilter(Dimension filter) {
        this.filters.add(filter);
        return this;
    }

    public AnalyticsQuery addFilter(String filter, List<String> items) {
        return this.addFilter(new Dimension(filter, items));
    }

    public AnalyticsQuery addDataFilter(List<String> items) {
        return this.addFilter(new Dimension("dx", items));
    }

    public AnalyticsQuery addPeriodFilter(List<String> items) {
        return this.addFilter(new Dimension("pe", items));
    }

    public AnalyticsQuery addOrgUnitFilter(List<String> items) {
        return this.addFilter(new Dimension("ou", items));
    }

    public boolean hasColumns() {
        return CollectionUtils.isNotEmpty(this.columns);
    }

    public boolean hasRows() {
        return CollectionUtils.isNotEmpty(this.rows);
    }

    @Generated
    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    @Generated
    public List<Dimension> getFilters() {
        return this.filters;
    }

    @Generated
    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Generated
    public String getStartDate() {
        return this.startDate;
    }

    @Generated
    public String getEndDate() {
        return this.endDate;
    }

    @Generated
    public Boolean getSkipMeta() {
        return this.skipMeta;
    }

    @Generated
    public Boolean getSkipData() {
        return this.skipData;
    }

    @Generated
    public Boolean getSkipRounding() {
        return this.skipRounding;
    }

    @Generated
    public Boolean getIgnoreLimit() {
        return this.ignoreLimit;
    }

    @Generated
    public Boolean getTableLayout() {
        return this.tableLayout;
    }

    @Generated
    public Boolean getShowHierarchy() {
        return this.showHierarchy;
    }

    @Generated
    public Boolean getIncludeNumDen() {
        return this.includeNumDen;
    }

    @Generated
    public Boolean getIncludeMetadataDetails() {
        return this.includeMetadataDetails;
    }

    @Generated
    public IdScheme getOutputIdScheme() {
        return this.outputIdScheme;
    }

    @Generated
    public IdScheme getOutputOrgUnitIdScheme() {
        return this.outputOrgUnitIdScheme;
    }

    @Generated
    public IdScheme getOutputDataElementIdScheme() {
        return this.outputDataElementIdScheme;
    }

    @Generated
    public IdScheme getInputIdScheme() {
        return this.inputIdScheme;
    }

    @Generated
    public List<String> getColumns() {
        return this.columns;
    }

    @Generated
    public List<String> getRows() {
        return this.rows;
    }

    @Generated
    public AnalyticsQuery setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @Generated
    public AnalyticsQuery setStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @Generated
    public AnalyticsQuery setEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Generated
    public AnalyticsQuery setSkipMeta(Boolean skipMeta) {
        this.skipMeta = skipMeta;
        return this;
    }

    @Generated
    public AnalyticsQuery setSkipData(Boolean skipData) {
        this.skipData = skipData;
        return this;
    }

    @Generated
    public AnalyticsQuery setSkipRounding(Boolean skipRounding) {
        this.skipRounding = skipRounding;
        return this;
    }

    @Generated
    public AnalyticsQuery setIgnoreLimit(Boolean ignoreLimit) {
        this.ignoreLimit = ignoreLimit;
        return this;
    }

    @Generated
    public AnalyticsQuery setTableLayout(Boolean tableLayout) {
        this.tableLayout = tableLayout;
        return this;
    }

    @Generated
    public AnalyticsQuery setShowHierarchy(Boolean showHierarchy) {
        this.showHierarchy = showHierarchy;
        return this;
    }

    @Generated
    public AnalyticsQuery setIncludeNumDen(Boolean includeNumDen) {
        this.includeNumDen = includeNumDen;
        return this;
    }

    @Generated
    public AnalyticsQuery setIncludeMetadataDetails(Boolean includeMetadataDetails) {
        this.includeMetadataDetails = includeMetadataDetails;
        return this;
    }

    @Generated
    public AnalyticsQuery setOutputIdScheme(IdScheme outputIdScheme) {
        this.outputIdScheme = outputIdScheme;
        return this;
    }

    @Generated
    public AnalyticsQuery setOutputOrgUnitIdScheme(IdScheme outputOrgUnitIdScheme) {
        this.outputOrgUnitIdScheme = outputOrgUnitIdScheme;
        return this;
    }

    @Generated
    public AnalyticsQuery setOutputDataElementIdScheme(IdScheme outputDataElementIdScheme) {
        this.outputDataElementIdScheme = outputDataElementIdScheme;
        return this;
    }

    @Generated
    public AnalyticsQuery setInputIdScheme(IdScheme inputIdScheme) {
        this.inputIdScheme = inputIdScheme;
        return this;
    }

    @Generated
    public AnalyticsQuery setColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    @Generated
    public AnalyticsQuery setRows(List<String> rows) {
        this.rows = rows;
        return this;
    }
}

