/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.response.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hisp.dhis.response.BaseHttpResponse;
import org.hisp.dhis.response.Status;
import org.hisp.dhis.response.objects.ObjectStatistics;
import org.hisp.dhis.response.objects.TypeReport;
import org.hisp.dhis.response.objects.internal.Response;
import org.hisp.dhis.util.CollectionUtils;

public class ObjectsResponse
extends BaseHttpResponse {
    @JsonProperty
    private Status status;
    @JsonProperty
    private List<TypeReport> typeReports = new ArrayList<TypeReport>();
    @JsonProperty
    private ObjectStatistics stats;
    @JsonProperty
    private Response response;

    public ObjectsResponse(Status status, Integer httpStatusCode, ObjectStatistics stats) {
        this.status = status;
        this.httpStatusCode = httpStatusCode;
        this.stats = stats;
    }

    @JsonIgnore
    public TypeReport getTypeReport() {
        List<TypeReport> reports = this.getTypeReports();
        return CollectionUtils.notEmpty(reports) ? reports.get(0) : new TypeReport();
    }

    private boolean hasResponse() {
        return this.response != null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("status", (Object)this.status).append("httpStatusCode", (Object)this.httpStatusCode).append("stats", (Object)this.stats).append("typeReport", (Object)this.getTypeReport()).toString();
    }

    public Status getStatus() {
        return this.hasResponse() ? this.response.getStatus() : this.status;
    }

    public List<TypeReport> getTypeReports() {
        return this.hasResponse() ? this.response.getTypeReports() : this.typeReports;
    }

    public ObjectStatistics getStats() {
        return this.hasResponse() ? this.response.getStats() : this.stats;
    }

    @JsonProperty
    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @JsonProperty
    @Generated
    public void setTypeReports(List<TypeReport> typeReports) {
        this.typeReports = typeReports;
    }

    @JsonProperty
    @Generated
    public void setStats(ObjectStatistics stats) {
        this.stats = stats;
    }

    @JsonProperty
    @Generated
    public void setResponse(Response response) {
        this.response = response;
    }

    @Generated
    public ObjectsResponse() {
    }
}

