/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DuplicateFinder {
    private Map<String, Integer> valueCounts = new HashMap<String, Integer>();

    public DuplicateFinder() {
    }

    public DuplicateFinder(Collection<String> values) {
        this();
        this.addAll(values);
    }

    public void add(String value) {
        this.valueCounts.put(value, this.valueCounts.getOrDefault(value, 0) + 1);
    }

    public void addAll(Collection<String> values) {
        values.forEach(value -> this.add((String)value));
    }

    public Map<String, Integer> getDuplicates() {
        HashMap<String, Integer> duplicates = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : this.valueCounts.entrySet()) {
            if (entry.getValue() <= 1) continue;
            duplicates.put(entry.getKey(), entry.getValue());
        }
        return duplicates;
    }
}

