/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import lombok.Generated;

public class JacksonUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final ObjectMapper OBJECT_MAPPER = JacksonUtils.getObjectMapperInternal();

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    private static ObjectMapper getObjectMapperInternal() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JtsModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(DATE_FORMAT));
        return objectMapper;
    }

    public static String toJsonString(Object value) {
        try {
            return OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static <T> T fromJson(String string, Class<T> type) {
        try {
            return (T)OBJECT_MAPPER.readValue(string, type);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static <T> T fromJson(InputStream input, Class<T> type) {
        try {
            return (T)OBJECT_MAPPER.readValue(input, type);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Generated
    private JacksonUtils() {
    }
}

