/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import lombok.Generated;

public class UidUtils {
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DIGITS = "0123456789";
    private static final String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int CHAR_LENGTH = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length();
    private static final int UID_LENGTH = 11;
    private static final Pattern UID_PATTERN = Pattern.compile("^[a-zA-Z]{1}[a-zA-Z0-9]{10}$");

    public static String generateUid() {
        return UidUtils.generateCode(11);
    }

    public static List<String> generateUids(int n) {
        return IntStream.range(0, n).mapToObj(i -> UidUtils.generateUid()).toList();
    }

    public static boolean isValidUid(String code) {
        return code != null && UID_PATTERN.matcher(code).matches();
    }

    public static String generateCode(int length) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        char[] randomChars = new char[length];
        randomChars[0] = ALPHABET.charAt(rand.nextInt(ALPHABET.length()));
        for (int i = 1; i < length; ++i) {
            randomChars[i] = ALLOWED_CHARS.charAt(rand.nextInt(CHAR_LENGTH));
        }
        return new String(randomChars);
    }

    public static String toUid(String input) {
        if (input == null) {
            return null;
        }
        if (input.isBlank()) {
            return "";
        }
        if (input.length() < 2 || input.length() > 1024) {
            throw new IllegalArgumentException("Input string must be between 3 and 1024 characters long");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            BigInteger bigInteger = new BigInteger(1, hashBytes);
            Object base62 = UidUtils.fromBigInteger(bigInteger, ALPHABET, 11);
            if (Character.isDigit(((String)base62).charAt(0))) {
                base62 = ((String)base62).substring(1) + ALPHABET.charAt(0);
            }
            return base62;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("SHA-256 algorithm not found", ex);
        }
    }

    private static String fromBigInteger(BigInteger value, String alphabet, int length) {
        StringBuilder sb = new StringBuilder();
        BigInteger base = BigInteger.valueOf(alphabet.length());
        for (int i = 0; i < length; ++i) {
            BigInteger[] qr = value.divideAndRemainder(base);
            value = qr[0];
            BigInteger remainder = qr[1];
            sb.insert(0, alphabet.charAt(remainder.intValue()));
        }
        return sb.toString();
    }

    @Generated
    private UidUtils() {
    }
}

