/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.config;

import com.google.protobuf.BoolValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.StringValue;
import org.hypertrace.agent.config.Config;

public class EnvironmentConfig {
    private static final String HT_PREFIX = "ht.";
    public static final String CONFIG_FILE_PROPERTY = "ht.config.file";
    static final String SERVICE_NAME = "ht.service.name";
    static final String ENABLED = "ht.enabled";
    static final String PROPAGATION_FORMATS = "ht.propagation.formats";
    private static final String REPORTING_PREFIX = "ht.reporting.";
    static final String REPORTING_ENDPOINT = "ht.reporting.endpoint";
    static final String REPORTING_TRACE_TYPE = "ht.reporting.trace.reporter.type";
    static final String REPORTING_SECURE = "ht.reporting.secure";
    private static final String OPA_PREFIX = "ht.reporting.opa.";
    static final String OPA_ENDPOINT = "ht.reporting.opa.endpoint";
    static final String OPA_POLL_PERIOD = "ht.reporting.opa.poll.period.seconds";
    static final String OPA_ENABLED = "ht.reporting.opa.enabled";
    private static final String CAPTURE_PREFIX = "ht.data.capture.";
    public static final String CAPTURE_BODY_MAX_SIZE_BYTES = "ht.data.capture.body.max.size.bytes";
    public static final String CAPTURE_HTTP_HEADERS_PREFIX = "ht.data.capture.http.headers.";
    public static final String CAPTURE_HTTP_BODY_PREFIX = "ht.data.capture.http.body.";
    public static final String CAPTURE_RPC_METADATA_PREFIX = "ht.data.capture.rpc.metadata.";
    public static final String CAPTURE_RPC_BODY_PREFIX = "ht.data.capture.rpc.body.";
    private static final String JAVAAGENT_PREFIX = "ht.javaagent.";
    public static final String JAVAAGENT_FILTER_JAR_PATHS = "ht.javaagent.filter.jar.paths";

    private EnvironmentConfig() {
    }

    public static Config.AgentConfig.Builder applyPropertiesAndEnvVars(Config.AgentConfig.Builder builder) {
        String enabled;
        String serviceName = EnvironmentConfig.getProperty(SERVICE_NAME);
        if (serviceName != null) {
            builder.setServiceName(StringValue.newBuilder().setValue(serviceName).build());
        }
        if ((enabled = EnvironmentConfig.getProperty(ENABLED)) != null) {
            builder.setEnabled(BoolValue.newBuilder().setValue(Boolean.valueOf(enabled).booleanValue()).build());
        }
        Config.Reporting.Builder reportingBuilder = EnvironmentConfig.applyReporting(builder.getReporting().toBuilder());
        builder.setReporting(reportingBuilder);
        Config.DataCapture.Builder dataCaptureBuilder = EnvironmentConfig.setDefaultsToDataCapture(builder.getDataCapture().toBuilder());
        builder.setDataCapture(dataCaptureBuilder);
        EnvironmentConfig.applyPropagationFormat(builder);
        Config.JavaAgent.Builder javaagentBuilder = EnvironmentConfig.applyJavaAgent(builder.getJavaagentBuilder());
        builder.setJavaagent(javaagentBuilder);
        return builder;
    }

    private static Config.JavaAgent.Builder applyJavaAgent(Config.JavaAgent.Builder builder) {
        String filterJarPaths = EnvironmentConfig.getProperty(JAVAAGENT_FILTER_JAR_PATHS);
        if (filterJarPaths != null) {
            String[] jarPaths;
            builder.clearFilterJarPaths();
            for (String jarPath : jarPaths = filterJarPaths.split(",")) {
                builder.addFilterJarPaths(StringValue.newBuilder().setValue(jarPath));
            }
        }
        return builder;
    }

    private static void applyPropagationFormat(Config.AgentConfig.Builder builder) {
        String propagationFormats = EnvironmentConfig.getProperty(PROPAGATION_FORMATS);
        if (propagationFormats != null) {
            String[] formats;
            builder.clearPropagationFormats();
            for (String format : formats = propagationFormats.split(",")) {
                builder.addPropagationFormats(Config.PropagationFormat.valueOf(format));
            }
        }
    }

    private static Config.Reporting.Builder applyReporting(Config.Reporting.Builder builder) {
        String secure;
        String traceReportingType;
        String reporterAddress = EnvironmentConfig.getProperty(REPORTING_ENDPOINT);
        if (reporterAddress != null) {
            builder.setEndpoint(StringValue.newBuilder().setValue(reporterAddress).build());
        }
        if ((traceReportingType = EnvironmentConfig.getProperty(REPORTING_TRACE_TYPE)) != null) {
            builder.setTraceReporterType(Config.TraceReporterType.valueOf(traceReportingType));
        }
        if ((secure = EnvironmentConfig.getProperty(REPORTING_SECURE)) != null) {
            builder.setSecure(BoolValue.newBuilder().setValue(Boolean.valueOf(secure).booleanValue()).build());
        }
        Config.Opa.Builder opaBuilder = EnvironmentConfig.applyOpa(builder.getOpa().toBuilder());
        builder.setOpa(opaBuilder);
        return builder;
    }

    private static Config.Opa.Builder applyOpa(Config.Opa.Builder builder) {
        String enabled;
        String pollPeriod;
        String address = EnvironmentConfig.getProperty(OPA_ENDPOINT);
        if (address != null) {
            builder.setEndpoint(StringValue.newBuilder().setValue(address).build());
        }
        if ((pollPeriod = EnvironmentConfig.getProperty(OPA_POLL_PERIOD)) != null) {
            builder.setPollPeriodSeconds(Int32Value.newBuilder().setValue(Integer.parseInt(pollPeriod)).build());
        }
        if ((enabled = EnvironmentConfig.getProperty(OPA_ENABLED)) != null) {
            builder.setEnabled(BoolValue.newBuilder().setValue(Boolean.valueOf(enabled).booleanValue()).build());
        }
        return builder;
    }

    private static Config.DataCapture.Builder setDefaultsToDataCapture(Config.DataCapture.Builder builder) {
        String bodyMaxSizeBytes = EnvironmentConfig.getProperty(CAPTURE_BODY_MAX_SIZE_BYTES);
        if (bodyMaxSizeBytes != null) {
            builder.setBodyMaxSizeBytes(Int32Value.newBuilder().setValue(Integer.valueOf(bodyMaxSizeBytes).intValue()).build());
        }
        builder.setHttpHeaders(EnvironmentConfig.applyMessageDefaults(builder.getHttpHeaders().toBuilder(), CAPTURE_HTTP_HEADERS_PREFIX));
        builder.setHttpBody(EnvironmentConfig.applyMessageDefaults(builder.getHttpBody().toBuilder(), CAPTURE_HTTP_BODY_PREFIX));
        builder.setRpcMetadata(EnvironmentConfig.applyMessageDefaults(builder.getRpcMetadata().toBuilder(), CAPTURE_RPC_METADATA_PREFIX));
        builder.setRpcBody(EnvironmentConfig.applyMessageDefaults(builder.getRpcBody().toBuilder(), CAPTURE_RPC_BODY_PREFIX));
        return builder;
    }

    private static Config.Message.Builder applyMessageDefaults(Config.Message.Builder builder, String prefix) {
        String request = EnvironmentConfig.getProperty(prefix + "request");
        if (request != null) {
            builder.setRequest(BoolValue.newBuilder().setValue(Boolean.valueOf(request).booleanValue()).build());
        }
        String response = EnvironmentConfig.getProperty(prefix + "response");
        if (request != null) {
            builder.setResponse(BoolValue.newBuilder().setValue(Boolean.valueOf(response).booleanValue()).build());
        }
        return builder;
    }

    public static String getProperty(String name) {
        return System.getProperty(name, System.getenv(name.replaceAll("\\.", "_").toUpperCase()));
    }
}

