/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BoolValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.StringValue;
import com.google.protobuf.util.JsonFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.hypertrace.agent.config.Config;
import org.hypertrace.agent.core.config.EnvironmentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HypertraceConfig {
    private static final Logger log = LoggerFactory.getLogger(HypertraceConfig.class);
    private static volatile boolean servletCausingException;
    private static Config.AgentConfig agentConfig;
    static final String DEFAULT_SERVICE_NAME = "unknown";
    static final String DEFAULT_REPORTING_ENDPOINT = "http://localhost:9411/api/v2/spans";
    static final String DEFAULT_OPA_ENDPOINT = "http://opa.traceableai:8181/";
    static final int DEFAULT_OPA_POLL_PERIOD_SECONDS = 30;
    static final int DEFAULT_BODY_MAX_SIZE_BYTES = 131072;

    private HypertraceConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config.AgentConfig get() {
        if (agentConfig != null) return agentConfig;
        Class<HypertraceConfig> clazz = HypertraceConfig.class;
        synchronized (HypertraceConfig.class) {
            if (agentConfig != null) return agentConfig;
            try {
                agentConfig = HypertraceConfig.load();
                log.info("Config loaded: {}", (Object)JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)agentConfig));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load config", e);
            }
            return agentConfig;
        }
    }

    public static boolean isInstrumentationEnabled(String primaryName, String[] otherNames) {
        Config.AgentConfig agentConfig = HypertraceConfig.get();
        return agentConfig.getDataCapture().getHttpBody().getRequest().getValue() || agentConfig.getDataCapture().getHttpBody().getResponse().getValue() || agentConfig.getDataCapture().getHttpHeaders().getRequest().getValue() || agentConfig.getDataCapture().getHttpHeaders().getResponse().getValue() || agentConfig.getDataCapture().getRpcMetadata().getRequest().getValue() || agentConfig.getDataCapture().getRpcMetadata().getResponse().getValue();
    }

    public static boolean disableServletWrapperTypes() {
        return servletCausingException;
    }

    public static void recordException(Throwable throwable) {
        if (!(throwable instanceof ClassCastException)) {
            return;
        }
        String message = throwable.getMessage();
        if (message == null || message.isEmpty() || !HypertraceConfig.isHypertraceType(message)) {
            return;
        }
        if ((message = message.toLowerCase()).contains("servlet")) {
            log.error("Hypertrace servlet type caused class cast exception. Disabling wrapping of servlet types", throwable);
            servletCausingException = true;
        }
    }

    private static boolean isHypertraceType(String message) {
        return message.contains("hypertrace");
    }

    @VisibleForTesting
    public static void reset() {
        agentConfig = null;
    }

    private static Config.AgentConfig load() throws IOException {
        String configFile = EnvironmentConfig.getProperty("ht.config.file");
        if (configFile == null) {
            return EnvironmentConfig.applyPropertiesAndEnvVars(HypertraceConfig.applyDefaults(Config.AgentConfig.newBuilder())).build();
        }
        return HypertraceConfig.load(configFile);
    }

    @VisibleForTesting
    static Config.AgentConfig load(String filename) throws IOException {
        File configFile = new File(filename);
        if (!configFile.exists() || configFile.isDirectory() || !configFile.canRead()) {
            log.error("Config file {} does not exist", (Object)filename);
            Config.AgentConfig.Builder configBuilder = Config.AgentConfig.newBuilder();
            return EnvironmentConfig.applyPropertiesAndEnvVars(HypertraceConfig.applyDefaults(configBuilder)).build();
        }
        Config.AgentConfig.Builder configBuilder = Config.AgentConfig.newBuilder();
        JsonFormat.Parser jsonParser = JsonFormat.parser().ignoringUnknownFields();
        try (FileInputStream fileInputStream = new FileInputStream(configFile);){
            if (filename.toLowerCase().endsWith("json")) {
                InputStreamReader targetReader = new InputStreamReader(fileInputStream);
                jsonParser.merge((Reader)targetReader, (Message.Builder)configBuilder);
            } else {
                String json = HypertraceConfig.convertYamlToJson(fileInputStream);
                jsonParser.merge(json, (Message.Builder)configBuilder);
            }
            Config.AgentConfig agentConfig = EnvironmentConfig.applyPropertiesAndEnvVars(HypertraceConfig.applyDefaults(configBuilder)).build();
            return agentConfig;
        }
    }

    private static Config.AgentConfig.Builder applyDefaults(Config.AgentConfig.Builder configBuilder) {
        if (configBuilder.getServiceName().getValue().isEmpty()) {
            configBuilder.setServiceName(StringValue.newBuilder().setValue(DEFAULT_SERVICE_NAME).build());
        }
        if (!configBuilder.hasEnabled()) {
            configBuilder.setEnabled(BoolValue.newBuilder().setValue(true).build());
        }
        Config.Reporting.Builder reportingBuilder = HypertraceConfig.applyReportingDefaults(configBuilder.getReporting().toBuilder());
        configBuilder.setReporting(reportingBuilder);
        Config.DataCapture.Builder dataCaptureBuilder = HypertraceConfig.setDefaultsToDataCapture(configBuilder.getDataCapture().toBuilder());
        configBuilder.setDataCapture(dataCaptureBuilder);
        if (configBuilder.getPropagationFormatsList().isEmpty()) {
            configBuilder.addPropagationFormats(Config.PropagationFormat.TRACECONTEXT);
        }
        return configBuilder;
    }

    private static Config.Reporting.Builder applyReportingDefaults(Config.Reporting.Builder builder) {
        if (!builder.hasEndpoint()) {
            builder.setEndpoint(StringValue.newBuilder().setValue(DEFAULT_REPORTING_ENDPOINT).build());
        }
        Config.Opa.Builder opaBuilder = HypertraceConfig.applyOpaDefaults(builder.getOpa().toBuilder());
        builder.setOpa(opaBuilder);
        return builder;
    }

    private static Config.Opa.Builder applyOpaDefaults(Config.Opa.Builder builder) {
        if (!builder.hasEndpoint()) {
            builder.setEndpoint(StringValue.newBuilder().setValue(DEFAULT_OPA_ENDPOINT).build());
        }
        if (!builder.hasPollPeriodSeconds()) {
            builder.setPollPeriodSeconds(Int32Value.newBuilder().setValue(30).build());
        }
        return builder;
    }

    private static Config.DataCapture.Builder setDefaultsToDataCapture(Config.DataCapture.Builder builder) {
        builder.setHttpHeaders(HypertraceConfig.applyMessageDefaults(builder.getHttpHeaders().toBuilder()));
        builder.setHttpBody(HypertraceConfig.applyMessageDefaults(builder.getHttpBody().toBuilder()));
        builder.setRpcMetadata(HypertraceConfig.applyMessageDefaults(builder.getRpcMetadata().toBuilder()));
        builder.setRpcBody(HypertraceConfig.applyMessageDefaults(builder.getRpcBody().toBuilder()));
        if (!builder.hasBodyMaxSizeBytes()) {
            builder.setBodyMaxSizeBytes(Int32Value.newBuilder().setValue(131072).build());
        }
        return builder;
    }

    private static Config.Message.Builder applyMessageDefaults(Config.Message.Builder builder) {
        if (!builder.hasRequest()) {
            builder.setRequest(BoolValue.newBuilder().setValue(true).build());
        }
        if (!builder.hasResponse()) {
            builder.setResponse(BoolValue.newBuilder().setValue(true).build());
        }
        return builder;
    }

    private static String convertYamlToJson(InputStream yaml) throws IOException {
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object obj = yamlReader.readValue(yaml, Object.class);
        ObjectMapper jsonWriter = new ObjectMapper();
        return jsonWriter.writeValueAsString(obj);
    }
}

