/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.config;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface InstrumentationConfig {
    public int maxBodySizeBytes();

    public Message httpHeaders();

    public Message httpBody();

    public Message rpcMetadata();

    public Message rpcBody();

    default public boolean isInstrumentationEnabled(String primaryName, String[] otherNames) {
        return this.httpBody().request() || this.httpBody().response() || this.httpHeaders().request() || this.httpHeaders().response() || this.rpcBody().request() || this.rpcBody().response() || this.rpcMetadata().request() || this.rpcMetadata().response();
    }

    public static class ConfigProvider {
        private static final Logger logger = LoggerFactory.getLogger(ConfigProvider.class);
        private static volatile InstrumentationConfig instrumentationConfig;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void reset() {
            Class<ConfigProvider> clazz = ConfigProvider.class;
            synchronized (ConfigProvider.class) {
                instrumentationConfig = null;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        private static InstrumentationConfig load() {
            ServiceLoader<InstrumentationConfig> configs = ServiceLoader.load(InstrumentationConfig.class);
            Iterator<InstrumentationConfig> iterator = configs.iterator();
            if (!iterator.hasNext()) {
                logger.error("Failed to load instrumentation config");
                return null;
            }
            return iterator.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static InstrumentationConfig get() {
            if (instrumentationConfig != null) return instrumentationConfig;
            Class<ConfigProvider> clazz = ConfigProvider.class;
            synchronized (ConfigProvider.class) {
                if (instrumentationConfig != null) return instrumentationConfig;
                instrumentationConfig = ConfigProvider.load();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instrumentationConfig;
            }
        }
    }

    public static interface Message {
        public boolean request();

        public boolean response();
    }
}

