/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.config;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DataCaptureConfig {
    public String[] getAllowedContentTypes();

    public static class ConfigProvider {
        private static final Logger logger = LoggerFactory.getLogger(ConfigProvider.class);
        private static volatile DataCaptureConfig dataCaptureConfig;

        private static DataCaptureConfig load() {
            ServiceLoader<DataCaptureConfig> configs = ServiceLoader.load(DataCaptureConfig.class);
            Iterator<DataCaptureConfig> iterator = configs.iterator();
            if (!iterator.hasNext()) {
                logger.error("Failed to load data capture config");
                return null;
            }
            return iterator.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static DataCaptureConfig get() {
            if (dataCaptureConfig != null) return dataCaptureConfig;
            Class<ConfigProvider> clazz = ConfigProvider.class;
            synchronized (ConfigProvider.class) {
                if (dataCaptureConfig != null) return dataCaptureConfig;
                dataCaptureConfig = ConfigProvider.load();
                // ** MonitorExit[var0] (shouldn't be in output)
                return dataCaptureConfig;
            }
        }
    }
}

