/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.instrumentation.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class ContentTypeUtils {
    private static final String CHARSET_EQUALS = "charset=";
    private static final String SEPARATOR = ";";

    private ContentTypeUtils() {
    }

    public static boolean shouldCapture(String contentType) {
        if (contentType == null) {
            return false;
        }
        return (contentType = contentType.toLowerCase()).contains("json") || contentType.contains("graphql") || contentType.contains("x-www-form-urlencoded");
    }

    public static String parseCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        int indexOfCharset = (contentType = contentType.toLowerCase()).indexOf(CHARSET_EQUALS);
        if (indexOfCharset == -1) {
            return null;
        }
        int indexOfEncoding = indexOfCharset + CHARSET_EQUALS.length();
        if (indexOfEncoding < contentType.length()) {
            String substring = contentType.substring(indexOfEncoding, contentType.length());
            int semicolonIndex = substring.indexOf(SEPARATOR);
            if (semicolonIndex == -1) {
                return substring;
            }
            return substring.substring(0, semicolonIndex);
        }
        return null;
    }

    public static String convertToJSONString(Object obj) {
        try {
            return new ObjectMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

