/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.instrumentation.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.hypertrace.agent.core.config.DataCaptureConfig;

public class ContentTypeUtils {
    private final String[] collectableContentTypes;
    private static final String[] DEFAULT_CONTENT_TYPES = new String[]{"json", "graphql", "xml", "x-www-form-urlencoded"};
    private static final String CHARSET_EQUALS = "charset=";
    private static final String SEPARATOR = ";";
    private static volatile ContentTypeUtils instance;

    public static String[] getDefaultContentTypes() {
        return DEFAULT_CONTENT_TYPES;
    }

    private ContentTypeUtils() {
        DataCaptureConfig dataCaptureConfig = DataCaptureConfig.ConfigProvider.get();
        this.collectableContentTypes = dataCaptureConfig == null ? DEFAULT_CONTENT_TYPES : dataCaptureConfig.getAllowedContentTypes();
    }

    private static ContentTypeUtils getInstance() {
        if (instance == null) {
            return ContentTypeUtils.getInstanceSync();
        }
        return instance;
    }

    private static synchronized ContentTypeUtils getInstanceSync() {
        if (instance == null) {
            instance = new ContentTypeUtils();
        }
        return instance;
    }

    private boolean shouldCapture_(String contentType) {
        if (contentType == null) {
            return false;
        }
        contentType = contentType.toLowerCase();
        for (String nextValidContentType : this.collectableContentTypes) {
            if (!contentType.contains(nextValidContentType)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldCapture(String contentType) {
        return ContentTypeUtils.getInstance().shouldCapture_(contentType);
    }

    public static String parseCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        int indexOfCharset = (contentType = contentType.toLowerCase()).indexOf(CHARSET_EQUALS);
        if (indexOfCharset == -1) {
            return null;
        }
        int indexOfEncoding = indexOfCharset + CHARSET_EQUALS.length();
        if (indexOfEncoding < contentType.length()) {
            String substring = contentType.substring(indexOfEncoding, contentType.length());
            int semicolonIndex = substring.indexOf(SEPARATOR);
            if (semicolonIndex == -1) {
                return substring;
            }
            return substring.substring(0, semicolonIndex);
        }
        return null;
    }

    public static String convertToJSONString(Object obj) {
        try {
            return new ObjectMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

