/*
 * Decompiled with CFR 0.152.
 */
package org.hypertrace.agent.core.instrumentation;

import io.opentelemetry.api.common.AttributeKey;

public class HypertraceSemanticAttributes {
    public static final String ADDITIONAL_DATA_SPAN_NAME = "additional-data";
    public static final AttributeKey<String> HTTP_REQUEST_BODY = AttributeKey.stringKey((String)"http.request.body");
    public static final AttributeKey<String> HTTP_RESPONSE_BODY = AttributeKey.stringKey((String)"http.response.body");
    public static final AttributeKey<String> HTTP_REQUEST_SESSION_ID = AttributeKey.stringKey((String)"http.request.session_id");
    public static final AttributeKey<String> HTTP_REQUEST_HEADER_CONTENT_TYPE = AttributeKey.stringKey((String)"http.request.header.content-type");
    public static final AttributeKey<String> HTTP_RESPONSE_HEADER_CONTENT_TYPE = AttributeKey.stringKey((String)"http.response.header.content-type");
    public static final AttributeKey<String> RPC_REQUEST_BODY = AttributeKey.stringKey((String)"rpc.request.body");
    public static final AttributeKey<String> RPC_RESPONSE_BODY = AttributeKey.stringKey((String)"rpc.response.body");

    private HypertraceSemanticAttributes() {
    }

    public static AttributeKey<String> httpRequestHeader(String header) {
        return AttributeKey.stringKey((String)("http.request.header." + header.toLowerCase()));
    }

    public static AttributeKey<String> httpResponseHeader(String header) {
        return AttributeKey.stringKey((String)("http.response.header." + header.toLowerCase()));
    }

    public static final AttributeKey<String> rpcRequestMetadata(String key) {
        return AttributeKey.stringKey((String)("rpc.request.metadata." + key.toLowerCase()));
    }

    public static final AttributeKey<String> rpcResponseMetadata(String key) {
        return AttributeKey.stringKey((String)("rpc.response.metadata." + key.toLowerCase()));
    }
}

