/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.spring.launcher;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jacpfx.api.fragment.Scope;
import org.jacpfx.api.launcher.Launcher;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringJavaConfigLauncher
implements Launcher<AnnotationConfigApplicationContext> {
    private final AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
    private final ConfigurableListableBeanFactory factory;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public SpringJavaConfigLauncher(Class<?> ... annotatedClasses) {
        this.context.register((Class[])annotatedClasses);
        this.context.refresh();
        this.factory = this.context.getBeanFactory();
    }

    public AnnotationConfigApplicationContext getContext() {
        return this.context;
    }

    public <P> P getBean(Class<P> clazz) {
        this.lock.readLock().lock();
        try {
            Object object = this.factory.getBean(clazz);
            return (P)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean contains(String id) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.factory.containsBean(id);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> P registerAndGetBean(Class<? extends P> type, String id, Scope scope) {
        if (this.contains(id)) {
            return this.getBean(type);
        }
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(type);
        if (scope != null) {
            beanDefinition.setScope(scope.getType());
        }
        beanDefinition.setAutowireCandidate(true);
        this.lock.writeLock().lock();
        try {
            AutowireCapableBeanFactory factory = this.getContext().getAutowireCapableBeanFactory();
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)factory;
            registry.registerBeanDefinition(id, (BeanDefinition)beanDefinition);
            factory.autowireBeanProperties((Object)this, 2, false);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.getBean(type);
    }
}

