/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.spring.launcher;

import javafx.stage.Stage;
import org.jacpfx.api.annotations.workbench.Workbench;
import org.jacpfx.api.exceptions.AnnotationNotFoundException;
import org.jacpfx.api.exceptions.AttributeNotFoundException;
import org.jacpfx.api.exceptions.ComponentNotFoundException;
import org.jacpfx.api.fragment.Scope;
import org.jacpfx.api.launcher.Launcher;
import org.jacpfx.rcp.workbench.EmbeddedFXWorkbench;
import org.jacpfx.rcp.workbench.FXWorkbench;
import org.jacpfx.spring.launcher.ASpringLauncher;
import org.jacpfx.spring.launcher.SpringJavaConfigLauncher;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public abstract class AFXSpringJavaConfigLauncher
extends ASpringLauncher {
    public void start(Stage stage) throws Exception {
        this.initExceptionHandler();
        this.scanPackegesAndInitRegestry();
        SpringJavaConfigLauncher launcher = new SpringJavaConfigLauncher(this.getConfigClasses());
        Class<? extends FXWorkbench> workbenchHandler = this.getWorkbenchClass();
        if (workbenchHandler == null) {
            throw new ComponentNotFoundException("no FXWorkbench class defined");
        }
        this.initWorkbench(stage, launcher, workbenchHandler);
    }

    private void initWorkbench(Stage stage, Launcher<AnnotationConfigApplicationContext> launcher, Class<? extends FXWorkbench> workbenchHandler) {
        if (!workbenchHandler.isAnnotationPresent(Workbench.class)) {
            throw new AnnotationNotFoundException("no @Workbench annotation found on class");
        }
        this.workbench = this.createWorkbench(launcher, workbenchHandler);
        this.workbench.init(launcher, (Object)stage);
        this.postInit(stage);
    }

    private EmbeddedFXWorkbench createWorkbench(Launcher<AnnotationConfigApplicationContext> launcher, Class<? extends FXWorkbench> workbenchHandler) {
        Workbench annotation = workbenchHandler.getAnnotation(Workbench.class);
        String id = annotation.id();
        if (id.isEmpty()) {
            throw new AttributeNotFoundException("no workbench id found for: " + workbenchHandler);
        }
        FXWorkbench handler = (FXWorkbench)launcher.registerAndGetBean(workbenchHandler, id, Scope.SINGLETON);
        return new EmbeddedFXWorkbench(handler, this.getWorkbenchDecorator());
    }

    protected abstract Class<?>[] getConfigClasses();
}

