/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.spring.launcher;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jacpfx.api.fragment.Scope;
import org.jacpfx.api.launcher.Launcher;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringXmlConfigLauncher
implements Launcher<ClassPathXmlApplicationContext> {
    private final ClassPathXmlApplicationContext context;
    private final ConfigurableListableBeanFactory factory;
    private final String BASIC_CONFIG_BEANS = "basic.xml";
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public SpringXmlConfigLauncher(String resource) {
        this.context = new ClassPathXmlApplicationContext(new String[]{resource, this.BASIC_CONFIG_BEANS});
        this.factory = this.context.getBeanFactory();
    }

    public ClassPathXmlApplicationContext getContext() {
        return this.context;
    }

    public <P> P getBean(Class<P> clazz) {
        this.lock.readLock().lock();
        try {
            Object object = this.factory.getBean(clazz);
            return (P)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <P> P getBean(String qualifier) {
        this.lock.readLock().lock();
        try {
            Object object = this.factory.getBean(qualifier);
            return (P)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean contains(String id) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.factory.containsBean(id);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public synchronized <T> T registerAndGetBean(Class<? extends T> type, String id, Scope scope) {
        if (this.contains(id)) {
            return (T)this.getBean(id);
        }
        AutowireCapableBeanFactory factory = this.getContext().getAutowireCapableBeanFactory();
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)factory;
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(type);
        if (scope != null) {
            beanDefinition.setScope(scope.getType());
        }
        beanDefinition.setAutowireCandidate(true);
        registry.registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        factory.autowireBeanProperties((Object)this, 2, false);
        return (T)this.getBean(id);
    }
}

