/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.service.dto;

import com.google.common.collect.Lists;
import com.jeeplus.core.service.dto.BaseDTO;
import com.jeeplus.devtools.service.dto.TableDTO;
import com.jeeplus.devtools.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TableColumnDTO
extends BaseDTO {
    private static final long serialVersionUID = 1L;
    private TableDTO table;
    private String name;
    private String oldName;
    private String comments;
    private String oldComments;
    private String jdbcType;
    private String oldJdbcType;
    private String javaType;
    private String javaField;
    private String isPk = "0";
    private String oldIsPk = "0";
    private String isForm = "0";
    private String isList = "0";
    private String isQuery = "0";
    private String queryType;
    private String showType;
    private String dictType;
    private Integer sort;
    private String tableName;
    private String fieldLabels;
    private String fieldKeys;
    private String searchLabel;
    private String searchKey;
    private String dataUrl;
    private String isNull;
    private String validateType;
    private String minLength;
    private String maxLength;
    private String minValue;
    private String maxValue;

    public String getNameAndComments() {
        return this.getName() + (this.comments == null ? "" : "  :  " + this.comments);
    }

    public String getDataLength() {
        String[] ss = StringUtils.split((String)StringUtils.substringBetween((String)this.getJdbcType(), (String)"(", (String)")"), (String)",");
        if (ss != null && ss.length == 1) {
            return ss[0];
        }
        return "0";
    }

    public String getSimpleJavaType() {
        if ("This".equals(this.getJavaType())) {
            return this.table != null ? StringUtils.capitalize((String)this.table.getClassName()) : "";
        }
        return StringUtils.indexOf((CharSequence)this.getJavaType(), (CharSequence)".") != -1 ? StringUtils.substringAfterLast((String)this.getJavaType(), (String)".") : this.getJavaType();
    }

    public String getMapperJavaField() {
        return StringUtil.toCamelCase(this.name);
    }

    public String getSimpleJavaFieldId() {
        if (this.getJavaField().indexOf("DTO") > 0) {
            return StringUtils.substringBefore((String)this.getJavaField(), (String)"DTO") + "Id";
        }
        return StringUtils.substringBefore((String)this.getJavaField(), (String)".") + "Id";
    }

    public String getSimpleJavaField() {
        return StringUtils.substringBefore((String)this.getJavaField(), (String)".");
    }

    public String getJavaFieldId() {
        return StringUtils.substringBefore((String)this.getJavaField(), (String)"|");
    }

    public String getJavaFieldName() {
        String[][] ss = this.getJavaFieldAttrs();
        return ss.length > 0 ? this.getSimpleJavaField() + "." + ss[0][0] : "";
    }

    public String[][] getJavaFieldAttrs() {
        String[] ss = StringUtils.split((String)StringUtils.substringAfter((String)this.getJavaField(), (String)"|"), (String)"|");
        String[][] sss = new String[ss.length][2];
        if (ss != null) {
            for (int i = 0; i < ss.length; ++i) {
                sss[i][0] = ss[i];
                sss[i][1] = StringUtil.toUnderScoreCase(ss[i]);
            }
        }
        return sss;
    }

    public List<String> getAnnotationList() {
        ArrayList list = Lists.newArrayList();
        if ("java.util.Date".equals(this.getJavaType())) {
            list.add("com.fasterxml.jackson.annotation.JsonFormat(pattern = \"yyyy-MM-dd HH:mm:ss\")");
        }
        if (!"1".equals(this.getIsNull())) {
            list.add("javax.validation.constraints.NotNull(message=\"" + this.getComments() + "\u4e0d\u80fd\u4e3a\u7a7a\")");
        }
        if (!"1".equals(this.getIsNull()) && "String".equals(this.getJavaType()) && this.minLength != null && !this.minLength.equals("")) {
            list.add("javax.validation.constraints.Size(min=" + this.minLength + ", max=" + this.maxLength + ", message=\"" + this.getComments() + "\u957f\u5ea6\u5fc5\u987b\u4ecb\u4e8e " + this.minLength + " \u548c " + this.maxLength + " \u4e4b\u95f4\")");
        }
        if ("email".equals(this.validateType)) {
            list.add("javax.validation.constraints.Email(message=\"" + this.getComments() + "\u5fc5\u987b\u4e3a\u5408\u6cd5\u90ae\u7bb1\")");
        }
        if ("number".equals(this.validateType) || "digits".equals(this.validateType)) {
            if (this.minValue != null && !this.minValue.equals("")) {
                if (this.minValue.contains(".")) {
                    String minv = this.minValue.replace(".", "_digitalPoint_");
                    list.add("javax.validation.constraints.Min(value=(long)" + minv + ",message=\"" + this.getComments() + "\u7684\u6700\u5c0f\u503c\u4e0d\u80fd\u5c0f\u4e8e" + minv + "\")");
                } else {
                    list.add("javax.validation.constraints.Min(value=" + this.minValue + ",message=\"" + this.getComments() + "\u7684\u6700\u5c0f\u503c\u4e0d\u80fd\u5c0f\u4e8e" + this.minValue + "\")");
                }
            }
            if (this.maxValue != null && !this.maxValue.equals("")) {
                if (this.maxValue.contains(".")) {
                    String maxv = this.maxValue.replace(".", "_digitalPoint_");
                    list.add("javax.validation.constraints.Max(value=(long)" + maxv + ",message=\"" + this.getComments() + "\u7684\u6700\u5927\u503c\u4e0d\u80fd\u8d85\u8fc7" + maxv + "\")");
                } else {
                    list.add("javax.validation.constraints.Max(value=" + this.maxValue + ",message=\"" + this.getComments() + "\u7684\u6700\u5927\u503c\u4e0d\u80fd\u8d85\u8fc7" + this.maxValue + "\")");
                }
            }
        }
        return list;
    }

    public List<String> getSimpleAnnotationList() {
        ArrayList list = Lists.newArrayList();
        for (String ann : this.getAnnotationList()) {
            String anno = StringUtils.substringAfterLast((String)ann, (String)".");
            anno = anno.replace("_digitalPoint_", ".");
            list.add(anno);
        }
        return list;
    }

    public Boolean getIsNotBaseField() {
        return !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"id") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"createBy") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"createTime") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"updateBy") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"updateTime") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"tenantId") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"delFlag");
    }

    public Boolean getIsNotTreeBaseField() {
        return !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"id") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"tenantId") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"createBy") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"createTime") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"updateBy") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"updateTime") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"delFlag") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"parent") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"parentIds") && !StringUtils.equals((CharSequence)this.getSimpleJavaField(), (CharSequence)"sort");
    }

    public boolean getIsBasicJavaType() {
        return !this.javaField.contains(".");
    }

    public boolean getIsNotBasicJavaType() {
        return !this.getIsBasicJavaType();
    }

    public TableDTO getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getComments() {
        return this.comments;
    }

    public String getOldComments() {
        return this.oldComments;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public String getOldJdbcType() {
        return this.oldJdbcType;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getJavaField() {
        return this.javaField;
    }

    public String getIsPk() {
        return this.isPk;
    }

    public String getOldIsPk() {
        return this.oldIsPk;
    }

    public String getIsForm() {
        return this.isForm;
    }

    public String getIsList() {
        return this.isList;
    }

    public String getIsQuery() {
        return this.isQuery;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public String getShowType() {
        return this.showType;
    }

    public String getDictType() {
        return this.dictType;
    }

    public Integer getSort() {
        return this.sort;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFieldLabels() {
        return this.fieldLabels;
    }

    public String getFieldKeys() {
        return this.fieldKeys;
    }

    public String getSearchLabel() {
        return this.searchLabel;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public String getIsNull() {
        return this.isNull;
    }

    public String getValidateType() {
        return this.validateType;
    }

    public String getMinLength() {
        return this.minLength;
    }

    public String getMaxLength() {
        return this.maxLength;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setTable(TableDTO table) {
        this.table = table;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setOldComments(String oldComments) {
        this.oldComments = oldComments;
    }

    public void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public void setOldJdbcType(String oldJdbcType) {
        this.oldJdbcType = oldJdbcType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public void setJavaField(String javaField) {
        this.javaField = javaField;
    }

    public void setIsPk(String isPk) {
        this.isPk = isPk;
    }

    public void setOldIsPk(String oldIsPk) {
        this.oldIsPk = oldIsPk;
    }

    public void setIsForm(String isForm) {
        this.isForm = isForm;
    }

    public void setIsList(String isList) {
        this.isList = isList;
    }

    public void setIsQuery(String isQuery) {
        this.isQuery = isQuery;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public void setShowType(String showType) {
        this.showType = showType;
    }

    public void setDictType(String dictType) {
        this.dictType = dictType;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setFieldLabels(String fieldLabels) {
        this.fieldLabels = fieldLabels;
    }

    public void setFieldKeys(String fieldKeys) {
        this.fieldKeys = fieldKeys;
    }

    public void setSearchLabel(String searchLabel) {
        this.searchLabel = searchLabel;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    public void setDataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
    }

    public void setIsNull(String isNull) {
        this.isNull = isNull;
    }

    public void setValidateType(String validateType) {
        this.validateType = validateType;
    }

    public void setMinLength(String minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(String maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public String toString() {
        return "TableColumnDTO(table=" + (Object)((Object)this.getTable()) + ", name=" + this.getName() + ", oldName=" + this.getOldName() + ", comments=" + this.getComments() + ", oldComments=" + this.getOldComments() + ", jdbcType=" + this.getJdbcType() + ", oldJdbcType=" + this.getOldJdbcType() + ", javaType=" + this.getJavaType() + ", javaField=" + this.getJavaField() + ", isPk=" + this.getIsPk() + ", oldIsPk=" + this.getOldIsPk() + ", isForm=" + this.getIsForm() + ", isList=" + this.getIsList() + ", isQuery=" + this.getIsQuery() + ", queryType=" + this.getQueryType() + ", showType=" + this.getShowType() + ", dictType=" + this.getDictType() + ", sort=" + this.getSort() + ", tableName=" + this.getTableName() + ", fieldLabels=" + this.getFieldLabels() + ", fieldKeys=" + this.getFieldKeys() + ", searchLabel=" + this.getSearchLabel() + ", searchKey=" + this.getSearchKey() + ", dataUrl=" + this.getDataUrl() + ", isNull=" + this.getIsNull() + ", validateType=" + this.getValidateType() + ", minLength=" + this.getMinLength() + ", maxLength=" + this.getMaxLength() + ", minValue=" + this.getMinValue() + ", maxValue=" + this.getMaxValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableColumnDTO)) {
            return false;
        }
        TableColumnDTO other = (TableColumnDTO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$sort = this.getSort();
        Integer other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        TableDTO this$table = this.getTable();
        TableDTO other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)((Object)this$table)).equals((Object)other$table)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$oldName = this.getOldName();
        String other$oldName = other.getOldName();
        if (this$oldName == null ? other$oldName != null : !this$oldName.equals(other$oldName)) {
            return false;
        }
        String this$comments = this.getComments();
        String other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !this$comments.equals(other$comments)) {
            return false;
        }
        String this$oldComments = this.getOldComments();
        String other$oldComments = other.getOldComments();
        if (this$oldComments == null ? other$oldComments != null : !this$oldComments.equals(other$oldComments)) {
            return false;
        }
        String this$jdbcType = this.getJdbcType();
        String other$jdbcType = other.getJdbcType();
        if (this$jdbcType == null ? other$jdbcType != null : !this$jdbcType.equals(other$jdbcType)) {
            return false;
        }
        String this$oldJdbcType = this.getOldJdbcType();
        String other$oldJdbcType = other.getOldJdbcType();
        if (this$oldJdbcType == null ? other$oldJdbcType != null : !this$oldJdbcType.equals(other$oldJdbcType)) {
            return false;
        }
        String this$javaType = this.getJavaType();
        String other$javaType = other.getJavaType();
        if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
            return false;
        }
        String this$javaField = this.getJavaField();
        String other$javaField = other.getJavaField();
        if (this$javaField == null ? other$javaField != null : !this$javaField.equals(other$javaField)) {
            return false;
        }
        String this$isPk = this.getIsPk();
        String other$isPk = other.getIsPk();
        if (this$isPk == null ? other$isPk != null : !this$isPk.equals(other$isPk)) {
            return false;
        }
        String this$oldIsPk = this.getOldIsPk();
        String other$oldIsPk = other.getOldIsPk();
        if (this$oldIsPk == null ? other$oldIsPk != null : !this$oldIsPk.equals(other$oldIsPk)) {
            return false;
        }
        String this$isForm = this.getIsForm();
        String other$isForm = other.getIsForm();
        if (this$isForm == null ? other$isForm != null : !this$isForm.equals(other$isForm)) {
            return false;
        }
        String this$isList = this.getIsList();
        String other$isList = other.getIsList();
        if (this$isList == null ? other$isList != null : !this$isList.equals(other$isList)) {
            return false;
        }
        String this$isQuery = this.getIsQuery();
        String other$isQuery = other.getIsQuery();
        if (this$isQuery == null ? other$isQuery != null : !this$isQuery.equals(other$isQuery)) {
            return false;
        }
        String this$queryType = this.getQueryType();
        String other$queryType = other.getQueryType();
        if (this$queryType == null ? other$queryType != null : !this$queryType.equals(other$queryType)) {
            return false;
        }
        String this$showType = this.getShowType();
        String other$showType = other.getShowType();
        if (this$showType == null ? other$showType != null : !this$showType.equals(other$showType)) {
            return false;
        }
        String this$dictType = this.getDictType();
        String other$dictType = other.getDictType();
        if (this$dictType == null ? other$dictType != null : !this$dictType.equals(other$dictType)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$fieldLabels = this.getFieldLabels();
        String other$fieldLabels = other.getFieldLabels();
        if (this$fieldLabels == null ? other$fieldLabels != null : !this$fieldLabels.equals(other$fieldLabels)) {
            return false;
        }
        String this$fieldKeys = this.getFieldKeys();
        String other$fieldKeys = other.getFieldKeys();
        if (this$fieldKeys == null ? other$fieldKeys != null : !this$fieldKeys.equals(other$fieldKeys)) {
            return false;
        }
        String this$searchLabel = this.getSearchLabel();
        String other$searchLabel = other.getSearchLabel();
        if (this$searchLabel == null ? other$searchLabel != null : !this$searchLabel.equals(other$searchLabel)) {
            return false;
        }
        String this$searchKey = this.getSearchKey();
        String other$searchKey = other.getSearchKey();
        if (this$searchKey == null ? other$searchKey != null : !this$searchKey.equals(other$searchKey)) {
            return false;
        }
        String this$dataUrl = this.getDataUrl();
        String other$dataUrl = other.getDataUrl();
        if (this$dataUrl == null ? other$dataUrl != null : !this$dataUrl.equals(other$dataUrl)) {
            return false;
        }
        String this$isNull = this.getIsNull();
        String other$isNull = other.getIsNull();
        if (this$isNull == null ? other$isNull != null : !this$isNull.equals(other$isNull)) {
            return false;
        }
        String this$validateType = this.getValidateType();
        String other$validateType = other.getValidateType();
        if (this$validateType == null ? other$validateType != null : !this$validateType.equals(other$validateType)) {
            return false;
        }
        String this$minLength = this.getMinLength();
        String other$minLength = other.getMinLength();
        if (this$minLength == null ? other$minLength != null : !this$minLength.equals(other$minLength)) {
            return false;
        }
        String this$maxLength = this.getMaxLength();
        String other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !this$maxLength.equals(other$maxLength)) {
            return false;
        }
        String this$minValue = this.getMinValue();
        String other$minValue = other.getMinValue();
        if (this$minValue == null ? other$minValue != null : !this$minValue.equals(other$minValue)) {
            return false;
        }
        String this$maxValue = this.getMaxValue();
        String other$maxValue = other.getMaxValue();
        return !(this$maxValue == null ? other$maxValue != null : !this$maxValue.equals(other$maxValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableColumnDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        TableDTO $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)((Object)$table)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $oldName = this.getOldName();
        result = result * 59 + ($oldName == null ? 43 : $oldName.hashCode());
        String $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
        String $oldComments = this.getOldComments();
        result = result * 59 + ($oldComments == null ? 43 : $oldComments.hashCode());
        String $jdbcType = this.getJdbcType();
        result = result * 59 + ($jdbcType == null ? 43 : $jdbcType.hashCode());
        String $oldJdbcType = this.getOldJdbcType();
        result = result * 59 + ($oldJdbcType == null ? 43 : $oldJdbcType.hashCode());
        String $javaType = this.getJavaType();
        result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
        String $javaField = this.getJavaField();
        result = result * 59 + ($javaField == null ? 43 : $javaField.hashCode());
        String $isPk = this.getIsPk();
        result = result * 59 + ($isPk == null ? 43 : $isPk.hashCode());
        String $oldIsPk = this.getOldIsPk();
        result = result * 59 + ($oldIsPk == null ? 43 : $oldIsPk.hashCode());
        String $isForm = this.getIsForm();
        result = result * 59 + ($isForm == null ? 43 : $isForm.hashCode());
        String $isList = this.getIsList();
        result = result * 59 + ($isList == null ? 43 : $isList.hashCode());
        String $isQuery = this.getIsQuery();
        result = result * 59 + ($isQuery == null ? 43 : $isQuery.hashCode());
        String $queryType = this.getQueryType();
        result = result * 59 + ($queryType == null ? 43 : $queryType.hashCode());
        String $showType = this.getShowType();
        result = result * 59 + ($showType == null ? 43 : $showType.hashCode());
        String $dictType = this.getDictType();
        result = result * 59 + ($dictType == null ? 43 : $dictType.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $fieldLabels = this.getFieldLabels();
        result = result * 59 + ($fieldLabels == null ? 43 : $fieldLabels.hashCode());
        String $fieldKeys = this.getFieldKeys();
        result = result * 59 + ($fieldKeys == null ? 43 : $fieldKeys.hashCode());
        String $searchLabel = this.getSearchLabel();
        result = result * 59 + ($searchLabel == null ? 43 : $searchLabel.hashCode());
        String $searchKey = this.getSearchKey();
        result = result * 59 + ($searchKey == null ? 43 : $searchKey.hashCode());
        String $dataUrl = this.getDataUrl();
        result = result * 59 + ($dataUrl == null ? 43 : $dataUrl.hashCode());
        String $isNull = this.getIsNull();
        result = result * 59 + ($isNull == null ? 43 : $isNull.hashCode());
        String $validateType = this.getValidateType();
        result = result * 59 + ($validateType == null ? 43 : $validateType.hashCode());
        String $minLength = this.getMinLength();
        result = result * 59 + ($minLength == null ? 43 : $minLength.hashCode());
        String $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : $maxLength.hashCode());
        String $minValue = this.getMinValue();
        result = result * 59 + ($minValue == null ? 43 : $minValue.hashCode());
        String $maxValue = this.getMaxValue();
        result = result * 59 + ($maxValue == null ? 43 : $maxValue.hashCode());
        return result;
    }
}

