/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.service.dto;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.Query;
import com.jeeplus.core.query.QueryType;
import com.jeeplus.core.service.dto.BaseDTO;
import com.jeeplus.devtools.domain.ShowType;
import com.jeeplus.devtools.service.ShowTypeService;
import com.jeeplus.devtools.service.dto.DataSourceDTO;
import com.jeeplus.devtools.service.dto.TableColumnDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TableDTO
extends BaseDTO {
    private static final long serialVersionUID = 1L;
    @Query(type=QueryType.EQ, tableColumn="a.name")
    private String name;
    private String oldName;
    @Query(tableColumn="a.comments")
    private String comments;
    private String oldComments;
    private String tableType;
    private String className;
    @Query(type=QueryType.EQ, tableColumn="a.parent_table")
    private String parentTable;
    private String parentTableFk;
    private String isSync;
    private String idType;
    private String oldIdType;
    private List<TableColumnDTO> columnList = Lists.newArrayList();
    @Query(type=QueryType.EQ, tableColumn="a.data_source_id ", javaField="dataSource.id")
    private DataSourceDTO dataSource;
    private List<TableColumnDTO> allColumnList = Lists.newArrayList();
    @Query(tableColumn="a.name")
    private String nameLike;
    private List<String> pkList;
    private TableDTO parent;
    private List<TableDTO> childList = Lists.newArrayList();

    public TableDTO() {
    }

    public TableDTO(String id) {
        super(id);
    }

    public String getNameAndComments() {
        return this.getName() + (this.comments == null ? "" : "  :  " + this.comments);
    }

    public List<String> getImportList() {
        ArrayList importList = Lists.newArrayList();
        for (TableColumnDTO column : this.getColumnList()) {
            if ((column.getIsNotBaseField().booleanValue() || "1".equals(column.getIsQuery()) && ("BETWEEN".equals(column.getQueryType()) || "BETWEEN".equals(column.getQueryType())) && ("createTime".equals(column.getSimpleJavaField()) || "updateTime".equals(column.getSimpleJavaField()))) && StringUtils.indexOf((CharSequence)column.getJavaType(), (CharSequence)".") != -1 && !importList.contains(column.getJavaType())) {
                importList.add(column.getJavaType());
            }
            if (!column.getIsNotBaseField().booleanValue()) continue;
            for (String ann : column.getAnnotationList()) {
                if (importList.contains(StringUtils.substringBeforeLast((String)ann, (String)"("))) continue;
                importList.add(StringUtils.substringBefore((String)ann, (String)"("));
            }
        }
        if (this.getChildList() != null && this.getChildList().size() > 0) {
            if (!importList.contains("java.util.List")) {
                importList.add("java.util.List");
            }
            if (!importList.contains("com.google.common.collect.Lists")) {
                importList.add("com.google.common.collect.Lists");
            }
        }
        return importList;
    }

    public List<String> getImportEntityList() {
        ArrayList importList = Lists.newArrayList();
        for (TableColumnDTO column : this.getColumnList()) {
            if (!column.getIsNotBaseField().booleanValue()) continue;
            if (StringUtils.indexOf((CharSequence)column.getJavaField(), (CharSequence)".") == -1 && StringUtils.indexOf((CharSequence)column.getJavaType(), (CharSequence)".") != -1 && !importList.contains(column.getJavaType())) {
                importList.add(column.getJavaType());
            }
            if ((!column.getIsBasicJavaType() || column.getSimpleJavaField().equals(column.getMapperJavaField())) && (column.getIsBasicJavaType() || column.getSimpleJavaFieldId().equals(column.getMapperJavaField())) || importList.contains("com.baomidou.mybatisplus.annotation.TableField")) continue;
            importList.add("com.baomidou.mybatisplus.annotation.TableField");
        }
        return importList;
    }

    public List<String> getImportGridJavaList() {
        ArrayList importList = Lists.newArrayList();
        for (TableColumnDTO column : this.getColumnList()) {
            if (column.getTableName() == null || column.getTableName().equals("") || StringUtils.indexOf((CharSequence)column.getJavaType(), (CharSequence)".") == -1 || importList.contains(column.getJavaType())) continue;
            importList.add(column.getJavaType());
        }
        return importList;
    }

    public List<String> getImportGridJavaMapperList() {
        boolean isNeedList = false;
        ArrayList importList = Lists.newArrayList();
        for (TableColumnDTO column : this.getColumnList()) {
            if (column.getTableName() == null || column.getTableName().equals("") || StringUtils.indexOf((CharSequence)column.getJavaType(), (CharSequence)".") == -1 || importList.contains(column.getJavaType())) continue;
            importList.add(column.getJavaType());
            isNeedList = true;
        }
        if (isNeedList && !importList.contains("java.util.List")) {
            importList.add("java.util.List");
        }
        return importList;
    }

    public List<TableColumnDTO> getQueryList() {
        ArrayList queryList = Lists.newArrayList();
        for (TableColumnDTO column : this.columnList) {
            if (!column.getIsQuery().equals("1")) continue;
            queryList.add(column);
        }
        return queryList;
    }

    public List<TableColumnDTO> getTableList() {
        ArrayList tableList = Lists.newArrayList();
        for (TableColumnDTO column : this.columnList) {
            if (!column.getIsList().equals("1")) continue;
            tableList.add(column);
        }
        return tableList;
    }

    public List<TableColumnDTO> getFormList() {
        ArrayList formList = Lists.newArrayList();
        for (TableColumnDTO column : this.columnList) {
            if (!column.getIsForm().equals("1") || !column.getIsNotBaseField().booleanValue()) continue;
            formList.add(column);
        }
        return formList;
    }

    public List<TableColumnDTO> getValidationList() {
        ArrayList validationList = Lists.newArrayList();
        for (TableColumnDTO column : this.columnList) {
            if ("1".equals(column.getIsNull()) && !StrUtil.isNotEmpty((CharSequence)column.getValidateType()) || !column.getIsNotBaseField().booleanValue()) continue;
            validationList.add(column);
        }
        return validationList;
    }

    public List<TableColumnDTO> getQueryBetwinDate() {
        ArrayList formList = Lists.newArrayList();
        for (TableColumnDTO column : this.getQueryList()) {
            if (!column.getShowType().equals("dateselect") || !"BETWEEN".equals(column.getQueryType()) && !"BETWEEN".equals(column.getQueryType())) continue;
            formList.add(column);
        }
        return formList;
    }

    public List<String> getQueryComponents() {
        ArrayList components = Lists.newArrayList();
        for (TableColumnDTO column : this.columnList) {
            ShowType showType;
            if (!column.getIsQuery().equals("1") || (showType = (ShowType)((Object)((LambdaQueryChainWrapper)((ShowTypeService)((Object)SpringUtil.getBean(ShowTypeService.class))).lambdaQuery().eq(ShowType::getValue, (Object)column.getShowType())).one())) == null || !StringUtils.isNotBlank((CharSequence)showType.getComponent()) || components.contains(showType.getComponent())) continue;
            components.add(showType.getComponent());
        }
        return components;
    }

    public List<String> getFormComponents() {
        ArrayList components = Lists.newArrayList();
        for (TableColumnDTO column : this.columnList) {
            ShowType showType;
            if (!column.getIsForm().equals("1") || !column.getIsNotBaseField().booleanValue() || (showType = (ShowType)((Object)((LambdaQueryChainWrapper)((ShowTypeService)((Object)SpringUtil.getBean(ShowTypeService.class))).lambdaQuery().eq(ShowType::getValue, (Object)column.getShowType())).one())) == null || !StringUtils.isNotBlank((CharSequence)showType.getComponent()) || components.contains(showType.getComponent())) continue;
            components.add(showType.getComponent());
        }
        this.childList.forEach(tableDTO -> tableDTO.getColumnList().forEach(column -> {
            ShowType showType;
            if (column.getIsForm().equals("1") && column.getIsNotBaseField().booleanValue() && (showType = (ShowType)((Object)((Object)((Object)((LambdaQueryChainWrapper)((ShowTypeService)((Object)((Object)((Object)SpringUtil.getBean(ShowTypeService.class))))).lambdaQuery().eq(ShowType::getValue, (Object)column.getShowType())).one())))) != null && StringUtils.isNotBlank((CharSequence)showType.getImportPath()) && !components.contains(showType.getComponent())) {
                components.add(showType.getComponent());
            }
        }));
        return components;
    }

    public List<String> getImportFormList() {
        ArrayList vueList = Lists.newArrayList();
        for (TableColumnDTO column : this.columnList) {
            ShowType showType;
            if (!column.getIsForm().equals("1") || !column.getIsNotBaseField().booleanValue() || (showType = (ShowType)((Object)((LambdaQueryChainWrapper)((ShowTypeService)((Object)SpringUtil.getBean(ShowTypeService.class))).lambdaQuery().eq(ShowType::getValue, (Object)column.getShowType())).one())) == null || !StringUtils.isNotBlank((CharSequence)showType.getImportPath()) || vueList.contains(showType.getImportPath())) continue;
            vueList.add(showType.getImportPath());
        }
        this.childList.forEach(tableDTO -> tableDTO.getColumnList().forEach(column -> {
            ShowType showType;
            if (column.getIsForm().equals("1") && column.getIsNotBaseField().booleanValue() && (showType = (ShowType)((Object)((Object)((Object)((LambdaQueryChainWrapper)((ShowTypeService)((Object)((Object)((Object)SpringUtil.getBean(ShowTypeService.class))))).lambdaQuery().eq(ShowType::getValue, (Object)column.getShowType())).one())))) != null && StringUtils.isNotBlank((CharSequence)showType.getImportPath()) && !vueList.contains(showType.getImportPath())) {
                vueList.add(showType.getImportPath());
            }
        }));
        return vueList;
    }

    public List<String> getImportQueryList() {
        ArrayList vueList = Lists.newArrayList();
        for (TableColumnDTO column : this.columnList) {
            ShowType showType;
            if (!column.getIsQuery().equals("1") || (showType = (ShowType)((Object)((LambdaQueryChainWrapper)((ShowTypeService)((Object)SpringUtil.getBean(ShowTypeService.class))).lambdaQuery().eq(ShowType::getValue, (Object)column.getShowType())).one())) == null || !StringUtils.isNotBlank((CharSequence)showType.getImportPath()) || vueList.contains(showType.getImportPath())) continue;
            vueList.add(showType.getImportPath());
        }
        return vueList;
    }

    public Boolean getParentExists() {
        return this.parent != null && StringUtils.isNotBlank((CharSequence)this.parentTable) && StringUtils.isNotBlank((CharSequence)this.parentTableFk);
    }

    public String getParentJavaField() {
        if (!this.getParentExists().booleanValue()) {
            return null;
        }
        String parentJavaField = null;
        for (TableColumnDTO tableColumnDTO : this.columnList) {
            if (!tableColumnDTO.getName().equals(this.parentTableFk)) continue;
            parentJavaField = tableColumnDTO.getSimpleJavaFieldId();
        }
        return parentJavaField;
    }

    public Boolean getCreateTimeExists() {
        for (TableColumnDTO c : this.columnList) {
            if (!"create_time".equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    public Boolean getUpdateTimeExists() {
        for (TableColumnDTO c : this.columnList) {
            if (!"update_time".equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    public Boolean getDelFlagExists() {
        for (TableColumnDTO c : this.columnList) {
            if (!"del_flag".equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getComments() {
        return this.comments;
    }

    public String getOldComments() {
        return this.oldComments;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getClassName() {
        return this.className;
    }

    public String getParentTable() {
        return this.parentTable;
    }

    public String getParentTableFk() {
        return this.parentTableFk;
    }

    public String getIsSync() {
        return this.isSync;
    }

    public String getIdType() {
        return this.idType;
    }

    public String getOldIdType() {
        return this.oldIdType;
    }

    public List<TableColumnDTO> getColumnList() {
        return this.columnList;
    }

    public DataSourceDTO getDataSource() {
        return this.dataSource;
    }

    public List<TableColumnDTO> getAllColumnList() {
        return this.allColumnList;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public List<String> getPkList() {
        return this.pkList;
    }

    public TableDTO getParent() {
        return this.parent;
    }

    public List<TableDTO> getChildList() {
        return this.childList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setOldComments(String oldComments) {
        this.oldComments = oldComments;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setParentTable(String parentTable) {
        this.parentTable = parentTable;
    }

    public void setParentTableFk(String parentTableFk) {
        this.parentTableFk = parentTableFk;
    }

    public void setIsSync(String isSync) {
        this.isSync = isSync;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public void setOldIdType(String oldIdType) {
        this.oldIdType = oldIdType;
    }

    public void setColumnList(List<TableColumnDTO> columnList) {
        this.columnList = columnList;
    }

    public void setDataSource(DataSourceDTO dataSource) {
        this.dataSource = dataSource;
    }

    public void setAllColumnList(List<TableColumnDTO> allColumnList) {
        this.allColumnList = allColumnList;
    }

    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    public void setPkList(List<String> pkList) {
        this.pkList = pkList;
    }

    public void setParent(TableDTO parent) {
        this.parent = parent;
    }

    public void setChildList(List<TableDTO> childList) {
        this.childList = childList;
    }

    public String toString() {
        return "TableDTO(name=" + this.getName() + ", oldName=" + this.getOldName() + ", comments=" + this.getComments() + ", oldComments=" + this.getOldComments() + ", tableType=" + this.getTableType() + ", className=" + this.getClassName() + ", parentTable=" + this.getParentTable() + ", parentTableFk=" + this.getParentTableFk() + ", isSync=" + this.getIsSync() + ", idType=" + this.getIdType() + ", oldIdType=" + this.getOldIdType() + ", columnList=" + this.getColumnList() + ", dataSource=" + this.getDataSource() + ", allColumnList=" + this.getAllColumnList() + ", nameLike=" + this.getNameLike() + ", pkList=" + this.getPkList() + ", parent=" + (Object)((Object)this.getParent()) + ", childList=" + this.getChildList() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDTO)) {
            return false;
        }
        TableDTO other = (TableDTO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$oldName = this.getOldName();
        String other$oldName = other.getOldName();
        if (this$oldName == null ? other$oldName != null : !this$oldName.equals(other$oldName)) {
            return false;
        }
        String this$comments = this.getComments();
        String other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !this$comments.equals(other$comments)) {
            return false;
        }
        String this$oldComments = this.getOldComments();
        String other$oldComments = other.getOldComments();
        if (this$oldComments == null ? other$oldComments != null : !this$oldComments.equals(other$oldComments)) {
            return false;
        }
        String this$tableType = this.getTableType();
        String other$tableType = other.getTableType();
        if (this$tableType == null ? other$tableType != null : !this$tableType.equals(other$tableType)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$parentTable = this.getParentTable();
        String other$parentTable = other.getParentTable();
        if (this$parentTable == null ? other$parentTable != null : !this$parentTable.equals(other$parentTable)) {
            return false;
        }
        String this$parentTableFk = this.getParentTableFk();
        String other$parentTableFk = other.getParentTableFk();
        if (this$parentTableFk == null ? other$parentTableFk != null : !this$parentTableFk.equals(other$parentTableFk)) {
            return false;
        }
        String this$isSync = this.getIsSync();
        String other$isSync = other.getIsSync();
        if (this$isSync == null ? other$isSync != null : !this$isSync.equals(other$isSync)) {
            return false;
        }
        String this$idType = this.getIdType();
        String other$idType = other.getIdType();
        if (this$idType == null ? other$idType != null : !this$idType.equals(other$idType)) {
            return false;
        }
        String this$oldIdType = this.getOldIdType();
        String other$oldIdType = other.getOldIdType();
        if (this$oldIdType == null ? other$oldIdType != null : !this$oldIdType.equals(other$oldIdType)) {
            return false;
        }
        List<TableColumnDTO> this$columnList = this.getColumnList();
        List<TableColumnDTO> other$columnList = other.getColumnList();
        if (this$columnList == null ? other$columnList != null : !((Object)this$columnList).equals(other$columnList)) {
            return false;
        }
        DataSourceDTO this$dataSource = this.getDataSource();
        DataSourceDTO other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !((Object)this$dataSource).equals(other$dataSource)) {
            return false;
        }
        List<TableColumnDTO> this$allColumnList = this.getAllColumnList();
        List<TableColumnDTO> other$allColumnList = other.getAllColumnList();
        if (this$allColumnList == null ? other$allColumnList != null : !((Object)this$allColumnList).equals(other$allColumnList)) {
            return false;
        }
        String this$nameLike = this.getNameLike();
        String other$nameLike = other.getNameLike();
        if (this$nameLike == null ? other$nameLike != null : !this$nameLike.equals(other$nameLike)) {
            return false;
        }
        List<String> this$pkList = this.getPkList();
        List<String> other$pkList = other.getPkList();
        if (this$pkList == null ? other$pkList != null : !((Object)this$pkList).equals(other$pkList)) {
            return false;
        }
        TableDTO this$parent = this.getParent();
        TableDTO other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)((Object)this$parent)).equals((Object)other$parent)) {
            return false;
        }
        List<TableDTO> this$childList = this.getChildList();
        List<TableDTO> other$childList = other.getChildList();
        return !(this$childList == null ? other$childList != null : !((Object)this$childList).equals(other$childList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $oldName = this.getOldName();
        result = result * 59 + ($oldName == null ? 43 : $oldName.hashCode());
        String $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
        String $oldComments = this.getOldComments();
        result = result * 59 + ($oldComments == null ? 43 : $oldComments.hashCode());
        String $tableType = this.getTableType();
        result = result * 59 + ($tableType == null ? 43 : $tableType.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $parentTable = this.getParentTable();
        result = result * 59 + ($parentTable == null ? 43 : $parentTable.hashCode());
        String $parentTableFk = this.getParentTableFk();
        result = result * 59 + ($parentTableFk == null ? 43 : $parentTableFk.hashCode());
        String $isSync = this.getIsSync();
        result = result * 59 + ($isSync == null ? 43 : $isSync.hashCode());
        String $idType = this.getIdType();
        result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
        String $oldIdType = this.getOldIdType();
        result = result * 59 + ($oldIdType == null ? 43 : $oldIdType.hashCode());
        List<TableColumnDTO> $columnList = this.getColumnList();
        result = result * 59 + ($columnList == null ? 43 : ((Object)$columnList).hashCode());
        DataSourceDTO $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : ((Object)$dataSource).hashCode());
        List<TableColumnDTO> $allColumnList = this.getAllColumnList();
        result = result * 59 + ($allColumnList == null ? 43 : ((Object)$allColumnList).hashCode());
        String $nameLike = this.getNameLike();
        result = result * 59 + ($nameLike == null ? 43 : $nameLike.hashCode());
        List<String> $pkList = this.getPkList();
        result = result * 59 + ($pkList == null ? 43 : ((Object)$pkList).hashCode());
        TableDTO $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)((Object)$parent)).hashCode());
        List<TableDTO> $childList = this.getChildList();
        result = result * 59 + ($childList == null ? 43 : ((Object)$childList).hashCode());
        return result;
    }
}

