/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;

public class SerialNumberUtil {
    public static String getMotherboardSN() {
        Object result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs);
            fw.close();
            String path = file.getPath().replace("%20", " ");
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + path);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = (String)result + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((String)result).trim();
    }

    public static String getHardDiskSN(String drive) {
        Object result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"" + drive + "\")\nWscript.Echo objDrive.SerialNumber";
            fw.write(vbs);
            fw.close();
            String path = file.getPath().replace("%20", " ");
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + path);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream(), "GBk"));
            while ((line = input.readLine()) != null) {
                result = (String)result + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((String)result).trim();
    }

    public static String getCPUSerial() {
        Object result = "";
        try {
            String line;
            File file = File.createTempFile("tmp", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_Processor\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.ProcessorId \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs);
            fw.close();
            String path = file.getPath().replace("%20", " ");
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + path);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = (String)result + line;
            }
            input.close();
            file.delete();
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        if (((String)result).trim().length() < 1 || result == null) {
            result = "\u65e0CPU_ID\u88ab\u8bfb\u53d6";
        }
        return ((String)result).trim();
    }

    private static List<String> getLocalHostLANAddress() throws UnknownHostException, SocketException {
        ArrayList<String> ips = new ArrayList<String>();
        Enumeration<NetworkInterface> interfs = NetworkInterface.getNetworkInterfaces();
        while (interfs.hasMoreElements()) {
            NetworkInterface interf = interfs.nextElement();
            Enumeration<InetAddress> addres = interf.getInetAddresses();
            while (addres.hasMoreElements()) {
                InetAddress in = addres.nextElement();
                if (!(in instanceof Inet4Address) || "127.0.0.1".equals(in.getHostAddress())) continue;
                ips.add(in.getHostAddress());
            }
        }
        return ips;
    }

    public static String getMac() {
        try {
            Object resultStr = "";
            List<String> ls = SerialNumberUtil.getLocalHostLANAddress();
            for (String str : ls) {
                InetAddress ia = InetAddress.getByName(str);
                byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    String s;
                    if (i != 0) {
                        sb.append("-");
                    }
                    sb.append((String)((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? "0" + s : s));
                }
                resultStr = (String)resultStr + sb.toString().toUpperCase() + ",";
            }
            return resultStr;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String executeLinuxCmd(String cmd) {
        try {
            int n;
            Runtime run = Runtime.getRuntime();
            Process process = run.exec(cmd);
            InputStream in = process.getInputStream();
            BufferedReader bs = new BufferedReader(new InputStreamReader(in));
            StringBuffer out = new StringBuffer();
            byte[] b = new byte[8192];
            while ((n = in.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
            in.close();
            process.destroy();
            return out.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSerialNumber(String cmd, String record, String symbol) {
        String[] infos;
        String execResult = SerialNumberUtil.executeLinuxCmd(cmd);
        for (String info : infos = execResult.split("\n")) {
            if ((info = info.trim()).indexOf(record) == -1) continue;
            info.replace(" ", "");
            String[] sn = info.split(symbol);
            return sn[1];
        }
        return null;
    }

    public static String getM() {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append("D");
                }
                sb.append((String)((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? "0" + s : s));
            }
            return sb.toString().toUpperCase();
        }
        catch (Exception e) {
            return "BDBEFHSLKOMQA";
        }
    }

    public static String getAllSn() {
        String os = System.getProperty("os.name");
        os = os.toUpperCase();
        HashMap snVo = new HashMap();
        try {
            Object license;
            if ("MAC OS X".equals(os)) {
                String mac1 = SerialNumberUtil.getSerialNumber("ioreg -rd1 -c IOPlatformExpertDevice | awk '/IOPlatformUUID/ { split($0, line, \"\\\"\"); printf(\"%s\\n\", line[4]); }'", "IOPlatformUUID", " = ");
                String mac2 = SerialNumberUtil.getSerialNumber("ioreg -rd1 -c IOPlatformExpertDevice | awk '/IOPlatformUUID/ { split($0, line, \"\\\"\"); printf(\"%s\\n\", line[4]); }'", "IOPlatformSerialNumber", " = ");
                license = mac1.replace("\"", "").replace("-", "").trim().toUpperCase() + mac2.replace("\"", "").replace("-", "").trim().toUpperCase();
            } else if ("LINUX".equals(os) || os.contains("linux") || os.contains("MAC")) {
                String cpuid = SerialNumberUtil.getSerialNumber("dmidecode -t processor | grep 'ID'", "ID", ":");
                String mainboardNumber = SerialNumberUtil.getSerialNumber("dmidecode |grep 'Serial Number'", "Serial Number", ":");
                String diskNumber = SerialNumberUtil.getSerialNumber("fdisk -l", "Disk identifier", ":");
                license = cpuid.replace("\"", "").replace("-", "").trim().toUpperCase() + mainboardNumber.replace("\"", "").replace("-", "").trim().toUpperCase() + diskNumber.replace("\"", "").replace("-", "").trim().toUpperCase();
            } else {
                String cpuid = SerialNumberUtil.getCPUSerial();
                String mainboard = SerialNumberUtil.getMotherboardSN();
                String disk = SerialNumberUtil.getHardDiskSN("c");
                license = cpuid.replace("\"", "").replace("-", "").trim().toUpperCase() + mainboard.replace("\"", "").replace("-", "").trim().toUpperCase() + disk.replace("\"", "").replace("-", "").trim().toUpperCase();
            }
            license = ((String)license).replace(" ", "").replace(".", "");
            if (((String)license).contains("\u8f93\u5165") || ((String)license).contains("\u9519\u8bef")) {
                return SerialNumberUtil.getM();
            }
            return license;
        }
        catch (Exception e) {
            return SerialNumberUtil.getM();
        }
    }

    public static void main(String[] args) {
        System.out.println(SerialNumberUtil.getM());
    }
}

