/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.devtools.domain.CustomObj;
import com.jeeplus.devtools.domain.Scheme;
import com.jeeplus.devtools.service.CustomObjService;
import com.jeeplus.devtools.service.SchemaService;
import com.jeeplus.devtools.service.TableService;
import com.jeeplus.devtools.service.dto.CustomFieldDTO;
import com.jeeplus.devtools.service.dto.CustomObjDTO;
import com.jeeplus.devtools.service.dto.TableColumnDTO;
import com.jeeplus.devtools.service.dto.TableDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/devtools/customObj"})
public class CustomObjController {
    @Autowired
    private CustomObjService customObjService;
    @Autowired
    public SchemaService schemaService;
    @Autowired
    public TableService tableService;

    @GetMapping(value={"list"})
    public ResponseEntity<IPage<CustomObj>> list(CustomObj customObj, Page<CustomObj> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)customObj), CustomObj.class);
        if (page.orders().size() == 0) {
            queryWrapper.orderByAsc((Object)"sort");
        }
        IPage result = this.customObjService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"queryById"})
    public ResponseEntity form(@RequestParam(value="id") String id) {
        CustomObjDTO customObjDTO = this.customObjService.getById(id);
        return ResponseEntity.ok((Object)((Object)customObjDTO));
    }

    @PostMapping(value={"save"})
    public ResponseEntity save(@RequestBody CustomObjDTO customObjDTO) {
        this.customObjService.saveOrUpdate(customObjDTO);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u81ea\u5b9a\u4e49\u5bf9\u8c61\u6210\u529f");
    }

    @PostMapping(value={"add"})
    public ResponseEntity add(@RequestParam(name="tableId", required=false) String tableId, @RequestParam(name="tableType", required=false) String tableType) {
        Scheme genScheme = (Scheme)((Object)((LambdaQueryChainWrapper)this.schemaService.lambdaQuery().eq(Scheme::getTableId, (Object)tableId)).one());
        if (genScheme == null) {
            return ResponseEntity.badRequest().body((Object)"\u6dfb\u52a0JAVA\u81ea\u5b9a\u4e49\u5bf9\u8c61\u5931\u8d25,\u8bf7\u5148\u751f\u6210\u4ee3\u7801!\u6216\u8005\u4f60\u53ef\u4ee5\u5230\u81ea\u5b9a\u4e49\u5bf9\u8c61\u7ba1\u7406\u4e2d\u624b\u52a8\u6dfb\u52a0\u3002");
        }
        TableDTO tableDTO = this.tableService.getById(genScheme.getTableId());
        CustomObjDTO customObjDTO = new CustomObjDTO();
        customObjDTO.setLabel(tableDTO.getClassName() + "DTO");
        customObjDTO.setType("0");
        Object classname = tableDTO.getClassName();
        if (StringUtils.isNotBlank((CharSequence)classname)) {
            classname = ((String)classname).substring(0, 1).toLowerCase() + ((String)classname).substring(1);
        }
        String fullPath = genScheme.getPackageName() + "." + genScheme.getModuleName() + (String)(StringUtils.isBlank((CharSequence)genScheme.getSubModuleName()) ? "" : "." + StringUtils.lowerCase((String)genScheme.getSubModuleName())) + ".service.dto." + tableDTO.getClassName() + "DTO";
        customObjDTO.setValue(fullPath);
        customObjDTO.setTableName(tableDTO.getName());
        String dataURl = "import " + (String)classname + "Service from '@/api/" + genScheme.getModuleName() + (String)(StringUtils.isNotBlank((CharSequence)genScheme.getSubModuleName()) ? "/" + StringUtils.lowerCase((String)genScheme.getSubModuleName()) : "") + "/" + (String)classname + "Service'";
        if ("3".equals(tableType) || "4".equals(tableType)) {
            customObjDTO.setDataUrl(dataURl);
        } else {
            customObjDTO.setDataUrl(dataURl);
        }
        List all = ((LambdaQueryChainWrapper)this.customObjService.lambdaQuery().orderByAsc(CustomObj::getSort)).list();
        int sort = 10;
        if (all.size() > 1) {
            sort += ((CustomObj)((Object)all.get(all.size() - 1))).getSort().intValue();
        }
        customObjDTO.setSort(sort);
        customObjDTO.setDescription(tableDTO.getComments());
        ArrayList list = Lists.newArrayList();
        for (TableColumnDTO column : tableDTO.getColumnList()) {
            CustomFieldDTO field = new CustomFieldDTO();
            field.setName(column.getJavaField());
            field.setSort(column.getSort());
            field.setRemarks(column.getComments());
            field.setDelFlag(0);
            field.setId("");
            list.add(field);
        }
        customObjDTO.setCustomFieldDTOList(list);
        this.customObjService.saveOrUpdate(customObjDTO);
        return ResponseEntity.ok((Object)"\u6dfb\u52a0\u81ea\u5b9a\u4e49\u5bf9\u8c61\u6210\u529f\uff01\u8bf7\u5230\u81ea\u5b9a\u4e49\u5bf9\u8c61\u7ba1\u7406\u4e2d\u67e5\u770b\u3002");
    }

    @GetMapping(value={"getByValue"})
    public ResponseEntity getByValue(@RequestParam(value="value") String value) {
        CustomObjDTO customObjDTO = this.customObjService.getByValue(value);
        return ResponseEntity.ok((Object)((Object)customObjDTO));
    }

    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(@RequestParam(value="ids") String ids) {
        String[] idArray;
        for (String id : idArray = ids.split(",")) {
            this.customObjService.removeById(id);
        }
        return ResponseEntity.ok((Object)"\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u8c61\u6210\u529f");
    }
}

