/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.controller;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.jeeplus.devtools.domain.Menu;
import com.jeeplus.devtools.domain.Scheme;
import com.jeeplus.devtools.service.MenuService;
import com.jeeplus.devtools.service.SchemaService;
import com.jeeplus.devtools.service.TableService;
import com.jeeplus.devtools.service.dto.MenuDTO;
import com.jeeplus.devtools.service.dto.SchemeDTO;
import com.jeeplus.devtools.service.dto.TableDTO;
import com.jeeplus.devtools.service.mapstruct.GenMenuWrapper;
import com.jeeplus.devtools.service.mapstruct.SchemeWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/devtools/scheme"})
public class SchemeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemeController.class);
    @Autowired
    public SchemaService schemaService;
    @Autowired
    public TableService tableService;
    @Autowired
    private MenuService menuService;
    @Value(value="${demoMode}")
    public boolean demoMode;

    @GetMapping(value={"getFileTree"})
    public ResponseEntity getFileTree(@RequestParam(name="parentNode", required=false) String parentNode) {
        ArrayList list = Lists.newArrayList();
        try {
            if (StringUtils.isEmpty((CharSequence)parentNode)) {
                File[] roots;
                for (File r : roots = File.listRoots()) {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    item.put("id", r.getAbsolutePath());
                    item.put("text", r.getPath());
                    if (this.hasDirs(r)) {
                        item.put("isLeaf", false);
                    } else {
                        item.put("isLeaf", true);
                    }
                    list.add(item);
                }
            } else {
                File[] chs;
                File parent = new File(parentNode);
                for (File r : chs = parent.listFiles()) {
                    HashMap<String, Object> item = new HashMap<String, Object>();
                    if (!r.isDirectory()) continue;
                    item.put("id", r.getAbsolutePath());
                    item.put("text", r.getPath());
                    if (this.hasDirs(r)) {
                        item.put("isLeaf", false);
                    } else {
                        item.put("isLefa", true);
                    }
                    list.add(item);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8be5\u6587\u4ef6\u5939\u4e0d\u53ef\u9009\u62e9");
        }
        return ResponseEntity.ok((Object)list);
    }

    private boolean hasDirs(File dir) {
        try {
            return dir.listFiles().length != 0;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return false;
        }
    }

    @RequestMapping(value={"save"})
    public ResponseEntity save(@RequestBody SchemeDTO schemeDTO) throws Exception {
        String result = this.schemaService.saveOrUpdate(schemeDTO);
        return ResponseEntity.ok((Object)("\u64cd\u4f5c\u751f\u6210\u65b9\u6848'" + schemeDTO.getName() + "'\u6210\u529f<br/>" + result));
    }

    @PostMapping(value={"createMenu"})
    public ResponseEntity createMenu(@RequestParam(name="tableId", required=false) String tableId, @RequestParam(name="tableType", required=false) String tableType, MenuDTO menuDTO) throws Exception {
        if (this.demoMode) {
            return ResponseEntity.badRequest().body((Object)"\u6f14\u793a\u6a21\u5f0f\uff0c\u7981\u6b62\u64cd\u4f5c\uff01");
        }
        Scheme scheme = (Scheme)((Object)((LambdaQueryChainWrapper)this.schemaService.lambdaQuery().eq(Scheme::getTableId, (Object)tableId)).one());
        if (scheme == null) {
            return ResponseEntity.badRequest().body((Object)"\u521b\u5efa\u83dc\u5355\u5931\u8d25,\u8bf7\u5148\u751f\u6210\u4ee3\u7801!");
        }
        SchemeDTO schemeDTO = SchemeWrapper.INSTANCE.toDTO(scheme);
        Menu menu = (Menu)((Object)GenMenuWrapper.INSTANCE.toEntity((Object)menuDTO));
        menu.setIsShow("1");
        menu.setAffix("0");
        menu.setHiddenBreadcrumb("0");
        if (StringUtils.isBlank((CharSequence)menu.getId())) {
            ArrayList list = Lists.newArrayList();
            List<MenuDTO> sourceList = this.menuService.findAllMenu();
            MenuDTO.sortList(list, sourceList, menu.getParentId(), false);
            if (list.size() > 0) {
                Integer sort = ((MenuDTO)((Object)list.get(list.size() - 1))).getSort();
                if (sort == null) {
                    menu.setSort(30);
                } else {
                    menu.setSort(sort + 30);
                }
            }
        }
        if ("4".equals(tableType)) {
            TableDTO parentTable = new TableDTO();
            parentTable.setParentTable(this.tableService.getById(tableId).getName());
            TableDTO childTable = this.tableService.findList(parentTable).get(0);
            schemeDTO.setTable(childTable);
        } else {
            schemeDTO.setTable(this.tableService.getById(tableId));
        }
        this.schemaService.createMenu(schemeDTO, menu);
        return ResponseEntity.ok((Object)("\u521b\u5efa\u83dc\u5355'" + menu.getName() + "'\u6210\u529f"));
    }
}

