/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.devtools.domain.ShowType;
import com.jeeplus.devtools.service.ShowTypeService;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/devtools/showType"})
public class ShowTypeController {
    @Autowired
    private ShowTypeService showTypeService;

    @PreAuthorize(value="hasAuthority('gencode:showType:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<ShowType>> list(ShowType showType, Page<ShowType> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)showType), ShowType.class);
        if (page.orders().size() == 0) {
            queryWrapper.orderByAsc((Object)"sort");
        }
        IPage result = this.showTypeService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"queryById"})
    public ResponseEntity queryById(@RequestParam(value="id") String id) {
        ShowType showType = (ShowType)((Object)this.showTypeService.getById((Serializable)((Object)id)));
        return ResponseEntity.ok((Object)((Object)showType));
    }

    @PostMapping(value={"save"})
    public ResponseEntity save(@RequestBody ShowType showType) {
        if (StringUtils.isBlank((CharSequence)showType.getId()) && ((LambdaQueryChainWrapper)this.showTypeService.lambdaQuery().eq(ShowType::getValue, (Object)showType.getValue())).one() != null) {
            return ResponseEntity.badRequest().body((Object)(showType.getValue() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0!"));
        }
        this.showTypeService.saveOrUpdate((Object)showType);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u63a7\u4ef6\u7c7b\u578b\u6210\u529f");
    }

    @PreAuthorize(value="hasAuthority('gencode:showType:del')")
    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(@RequestParam(value="ids") String ids) {
        Object[] idArray = ids.split(",");
        this.showTypeService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u63a7\u4ef6\u7c7b\u578b\u6210\u529f");
    }
}

