/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.controller;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jeeplus.common.utils.ResponseUtil;
import com.jeeplus.core.domain.BaseEntity;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.devtools.domain.CodeParam;
import com.jeeplus.devtools.domain.CustomObj;
import com.jeeplus.devtools.domain.QueryType;
import com.jeeplus.devtools.domain.Scheme;
import com.jeeplus.devtools.domain.ShowType;
import com.jeeplus.devtools.domain.Table;
import com.jeeplus.devtools.domain.TableColumn;
import com.jeeplus.devtools.domain.TemplateGroup;
import com.jeeplus.devtools.domain.ValidateType;
import com.jeeplus.devtools.mapper.DataBaseDictMapper;
import com.jeeplus.devtools.service.CodeParamService;
import com.jeeplus.devtools.service.CustomObjService;
import com.jeeplus.devtools.service.DataBaseTypeService;
import com.jeeplus.devtools.service.QueryTypeService;
import com.jeeplus.devtools.service.SchemaService;
import com.jeeplus.devtools.service.ShowTypeService;
import com.jeeplus.devtools.service.TableColumnService;
import com.jeeplus.devtools.service.TableService;
import com.jeeplus.devtools.service.TemplateGroupService;
import com.jeeplus.devtools.service.TemplateService;
import com.jeeplus.devtools.service.ValidateTypeService;
import com.jeeplus.devtools.service.dto.ConfigDTO;
import com.jeeplus.devtools.service.dto.DataSourceDTO;
import com.jeeplus.devtools.service.dto.SchemeDTO;
import com.jeeplus.devtools.service.dto.TableColumnDTO;
import com.jeeplus.devtools.service.dto.TableDTO;
import com.jeeplus.devtools.util.CodeUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="genTableController")
@RequestMapping(value={"/devtools/table"})
public class TableController {
    @Value(value="${demoMode}")
    public boolean demoMode;
    @Value(value="${devtool.enabled}")
    private boolean enabled;
    @Value(value="${devtool.projectPath}")
    private String projectPath;
    @Value(value="${devtool.frontPath}")
    private String frontPath;
    @Value(value="${devtool.packageName}")
    private String packageName;
    @Value(value="${devtool.author}")
    private String author;
    @Autowired
    public TemplateService templateService;
    @Autowired
    public TableService tableService;
    @Autowired
    public SchemaService schemaService;
    @Autowired
    private TableColumnService tableColumnService;
    @Autowired
    private DataBaseDictMapper dataBaseDictMapper;
    @Autowired
    private CustomObjService customObjService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Autowired
    private DynamicRoutingDataSource dynamicRoutingDataSource;
    @Autowired
    private DatabaseIdProvider databaseIdProvider;
    @Autowired
    private QueryTypeService queryTypeService;
    @Autowired
    private ValidateTypeService validateTypeService;
    @Autowired
    private DataBaseTypeService dataBaseTypeService;
    @Autowired
    private ShowTypeService showTypeService;
    @Autowired
    private CodeParamService codeParamService;
    @Value(value="${license}")
    private String license;
    @Value(value="${spring.datasource.dynamic.primary}")
    public String primary;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.setAutoGrowCollectionLimit(1024);
    }

    @GetMapping(value={"list"})
    public ResponseEntity list(Page<TableDTO> page, TableDTO tableDTO, HttpServletRequest request) throws Exception {
        String machineCode = CodeUtils.getM();
        if (StringUtils.isEmpty((CharSequence)this.license)) {
            return ResponseUtil.newInstance().add("serial", (Object)machineCode).add("code", (Object)700).ok("\u6ca1\u6709\u914d\u7f6elicense");
        }
        String ming = CodeUtils.getSerial(this.license);
        if (ming.contains("_date")) {
            String mc = ming.split("_date_")[0];
            String endDate = CodeUtils.getSerial(this.license).split("_date_")[1];
            if (!mc.equals(machineCode)) {
                return ResponseUtil.newInstance().add("serial", (Object)machineCode).add("code", (Object)700).ok("\u60a8\u7684license\u975e\u6cd5");
            }
            if (CodeUtils.getCurrentTime() > CodeUtils.transferString2Date(endDate).getTime()) {
                return ResponseUtil.newInstance().add("serial", (Object)machineCode).add("code", (Object)700).ok("\u60a8\u7684\u5f00\u53d1\u8005\u5de5\u5177\u8ba2\u9605\u5df2\u8fc7\u671f!");
            }
        } else if (!ming.equals(machineCode)) {
            return ResponseUtil.newInstance().add("serial", (Object)machineCode).add("code", (Object)700).ok("\u60a8\u7684license\u975e\u6cd5");
        }
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)tableDTO), TableDTO.class);
        IPage<TableDTO> result = this.tableService.findPage(page, queryWrapper);
        return ResponseUtil.newInstance().add("code", (Object)200).add("result", result).ok();
    }

    @RequestMapping(value={"queryById"})
    public ResponseEntity queryById(@RequestParam(value="id") String id) {
        TableDTO tableDTO = this.tableService.getById(id);
        return ResponseEntity.ok((Object)((Object)tableDTO));
    }

    @RequestMapping(value={"copyTable"})
    public ResponseEntity copyTable(@RequestParam(value="id") String id, @RequestParam(value="newTableName") String newTableName) {
        TableDTO sourceTable = this.tableService.getById(id);
        if (StringUtils.isNotBlank((CharSequence)newTableName)) {
            TableDTO table = new TableDTO();
            table.setDataSource(sourceTable.getDataSource());
            table.setName(newTableName);
            if (!this.tableService.checkTableName(table)) {
                return ResponseEntity.badRequest().body((Object)("\u590d\u5236\u3010" + sourceTable.getName() + "\u3011 \u5931\u8d25\uff0c\u8868\u5355\u8bb0\u5f55\u3010" + newTableName + "\u3011\u5df2\u7ecf\u5b58\u5728, \u8bf7\u66f4\u6362\u4e2a\u8868\u540d!"));
            }
            if (!this.tableService.checkTableNameFromDB(table)) {
                return ResponseEntity.badRequest().body((Object)("\u590d\u5236\u3010" + sourceTable.getName() + "\u3011 \u5931\u8d25\uff0c\u8868\u540d\u4e3a\u3010" + newTableName + "\u3011\u7684\u8868\u5df2\u7ecf\u5728\u6570\u636e\u5e93\u3010" + sourceTable.getDataSource().getName() + "\u3011\u4e2d\u5b58\u5728,\u8bf7\u4ece\u6570\u636e\u5e93\u5bfc\u5165\u8868\u5355\uff01"));
            }
            this.tableService.copyTable(sourceTable, newTableName);
        }
        return ResponseEntity.ok((Object)"\u590d\u5236\u6210\u529f!");
    }

    @GetMapping(value={"queryConfig"})
    public ResponseEntity queryConfig() throws Exception {
        ConfigDTO config = new ConfigDTO();
        config.getJavaTypeList().addAll(((LambdaQueryChainWrapper)this.customObjService.lambdaQuery().orderByAsc(CustomObj::getSort)).list());
        config.getQueryTypeList().addAll(((LambdaQueryChainWrapper)this.queryTypeService.lambdaQuery().orderByAsc(QueryType::getSort)).list());
        config.getShowTypeList().addAll(((LambdaQueryChainWrapper)this.showTypeService.lambdaQuery().orderByAsc(ShowType::getSort)).list());
        config.getValidateTypeList().addAll(((LambdaQueryChainWrapper)this.validateTypeService.lambdaQuery().orderByAsc(ValidateType::getSort)).list());
        config.getMysqlFieldType().addAll(this.dataBaseTypeService.getTableFiledByDbType("mysql"));
        config.getOracleFieldType().addAll(this.dataBaseTypeService.getTableFiledByDbType("oracle"));
        config.getPostGreSqlFieldType().addAll(this.dataBaseTypeService.getTableFiledByDbType("postgre"));
        config.getMssqlFieldType().addAll(this.dataBaseTypeService.getTableFiledByDbType("mssql"));
        return ResponseUtil.newInstance().add("config", (Object)config).add("tableList", this.tableService.findList(new TableDTO())).ok();
    }

    @PostMapping(value={"save"})
    public ResponseEntity save(@RequestBody TableDTO tableDTO) {
        String machineCode = CodeUtils.getM();
        if (StringUtils.isEmpty((CharSequence)this.license)) {
            return ResponseUtil.newInstance().add("serial", (Object)machineCode).add("code", (Object)700).ok("\u6ca1\u6709\u914d\u7f6elicense");
        }
        String ming = CodeUtils.getSerial(this.license);
        if (ming.contains("_date")) {
            String mc = ming.split("_date_")[0];
            String endDate = CodeUtils.getSerial(this.license).split("_date_")[1];
            if (!mc.equals(machineCode)) {
                return ResponseUtil.newInstance().add("serial", (Object)machineCode).add("code", (Object)700).ok("\u60a8\u7684license\u975e\u6cd5");
            }
            if (CodeUtils.getCurrentTime() > CodeUtils.transferString2Date(endDate).getTime()) {
                return ResponseUtil.newInstance().add("serial", (Object)machineCode).add("code", (Object)700).ok("\u60a8\u7684\u5f00\u53d1\u8005\u5de5\u5177\u8ba2\u9605\u5df2\u8fc7\u671f!");
            }
        } else if (!ming.equals(machineCode)) {
            return ResponseUtil.newInstance().add("serial", (Object)machineCode).add("code", (Object)700).ok("\u60a8\u7684license\u975e\u6cd5");
        }
        TableDTO oldGenTable = this.tableService.get(tableDTO);
        tableDTO.setOldComments(oldGenTable.getOldComments());
        tableDTO.setOldName(oldGenTable.getOldName());
        tableDTO.setOldIdType(oldGenTable.getOldIdType());
        tableDTO = this.tableService.getTableDTOWithDataSource(tableDTO);
        if (StringUtils.isBlank((CharSequence)tableDTO.getId()) && !this.tableService.checkTableName(tableDTO)) {
            return ResponseEntity.badRequest().body((Object)("\u6dfb\u52a0\u5931\u8d25\uff01" + tableDTO.getName() + " \u8bb0\u5f55\u5df2\u5b58\u5728\uff01"));
        }
        if (StringUtils.isBlank((CharSequence)tableDTO.getId()) && !this.tableService.checkTableNameFromDB(tableDTO)) {
            return ResponseEntity.badRequest().body((Object)("\u6dfb\u52a0\u5931\u8d25\uff01" + tableDTO.getName() + "\u8868\u5df2\u7ecf\u5728\u6570\u636e\u5e93\u3010" + tableDTO.getDataSource().getName() + "\u3011\u4e2d\u5b58\u5728,\u8bf7\u4ece\u6570\u636e\u5e93\u5bfc\u5165\u8868\u5355\uff01"));
        }
        if (StringUtils.isNotBlank((CharSequence)tableDTO.getId()) && !tableDTO.getName().equals(oldGenTable.getName()) && !this.tableService.checkTableName(tableDTO)) {
            return ResponseEntity.badRequest().body((Object)("\u91cd\u547d\u540d\u5931\u8d25\uff01" + tableDTO.getName() + " \u8bb0\u5f55\u5df2\u5b58\u5728\uff01"));
        }
        if (StringUtils.isNotBlank((CharSequence)tableDTO.getId()) && !tableDTO.getName().equals(oldGenTable.getName()) && !this.tableService.checkTableNameFromDB(tableDTO)) {
            return ResponseEntity.badRequest().body((Object)("\u91cd\u547d\u540d\u5931\u8d25\uff01" + tableDTO.getName() + "\u8868\u5df2\u7ecf\u5728\u6570\u636e\u5e93\u3010" + tableDTO.getDataSource().getName() + "\u3011\u4e2d\u5b58\u5728,\u8bf7\u4ece\u6570\u636e\u5e93\u5bfc\u5165\u8868\u5355\uff01"));
        }
        List<TableColumnDTO> columns = tableDTO.getColumnList();
        for (TableColumnDTO column : columns) {
            CustomObj customObj;
            if (StringUtils.isNotBlank((CharSequence)column.getId())) {
                TableColumn old = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                column.setOldIsPk(old.getOldIsPk());
                column.setOldJdbcType(old.getOldJdbcType());
                column.setOldName(old.getOldName());
                column.setOldComments(old.getOldComments());
            }
            if ("gridselect".equals(column.getShowType())) {
                if ("This".equals(column.getJavaType())) continue;
                customObj = (CustomObj)((Object)((LambdaQueryChainWrapper)this.customObjService.lambdaQuery().eq(CustomObj::getValue, (Object)column.getJavaType())).one());
                if (customObj == null) {
                    return ResponseEntity.badRequest().body((Object)(column.getJavaField() + "\u5b57\u6bb5\u5bf9\u5e94\u7684\u663e\u793a\u8868\u5355\u7c7b\u578b\u4f60\u9009\u62e9\u4e86\u3010gridselect\u3011\u6216\u8005\u3010\u6811\u9009\u62e9\u63a7\u4ef6\u3011\uff0c<br/>\u4f46\u662f\u5bf9\u5e94\u7684java\u7c7b\u578b\u4f60\u6ca1\u6709\u5173\u8054\u81ea\u5b9a\u4e49java\u5bf9\u8c61\uff01<br/>"));
                }
                column.setDataUrl(customObj.getDataUrl());
                column.setTableName(customObj.getTableName());
                continue;
            }
            if (!"treeselect".equals(column.getShowType()) || "This".equals(column.getJavaType()) || column.getName().equals(tableDTO.getParentTableFk())) continue;
            customObj = (CustomObj)((Object)((LambdaQueryChainWrapper)this.customObjService.lambdaQuery().eq(CustomObj::getValue, (Object)column.getJavaType())).one());
            if (customObj == null) {
                return ResponseEntity.badRequest().body((Object)(column.getJavaField() + "\u5b57\u6bb5\u5bf9\u5e94\u7684\u663e\u793a\u8868\u5355\u7c7b\u578b\u4f60\u9009\u62e9\u4e86\u3010gridselect\u3011\u6216\u8005\u3010\u6811\u9009\u62e9\u63a7\u4ef6\u3011\uff0c<br/>\u4f46\u662f\u5bf9\u5e94\u7684java\u7c7b\u578b\u4f60\u6ca1\u6709\u5173\u8054\u81ea\u5b9a\u4e49java\u5bf9\u8c61\uff01<br/>"));
            }
            column.setDataUrl(customObj.getDataUrl());
            column.setTableName(customObj.getTableName());
        }
        if (StringUtils.isNotBlank((CharSequence)tableDTO.getOldName()) && !this.tableService.checkTableNameFromDB(tableDTO)) {
            this.tableService.save(tableDTO);
        } else {
            this.tableService.saveNewTable(tableDTO);
        }
        return ResponseEntity.ok((Object)("\u4fdd\u5b58\u4e1a\u52a1\u8868'" + tableDTO.getName() + "'\u6210\u529f"));
    }

    @PostMapping(value={"saveTableFromDB"})
    public ResponseEntity saveTableFromDB(@RequestBody TableDTO tableDTO) {
        StringBuffer msg = new StringBuffer();
        String name = tableDTO.getName();
        String[] tableNames = name.split(",");
        DataSourceDTO dataSource = this.tableService.getDataSource(tableDTO.getDataSource().getId());
        for (String tableName : tableNames) {
            if (!StringUtils.isNotBlank((CharSequence)tableName)) continue;
            TableDTO table = new TableDTO();
            table.setDataSource(dataSource);
            table.setName(tableName);
            if (!this.tableService.checkTableName(table)) {
                msg.append("<font color='red'>\u6570\u636e\u5e93\u5bfc\u5165\u8868\u5355" + tableName + " \u5931\u8d25\uff0c\u8868\u5df2\u7ecf\u6dfb\u52a0!</font><br/>");
                continue;
            }
            table = this.tableService.getTableFormDb(table);
            CodeUtils.initColumnField(table);
            table.setTableType("0");
            table.setIsSync("1");
            table.setDataSource(dataSource);
            this.tableService.saveFromDB(table);
            msg.append("<font color='green'>\u6570\u636e\u5e93\u5bfc\u5165\u8868\u5355'" + table.getName() + "'\u6210\u529f!</font><br/>");
        }
        return ResponseEntity.ok((Object)msg.toString());
    }

    @PreAuthorize(value="hasAuthority('gencode:table:importDb')")
    @GetMapping(value={"importTableData"})
    public ResponseEntity importTableData(TableDTO tableDTO) {
        List<TableDTO> tableList = this.tableService.findTableListFormDb(tableDTO);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rows", tableList);
        map.put("total", tableList.size());
        return ResponseEntity.ok(map);
    }

    @PreAuthorize(value="hasAuthority('gencode:table:del')")
    @RequestMapping(value={"deleteDb"})
    public ResponseEntity deleteDb(TableDTO tableDTO) throws Exception {
        if (this.demoMode) {
            return ResponseEntity.badRequest().body((Object)"\u6f14\u793a\u6a21\u5f0f\uff0c\u7981\u6b62\u64cd\u4f5c\uff01");
        }
        StringBuffer sql = new StringBuffer();
        String dbType = this.databaseIdProvider.getDatabaseId(this.dynamicRoutingDataSource.getDataSource((tableDTO = this.tableService.get(tableDTO)).getDataSource().getEnName()));
        if ("postgre".equals(dbType)) {
            sql.append("drop table if exists " + tableDTO.getName() + " ;");
        } else if ("mysql".equals(dbType)) {
            sql.append("drop table if exists " + tableDTO.getName() + " ;");
        } else if ("oracle".equals(dbType)) {
            try {
                sql.append("DROP TABLE " + tableDTO.getName());
            }
            catch (Exception exception) {}
        } else if ("mssql".equals(dbType) || "sqlserver".equals(dbType)) {
            sql.append("if exists (select * from sysobjects where id = object_id(N'[" + tableDTO.getName() + "]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)  drop table [" + tableDTO.getName() + "]");
        }
        this.tableService.buildTable(tableDTO, sql.toString());
        this.tableService.removeById(tableDTO.getId());
        ((LambdaUpdateChainWrapper)this.schemaService.lambdaUpdate().eq(Scheme::getTableId, (Object)tableDTO.getId())).remove();
        return ResponseEntity.ok((Object)"\u5220\u9664\u4e1a\u52a1\u8868\u8bb0\u5f55\u548c\u6570\u636e\u5e93\u8868\u6210\u529f!");
    }

    @PreAuthorize(value="hasAuthority('gencode:table:del')")
    @RequestMapping(value={"delete"})
    public ResponseEntity delete(@RequestParam(value="ids") String ids) {
        String[] idArray;
        for (String id : idArray = ids.split(",")) {
            this.tableService.removeById(id);
            ((LambdaUpdateChainWrapper)this.schemaService.lambdaUpdate().eq(Scheme::getTableId, (Object)id)).remove();
        }
        return ResponseEntity.ok((Object)"\u79fb\u9664\u4e1a\u52a1\u8868\u8bb0\u5f55\u6210\u529f!");
    }

    @PreAuthorize(value="hasAuthority('gencode:table:synchDb')")
    @PostMapping(value={"synchDb"})
    public ResponseEntity synchDb(TableDTO genTable, @RequestParam(value="isForce", required=false) String isForce) throws Exception {
        if (this.demoMode) {
            return ResponseEntity.badRequest().body((Object)"\u6f14\u793a\u6a21\u5f0f\uff0c\u7981\u6b62\u64cd\u4f5c\uff01");
        }
        ResponseEntity responseEntity = null;
        genTable = this.tableService.get(genTable);
        String dbType = this.databaseIdProvider.getDatabaseId(this.dynamicRoutingDataSource.getDataSource(genTable.getDataSource().getEnName()));
        List<TableColumnDTO> getTableColumnList = genTable.getColumnList();
        List<TableColumnDTO> getAllTableColumnList = genTable.getAllColumnList();
        if ("postgre".equals(dbType)) {
            if ("1".equals(isForce) && genTable.getOldName() != null) {
                String newName;
                String dbName;
                StringBuffer sql = new StringBuffer();
                if (!genTable.getName().equalsIgnoreCase(genTable.getOldName())) {
                    sql.append("ALTER  TABLE \"" + genTable.getOldName() + "\" RENAME TO \"" + genTable.getName() + "\";");
                    this.tableService.buildTable(genTable, "ALTER  TABLE \"" + genTable.getOldName() + "\" RENAME TO \"" + genTable.getName() + "\";");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldName, (Object)genTable.getName())).update();
                }
                if (!genTable.getComments().equals(genTable.getOldComments())) {
                    sql.append("comment on table  \"" + genTable.getName() + "\" is '" + genTable.getComments() + "';");
                    this.tableService.buildTable(genTable, "comment on table  \"" + genTable.getName() + "\" is '" + genTable.getComments() + "';");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldComments, (Object)genTable.getComments())).update();
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    if (column.getDelFlag() != 1 || !this.existsColumn(genTable, dbName)) continue;
                    sql.append("alter table \"" + genTable.getName() + "\" drop \"" + dbName + "\";");
                    this.tableService.buildTable(genTable, "alter table \"" + genTable.getName() + "\" drop \"" + dbName + "\";");
                    this.tableColumnService.removeById((Serializable)((Object)column.getId()));
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    newName = column.getName();
                    if (column.getDelFlag() == 1 || dbName == null || newName.equals(dbName) && column.getJdbcType().equals(column.getOldJdbcType()) && column.getComments().equals(column.getOldComments())) continue;
                    String oldName = StringUtils.isBlank((CharSequence)column.getOldName()) ? column.getName() : column.getOldName();
                    sql.append("alter table " + genTable.getName() + " change  " + dbName + " " + newName + " " + column.getJdbcType() + " comment '" + column.getComments() + "';");
                    this.tableService.buildTable(genTable, "alter table \"" + genTable.getName() + "\" rename  \"" + oldName + "\" to \"" + column.getName() + "\"; ");
                    this.tableService.buildTable(genTable, "alter table \"" + genTable.getName() + "\" alter column  \"" + column.getName() + "\" type " + column.getJdbcType() + "; ");
                    this.tableService.buildTable(genTable, "COMMENT ON COLUMN \"" + genTable.getName() + "\".\"" + column.getName() + "\"  IS '" + column.getComments() + "';");
                    TableColumn copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                    copyColumn.setOldComments(column.getComments());
                    copyColumn.setOldIsPk(column.getIsPk());
                    copyColumn.setOldJdbcType(column.getJdbcType());
                    copyColumn.setOldName(column.getName());
                    this.tableColumnService.updateById((Object)copyColumn);
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    newName = column.getName();
                    if (column.getDelFlag() == 1 || dbName != null) continue;
                    this.tableService.buildTable(genTable, "alter table \"" + genTable.getName() + "\" add " + column.getName() + " " + column.getJdbcType());
                    this.tableService.buildTable(genTable, "COMMENT ON COLUMN \"" + genTable.getName() + "\".\"" + column.getName() + "\"  IS '" + column.getComments() + "';");
                    TableColumn copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                    copyColumn.setOldComments(column.getComments());
                    copyColumn.setOldIsPk(column.getIsPk());
                    copyColumn.setOldJdbcType(column.getJdbcType());
                    copyColumn.setOldName(column.getName());
                    this.tableColumnService.updateById((Object)copyColumn);
                }
                if (!genTable.getIdType().equals(genTable.getOldIdType())) {
                    if (genTable.getIdType().equals("2")) {
                        this.tableService.buildTable(genTable, "alter table \"" + genTable.getName() + "\" alter column  \"id\" type SERIAL; ");
                    } else {
                        this.tableService.buildTable(genTable, "alter table \"" + genTable.getName() + "\" alter column  \"id\" type varchar(64); ");
                    }
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldIdType, (Object)genTable.getIdType())).update();
                }
                responseEntity = ResponseEntity.ok((Object)"\u540c\u6b65\u6570\u636e\u5e93\u8868\u6210\u529f!");
            } else {
                StringBuffer sql = new StringBuffer();
                if (StringUtils.isNotBlank((CharSequence)genTable.getOldName())) {
                    sql.append("drop table if exists " + genTable.getOldName() + " ;");
                } else {
                    sql.append("drop table if exists " + genTable.getName() + " ;");
                }
                this.tableService.buildTable(genTable, sql.toString());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldName, (Object)genTable.getName())).update();
                sql = new StringBuffer();
                StringBuffer sqlComments = new StringBuffer();
                sql.append("create table \"" + genTable.getName() + "\" (");
                for (TableColumnDTO column : getAllTableColumnList) {
                    if (column.getDelFlag() == 1 || column.getName() == null) continue;
                    String jdbctype = column.getJdbcType();
                    if (jdbctype.equalsIgnoreCase("integer")) {
                        jdbctype = "int4";
                    } else if (jdbctype.equalsIgnoreCase("long")) {
                        jdbctype = "int8";
                    } else if (jdbctype.equalsIgnoreCase("datetime")) {
                        jdbctype = "timestamp(6)";
                    } else if (jdbctype.contains("nvarchar(")) {
                        jdbctype = jdbctype.replace("nvarchar", "varchar");
                    } else if (jdbctype.equalsIgnoreCase("double")) {
                        jdbctype = "float8";
                    } else if (jdbctype.equalsIgnoreCase("longblob")) {
                        jdbctype = "bytea";
                    } else if (jdbctype.equalsIgnoreCase("longtext")) {
                        jdbctype = "text";
                    }
                    if (column.getIsPk().equals("1")) {
                        if (genTable.getIdType().equals("2")) {
                            sql.append("  \"" + column.getName() + "\"  serial PRIMARY KEY ,");
                        } else {
                            String jdbcType = column.getJdbcType();
                            if (!jdbcType.toLowerCase().contains("varchar")) {
                                jdbcType = "varchar(64)";
                                column.setJdbcType(jdbcType);
                            }
                            sql.append("  \"" + column.getName() + "\" " + jdbcType + " PRIMARY KEY,");
                        }
                        sqlComments.append("COMMENT ON COLUMN \"" + genTable.getName() + "\".\"" + column.getName() + "\"  IS '" + column.getComments() + "';");
                        continue;
                    }
                    sql.append("  \"" + column.getName() + "\" " + jdbctype + ",");
                    sqlComments.append("COMMENT ON COLUMN \"" + genTable.getName() + "\".\"" + column.getName() + "\"  IS '" + column.getComments() + "';");
                }
                sql = new StringBuffer(sql.substring(0, sql.toString().length() - 1));
                sql.append(");");
                sql.append("COMMENT ON TABLE \"" + genTable.getName() + "\"  IS '" + genTable.getComments() + "';");
                sql.append(sqlComments);
                this.tableService.buildTable(genTable, sql.toString());
                responseEntity = ResponseEntity.ok((Object)"\u91cd\u65b0\u5efa\u8868\u6210\u529f!");
            }
        } else if ("mysql".equals(dbType)) {
            if ("1".equals(isForce) && genTable.getOldName() != null) {
                TableColumn copyColumn;
                String newName;
                String dbName;
                StringBuffer sql = new StringBuffer();
                if (!genTable.getName().equalsIgnoreCase(genTable.getOldName())) {
                    sql.append("ALTER  TABLE " + genTable.getOldName() + " RENAME TO " + genTable.getName() + ";");
                    this.tableService.buildTable(genTable, "ALTER  TABLE " + genTable.getOldName() + " RENAME TO " + genTable.getName() + ";");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldName, (Object)genTable.getName())).update();
                }
                if (!genTable.getComments().equals(genTable.getOldComments())) {
                    sql.append("alter table " + genTable.getName() + " comment '" + genTable.getComments() + "';");
                    this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " comment '" + genTable.getComments() + "';");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldIdType, (Object)genTable.getIdType())).set(Table::getOldComments, (Object)genTable.getComments())).update();
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    if (column.getDelFlag() != 1 || !this.existsColumn(genTable, dbName)) continue;
                    sql.append("alter table " + genTable.getName() + " drop " + dbName + ";");
                    this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " drop " + dbName + ";");
                    this.tableColumnService.removeById((Serializable)((Object)column.getId()));
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    newName = column.getName();
                    if (column.getDelFlag() == 1 || dbName == null || newName.equals(dbName) && column.getJdbcType().equals(column.getOldJdbcType()) && column.getComments().equals(column.getOldComments())) continue;
                    String oldName = StringUtils.isBlank((CharSequence)column.getOldName()) ? column.getName() : column.getOldName();
                    sql.append("alter table " + genTable.getName() + " change  " + dbName + " " + newName + " " + column.getJdbcType() + " comment '" + column.getComments() + "';");
                    this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " change  " + oldName + " " + column.getName() + " " + column.getJdbcType() + " comment '" + column.getComments() + "';");
                    TableColumn copyColumn2 = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                    copyColumn2.setOldComments(column.getComments());
                    copyColumn2.setOldIsPk(column.getIsPk());
                    copyColumn2.setOldJdbcType(column.getJdbcType());
                    copyColumn2.setOldName(column.getName());
                    this.tableColumnService.updateById((Object)copyColumn2);
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    newName = column.getName();
                    if (column.getDelFlag() == 1 || dbName != null) continue;
                    sql.append("alter table " + genTable.getName() + " add " + newName + " " + column.getJdbcType() + " comment '" + column.getComments() + "';");
                    this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " add " + column.getName() + " " + column.getJdbcType() + " comment '" + column.getComments() + "';");
                    copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                    copyColumn.setOldComments(column.getComments());
                    copyColumn.setOldIsPk(column.getIsPk());
                    copyColumn.setOldJdbcType(column.getJdbcType());
                    copyColumn.setOldName(column.getName());
                    this.tableColumnService.updateById((Object)copyColumn);
                }
                if (genTable.getIdType() != null && !genTable.getIdType().equals(genTable.getOldIdType())) {
                    for (TableColumnDTO column : getAllTableColumnList) {
                        TableColumn copyColumn3;
                        Object jdbcType;
                        if (column.getDelFlag() == 1 || column.getName() == null || !column.getIsPk().equals("1")) continue;
                        if (genTable.getIdType().equals("2")) {
                            jdbcType = column.getJdbcType();
                            if (!((String)jdbcType).toLowerCase().contains("int") && !((String)jdbcType).toLowerCase().contains("integer")) {
                                jdbcType = "integer";
                                column.setJdbcType((String)jdbcType);
                                copyColumn3 = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                                copyColumn3.setJdbcType((String)jdbcType);
                                copyColumn3.setOldJdbcType((String)jdbcType);
                                this.tableColumnService.updateById((Object)copyColumn3);
                            }
                            this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " change   " + column.getName() + " " + column.getName() + " " + (String)jdbcType + " auto_increment ;");
                            continue;
                        }
                        jdbcType = column.getJdbcType();
                        if (!((String)jdbcType).toLowerCase().contains("varchar")) {
                            jdbcType = "varchar(64)";
                            column.setJdbcType((String)jdbcType);
                            copyColumn3 = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                            copyColumn3.setJdbcType((String)jdbcType);
                            copyColumn3.setOldJdbcType((String)jdbcType);
                            this.tableColumnService.updateById((Object)copyColumn3);
                        }
                        this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " change   " + column.getName() + " " + column.getName() + " " + (String)jdbcType + " ;");
                    }
                }
                Object pk = "";
                Object oldPk = "";
                for (TableColumnDTO column : getTableColumnList) {
                    if (column.getIsPk().equals("1")) {
                        pk = (String)pk + column.getName() + ",";
                    }
                    if (!"1".equals(column.getOldIsPk())) continue;
                    oldPk = (String)oldPk + column.getName() + ",";
                }
                if (!((String)oldPk).equals(pk)) {
                    sql.append("alter table " + genTable.getName() + " drop primary key;");
                    this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " drop primary key;");
                    for (TableColumnDTO column : getTableColumnList) {
                        if (!"1".equals(column.getOldIsPk())) continue;
                        copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                        copyColumn.setOldIsPk("0");
                        this.tableColumnService.updateById((Object)copyColumn);
                    }
                    if (((String)pk).length() > 0) {
                        sql.append("alter table " + genTable.getName() + " add  CONSTRAINT PK_SJ_RESOURCE_CHARGES PRIMARY KEY(" + ((String)pk).substring(0, ((String)pk).length() - 1) + ");");
                        this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " add  CONSTRAINT PK_SJ_RESOURCE_CHARGES PRIMARY KEY(" + ((String)pk).substring(0, ((String)pk).length() - 1) + ");");
                        for (TableColumnDTO column : getTableColumnList) {
                            if (!"1".equals(column.getIsPk())) continue;
                            copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                            copyColumn.setOldIsPk("1");
                            this.tableColumnService.updateById((Object)copyColumn);
                        }
                    }
                }
                responseEntity = ResponseEntity.ok((Object)"\u540c\u6b65\u6570\u636e\u5e93\u8868\u6210\u529f!");
            } else {
                StringBuffer sql = new StringBuffer();
                if (StringUtils.isNotBlank((CharSequence)genTable.getOldName())) {
                    sql.append("drop table if exists " + genTable.getOldName() + " ;");
                } else {
                    sql.append("drop table if exists " + genTable.getName() + " ;");
                }
                this.tableService.buildTable(genTable, sql.toString());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldName, (Object)genTable.getName())).update();
                sql = new StringBuffer();
                sql.append("create table " + genTable.getName() + " (");
                Object pk = "";
                for (TableColumnDTO column : getAllTableColumnList) {
                    if (column.getDelFlag() == 1 || column.getName() == null) continue;
                    if (column.getIsPk().equals("1")) {
                        if (genTable.getIdType().equals("2")) {
                            jdbcType = column.getJdbcType();
                            if (!jdbcType.toLowerCase().contains("int") && !jdbcType.toLowerCase().contains("integer")) {
                                jdbcType = "integer";
                                column.setJdbcType(jdbcType);
                            }
                            sql.append("  " + column.getName() + " " + jdbcType + " auto_increment  comment '" + column.getComments() + "',");
                        } else {
                            jdbcType = column.getJdbcType();
                            if (!jdbcType.toLowerCase().contains("varchar")) {
                                jdbcType = "varchar(64)";
                                column.setJdbcType(jdbcType);
                            }
                            sql.append("  " + column.getName() + " " + jdbcType + " comment '" + column.getComments() + "',");
                        }
                        pk = (String)pk + column.getName() + ",";
                        continue;
                    }
                    sql.append("  " + column.getName() + " " + column.getJdbcType() + " comment '" + column.getComments() + "',");
                }
                sql.append("primary key (" + ((String)pk).substring(0, ((String)pk).length() - 1) + ") ");
                sql.append(") comment '" + genTable.getComments() + "' DEFAULT CHARSET=utf8");
                this.tableService.buildTable(genTable, sql.toString());
                responseEntity = ResponseEntity.ok((Object)"\u91cd\u65b0\u5efa\u8868\u6210\u529f!");
            }
        } else if ("oracle".equals(dbType)) {
            if ("1".equals(isForce) && genTable.getOldName() != null) {
                TableColumn copyColumn;
                String newName;
                String dbName;
                StringBuffer sql = new StringBuffer();
                if (!genTable.getName().equalsIgnoreCase(genTable.getOldName())) {
                    sql.append("ALTER  TABLE " + genTable.getOldName() + " RENAME TO " + genTable.getName());
                    this.tableService.buildTable(genTable, "ALTER  TABLE " + genTable.getOldName() + " RENAME TO " + genTable.getName());
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldName, (Object)genTable.getName())).update();
                }
                if (!genTable.getComments().equals(genTable.getOldComments())) {
                    sql.append("alter table " + genTable.getName() + " comment '" + genTable.getComments() + "';");
                    this.tableService.buildTable(genTable, "comment on table " + genTable.getName() + " is '" + genTable.getComments() + "'");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldIdType, (Object)genTable.getIdType())).set(Table::getOldComments, (Object)genTable.getComments())).update();
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    if (column.getDelFlag() != 1 || !this.existsColumn(genTable, dbName)) continue;
                    sql.append("alter table " + genTable.getName() + " drop column " + dbName);
                    this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " drop column " + dbName);
                    this.tableColumnService.removeById((Serializable)((Object)column.getId()));
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    newName = column.getName();
                    if (column.getDelFlag() == 1 || dbName == null || newName.equals(dbName) && column.getJdbcType().equals(column.getOldJdbcType()) && column.getComments().equals(column.getOldComments())) continue;
                    String oldName = StringUtils.isBlank((CharSequence)column.getOldName()) ? column.getName() : column.getOldName();
                    sql.append("alter table " + genTable.getName() + " modify  " + dbName + " " + newName + " " + column.getJdbcType() + " comment '" + column.getComments() + "';");
                    if (!newName.equals(dbName)) {
                        this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " rename  column " + oldName + " to " + column.getName());
                    }
                    if (!column.getJdbcType().equals(column.getOldJdbcType())) {
                        this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " modify   " + column.getName() + " " + column.getJdbcType());
                    }
                    if (!column.getComments().equals(column.getOldComments())) {
                        this.tableService.buildTable(genTable, "comment on column " + genTable.getName() + "." + column.getName() + " is '" + column.getComments() + "'");
                    }
                    TableColumn copyColumn4 = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                    copyColumn4.setOldComments(column.getComments());
                    copyColumn4.setOldIsPk(column.getIsPk());
                    copyColumn4.setOldJdbcType(column.getJdbcType());
                    copyColumn4.setOldName(column.getName());
                    this.tableColumnService.updateById((Object)copyColumn4);
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    newName = column.getName();
                    if (column.getDelFlag() == 1 || dbName != null) continue;
                    sql.append("alter table " + genTable.getName() + " add " + newName + " " + column.getJdbcType() + " comment '" + column.getComments() + "';");
                    this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " add " + column.getName() + " " + column.getJdbcType());
                    this.tableService.buildTable(genTable, "comment on column " + genTable.getName() + "." + column.getName() + " is '" + column.getComments() + "'");
                    copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                    copyColumn.setOldComments(column.getComments());
                    copyColumn.setOldIsPk(column.getIsPk());
                    copyColumn.setOldJdbcType(column.getJdbcType());
                    copyColumn.setOldName(column.getName());
                    this.tableColumnService.updateById((Object)copyColumn);
                }
                if (genTable.getIdType() != null && !genTable.getIdType().equals(genTable.getOldIdType())) {
                    for (TableColumnDTO column : getAllTableColumnList) {
                        TableColumn copyColumn5;
                        Object jdbcType;
                        if (column.getDelFlag() == 1 || column.getName() == null || !column.getIsPk().equals("1")) continue;
                        if (genTable.getIdType().equals("2")) {
                            jdbcType = column.getJdbcType();
                            if (((String)jdbcType).toLowerCase().contains("number")) continue;
                            jdbcType = "number";
                            column.setJdbcType((String)jdbcType);
                            copyColumn5 = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                            copyColumn5.setJdbcType((String)jdbcType);
                            copyColumn5.setOldJdbcType((String)jdbcType);
                            this.tableColumnService.updateById((Object)copyColumn5);
                            this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " modify   " + column.getName() + " " + (String)jdbcType);
                            continue;
                        }
                        jdbcType = column.getJdbcType();
                        if (((String)jdbcType).toLowerCase().contains("varchar2")) continue;
                        jdbcType = "varchar2(64)";
                        column.setJdbcType((String)jdbcType);
                        copyColumn5 = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                        copyColumn5.setJdbcType((String)jdbcType);
                        copyColumn5.setOldJdbcType((String)jdbcType);
                        this.tableColumnService.updateById((Object)copyColumn5);
                        this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " modify   " + column.getName() + " " + (String)jdbcType);
                    }
                }
                Object oldPk = "";
                Object pk2 = "";
                for (TableColumnDTO column : getTableColumnList) {
                    if (column.getIsPk().equals("1")) {
                        pk2 = (String)pk2 + column.getName() + ",";
                    }
                    if (!"1".equals(column.getOldIsPk())) continue;
                    oldPk = (String)oldPk + column.getName() + ",";
                }
                if (!((String)oldPk).equals(pk2)) {
                    sql.append("alter table " + genTable.getName() + " drop primary key;");
                    this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " drop constraint PK_" + genTable.getName() + "_" + ((String)oldPk).substring(0, ((String)oldPk).length() - 1));
                    for (TableColumnDTO column : getTableColumnList) {
                        if (!"1".equals(column.getOldIsPk())) continue;
                        copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                        copyColumn.setOldIsPk("0");
                        this.tableColumnService.updateById((Object)copyColumn);
                    }
                    if (((String)pk2).length() > 0) {
                        sql.append("alter table " + genTable.getName() + " add  CONSTRAINT PK_SJ_RESOURCE_CHARGES PRIMARY KEY(" + ((String)pk2).substring(0, ((String)pk2).length() - 1) + ");");
                        this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " add constraint PK_" + genTable.getName() + "_" + ((String)pk2).substring(0, ((String)pk2).length() - 1) + " primary key (" + ((String)pk2).substring(0, ((String)pk2).length() - 1) + ") ");
                        if (genTable.getIdType().equals("2")) {
                            try {
                                this.tableService.buildTable(genTable, "CREATE SEQUENCE " + genTable.getName() + "_sequence INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE");
                                this.tableService.buildTable(genTable, "create trigger " + genTable.getName() + "_trig before insert on " + genTable.getName() + " for each row when (new." + (String)pk2 + " is null) begin select " + genTable.getName() + "_sequence.nextval into:new." + (String)pk2 + " from dual; end;");
                            }
                            catch (Exception jdbcType) {
                                // empty catch block
                            }
                        }
                        for (TableColumnDTO column : getTableColumnList) {
                            if (!"1".equals(column.getIsPk())) continue;
                            copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                            copyColumn.setOldIsPk("1");
                            this.tableColumnService.updateById((Object)copyColumn);
                        }
                    }
                }
                responseEntity = ResponseEntity.ok((Object)"\u540c\u6b65\u6570\u636e\u5e93\u8868\u6210\u529f!");
            } else {
                StringBuffer sql = new StringBuffer();
                try {
                    if (StringUtils.isNotBlank((CharSequence)genTable.getOldName())) {
                        sql.append("DROP TABLE " + genTable.getOldName());
                    } else {
                        sql.append("DROP TABLE " + genTable.getName());
                    }
                    this.tableService.buildTable(genTable, sql.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldName, (Object)genTable.getName())).update();
                sql = new StringBuffer();
                sql.append("create table " + genTable.getName() + " (");
                Object pk = "";
                for (TableColumnDTO column : getAllTableColumnList) {
                    if (column.getDelFlag() == 1 || column.getName() == null) continue;
                    String jdbctype = column.getJdbcType();
                    if (jdbctype.equalsIgnoreCase("integer")) {
                        jdbctype = "number(10,0)";
                    } else if (jdbctype.equalsIgnoreCase("datetime")) {
                        jdbctype = "date";
                    } else if (jdbctype.contains("nvarchar(")) {
                        jdbctype = jdbctype.replace("nvarchar", "nvarchar2");
                    } else if (jdbctype.contains("varchar(")) {
                        jdbctype = jdbctype.replace("varchar", "varchar2");
                    } else if (jdbctype.equalsIgnoreCase("double")) {
                        jdbctype = "float(24)";
                    } else if (jdbctype.equalsIgnoreCase("longblob")) {
                        jdbctype = "blob";
                    } else if (jdbctype.equalsIgnoreCase("longtext")) {
                        jdbctype = "clob";
                    }
                    if (column.getIsPk().equals("1")) {
                        if (genTable.getIdType().equals("2")) {
                            String jdbcType = column.getJdbcType();
                            if (!jdbcType.toLowerCase().contains("int") && !jdbcType.toLowerCase().contains("integer")) {
                                jdbcType = "number";
                                column.setJdbcType(jdbcType);
                            }
                            sql.append("  " + column.getName() + " " + jdbcType + ",");
                        } else {
                            sql.append("  " + column.getName() + " " + jdbctype + ",");
                        }
                        pk = (String)pk + column.getName();
                        continue;
                    }
                    sql.append("  " + column.getName() + " " + jdbctype + ",");
                }
                sql = new StringBuffer(sql.substring(0, sql.length() - 1) + ")");
                this.tableService.buildTable(genTable, sql.toString());
                this.tableService.buildTable(genTable, "comment on table " + genTable.getName() + " is  '" + genTable.getComments() + "'");
                for (TableColumnDTO column : getTableColumnList) {
                    this.tableService.buildTable(genTable, "comment on column " + genTable.getName() + "." + column.getName() + " is  '" + column.getComments() + "'");
                }
                this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " add constraint PK_" + genTable.getName() + "_" + (String)pk + " primary key (" + (String)pk + ") ");
                if (genTable.getIdType().equals("2")) {
                    try {
                        this.tableService.buildTable(genTable, "CREATE SEQUENCE " + genTable.getName() + "_sequence INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE");
                        this.tableService.buildTable(genTable, "create trigger " + genTable.getName() + "_trig before insert on " + genTable.getName() + " for each row when (new." + (String)pk + " is null) begin select " + genTable.getName() + "_sequence.nextval into:new." + (String)pk + " from dual; end;");
                    }
                    catch (Exception pk2) {
                        // empty catch block
                    }
                }
                responseEntity = ResponseEntity.ok((Object)"\u91cd\u65b0\u5efa\u8868\u6210\u529f!");
            }
        } else if ("mssql".equals(dbType) || "sqlserver".equals(dbType)) {
            if ("1".equals(isForce) && genTable.getOldName() != null) {
                TableColumn copyColumn;
                String newName;
                String dbName;
                StringBuffer sql = new StringBuffer();
                if (!genTable.getName().equalsIgnoreCase(genTable.getOldName())) {
                    sql.append("EXEC   sp_rename   '" + genTable.getOldName() + "',   '" + genTable.getName() + "' ");
                    this.tableService.buildTable(genTable, "EXEC   sp_rename   '" + genTable.getOldName() + "',   '" + genTable.getName() + "' ");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldName, (Object)genTable.getName())).update();
                }
                if (!genTable.getComments().equals(genTable.getOldComments())) {
                    sql.append("alter table " + genTable.getName() + " comment '" + genTable.getComments() + "';");
                    this.tableService.buildTable(genTable, "if not exists (SELECT  A.name,        C.value  FROM sys.tables A  inner JOIN sys.extended_properties C ON C.major_id = A.object_id  and minor_id=0  WHERE A.name = N'" + genTable.getName() + "')  EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'" + genTable.getComments() + "' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'" + genTable.getName() + "' EXEC sp_updateextendedproperty @name=N'MS_Description', @value=N'" + genTable.getComments() + "' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'" + genTable.getName() + "'");
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldIdType, (Object)genTable.getIdType())).set(Table::getOldComments, (Object)genTable.getComments())).update();
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    String columnOldName = column.getOldName();
                    if (column.getDelFlag() != 1 || !this.existsColumn(genTable, columnOldName)) continue;
                    sql.append("alter table " + genTable.getName() + " drop COLUMN " + columnOldName + ";");
                    this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " drop column " + columnOldName + ";");
                    this.tableColumnService.removeById((Serializable)((Object)column.getId()));
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    newName = column.getName();
                    if (column.getDelFlag() == 1 || dbName == null || newName.equals(dbName) && column.getJdbcType().equals(column.getOldJdbcType()) && column.getComments().equals(column.getOldComments())) continue;
                    String oldName = StringUtils.isBlank((CharSequence)column.getOldName()) ? column.getName() : column.getOldName();
                    TableColumn copyColumn6 = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                    if (!newName.equals(dbName)) {
                        this.tableService.buildTable(genTable, "EXEC sp_rename '" + genTable.getName() + ".[" + oldName + "]', '" + column.getName() + "', 'COLUMN';");
                        copyColumn6.setOldName(column.getName());
                        this.tableColumnService.updateById((Object)copyColumn6);
                    }
                    if (!column.getJdbcType().equals(column.getOldJdbcType())) {
                        this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " alter  column " + column.getName() + " " + column.getJdbcType() + ";");
                        copyColumn6.setOldName(column.getJdbcType());
                        this.tableColumnService.updateById((Object)copyColumn6);
                    }
                    if (column.getComments().equals(column.getOldComments())) continue;
                    this.tableService.buildTable(genTable, "if not exists (SELECT C.value AS column_description FROM sys.tables A INNER JOIN sys.columns B ON B.object_id = A.object_id INNER JOIN sys.extended_properties C ON C.major_id = B.object_id AND C.minor_id = B.column_id WHERE A.name = N'" + genTable.getName() + "' and B.name=N'" + column.getName() + "') EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'" + column.getComments() + "' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'" + genTable.getName() + "', @level2type=N'COLUMN',@level2name=N'" + column.getName() + "' EXEC sp_updateextendedproperty @name=N'MS_Description', @value=N'" + column.getComments() + "' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'" + genTable.getName() + "', @level2type=N'COLUMN',@level2name=N'" + column.getName() + "'");
                    copyColumn6.setOldName(column.getComments());
                    this.tableColumnService.updateById((Object)copyColumn6);
                }
                for (TableColumnDTO column : getAllTableColumnList) {
                    dbName = column.getOldName();
                    newName = column.getName();
                    if (column.getDelFlag() == 1 || dbName != null) continue;
                    sql.append("alter table " + genTable.getName() + " add " + newName + " " + column.getJdbcType() + "';");
                    this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " add " + column.getName() + " " + column.getJdbcType() + ";");
                    this.tableService.buildTable(genTable, "if not exists (SELECT C.value AS column_description FROM sys.tables A INNER JOIN sys.columns B ON B.object_id = A.object_id INNER JOIN sys.extended_properties C ON C.major_id = B.object_id AND C.minor_id = B.column_id WHERE A.name = N'" + genTable.getName() + "' and B.name=N'" + column.getName() + "') EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'" + column.getComments() + "' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'" + genTable.getName() + "', @level2type=N'COLUMN',@level2name=N'" + column.getName() + "' EXEC sp_updateextendedproperty @name=N'MS_Description', @value=N'" + column.getComments() + "' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'" + genTable.getName() + "', @level2type=N'COLUMN',@level2name=N'" + column.getName() + "'");
                    copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                    copyColumn.setOldComments(column.getComments());
                    copyColumn.setOldIsPk(column.getIsPk());
                    copyColumn.setOldJdbcType(column.getJdbcType());
                    copyColumn.setOldName(column.getName());
                    this.tableColumnService.updateById((Object)copyColumn);
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tableService.lambdaUpdate().eq(BaseEntity::getId, (Object)genTable.getId())).set(Table::getOldName, (Object)genTable.getName())).update();
                }
                if (genTable.getIdType() != null && !genTable.getIdType().equals(genTable.getOldIdType())) {
                    for (TableColumnDTO column : getAllTableColumnList) {
                        TableColumn copyColumn7;
                        String jdbcType;
                        if (column.getDelFlag() == 1 || column.getName() == null || !column.getIsPk().equals("1")) continue;
                        if (genTable.getIdType().equals("2")) {
                            jdbcType = column.getJdbcType();
                            if (!jdbcType.toLowerCase().contains("int") && !jdbcType.toLowerCase().contains("integer")) {
                                jdbcType = "int";
                                column.setJdbcType(jdbcType);
                                copyColumn7 = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                                copyColumn7.setJdbcType(jdbcType);
                                copyColumn7.setOldJdbcType(jdbcType);
                                this.tableColumnService.updateById((Object)copyColumn7);
                            }
                            this.tableService.buildTable(genTable, "Declare @Pk varChar(100) Select @Pk=Name from sysobjects where Parent_Obj=OBJECT_ID('" + genTable.getName() + "') and xtype='PK'  if @Pk is not null exec('Alter table " + genTable.getName() + " Drop '+ @Pk) ");
                            this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " alter   column " + column.getName() + " " + jdbcType + "  not null;");
                            this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " add   constraint pkid primary key(" + column.getName() + ") ;");
                            continue;
                        }
                        jdbcType = column.getJdbcType();
                        if (!jdbcType.toLowerCase().contains("varchar")) {
                            jdbcType = "varchar(64)";
                            column.setJdbcType(jdbcType);
                            copyColumn7 = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                            copyColumn7.setJdbcType(jdbcType);
                            copyColumn7.setOldJdbcType(jdbcType);
                            this.tableColumnService.updateById((Object)copyColumn7);
                        }
                        this.tableService.buildTable(genTable, "Declare @Pk varChar(100) Select @Pk=Name from sysobjects where Parent_Obj=OBJECT_ID('" + genTable.getName() + "') and xtype='PK'  if @Pk is not null  exec('Alter table " + genTable.getName() + " Drop '+ @Pk) ");
                        this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " alter column   " + column.getName() + " " + jdbcType + " not null ;");
                        this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " add   constraint pkid primary key(" + column.getName() + ") ;");
                    }
                }
                Object pk = "";
                Object oldPk = "";
                for (TableColumnDTO column : getTableColumnList) {
                    if (column.getIsPk().equals("1")) {
                        pk = pk + column.getName() + ",";
                    }
                    if (!"1".equals(column.getOldIsPk())) continue;
                    oldPk = (String)oldPk + column.getName() + ",";
                }
                if (!((String)oldPk).equals(pk)) {
                    this.tableService.buildTable(genTable, "Declare @Pk varChar(100) Select @Pk=Name from sysobjects where Parent_Obj=OBJECT_ID('" + genTable.getName() + "') and xtype='PK'  if @Pk is not null  exec('Alter table " + genTable.getName() + " Drop '+ @Pk) ");
                    for (TableColumnDTO column : getTableColumnList) {
                        if (!"1".equals(column.getOldIsPk())) continue;
                        copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                        copyColumn.setOldIsPk("0");
                        this.tableColumnService.updateById((Object)copyColumn);
                    }
                    if (((String)pk).length() > 0) {
                        this.tableService.buildTable(genTable, "alter table " + genTable.getName() + " add   constraint pkid primary key(" + ((String)pk).substring(0, ((String)pk).length() - 1) + ") ;");
                        for (TableColumnDTO column : getTableColumnList) {
                            if (!"1".equals(column.getIsPk())) continue;
                            copyColumn = (TableColumn)((Object)this.tableColumnService.getById((Serializable)((Object)column.getId())));
                            copyColumn.setOldIsPk("1");
                            this.tableColumnService.updateById((Object)copyColumn);
                        }
                    }
                }
                responseEntity = ResponseEntity.ok((Object)"\u540c\u6b65\u6570\u636e\u5e93\u8868\u6210\u529f!");
            } else {
                StringBuffer sql = new StringBuffer();
                sql.append("if exists (select * from sysobjects where id = object_id(N'[" + genTable.getName() + "]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)  drop table [" + genTable.getName() + "]");
                this.tableService.buildTable(genTable, sql.toString());
                sql = new StringBuffer();
                sql.append("create table " + genTable.getName() + " (");
                for (TableColumnDTO column : getTableColumnList) {
                    if (column.getIsPk().equals("1")) {
                        if (genTable.getIdType().equals("2")) {
                            sql.append(column.getName() + " int identity(1,1) primary key ,");
                            continue;
                        }
                        sql.append(column.getName() + " varchar(64) primary key,");
                        continue;
                    }
                    sql.append("  " + column.getName() + " " + column.getJdbcType() + ",");
                }
                this.tableService.buildTable(genTable, sql.substring(0, sql.toString().length() - 1) + ")");
                this.tableService.buildTable(genTable, "if not exists (SELECT  A.name,        C.value  FROM sys.tables A  inner JOIN sys.extended_properties C ON C.major_id = A.object_id  and minor_id=0  WHERE A.name = N'" + genTable.getName() + "')  EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'" + genTable.getComments() + "' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'" + genTable.getName() + "' EXEC sp_updateextendedproperty @name=N'MS_Description', @value=N'" + genTable.getComments() + "' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'" + genTable.getName() + "'");
                for (TableColumnDTO column : getTableColumnList) {
                    this.tableService.buildTable(genTable, "if not exists (SELECT C.value AS column_description FROM sys.tables A INNER JOIN sys.columns B ON B.object_id = A.object_id INNER JOIN sys.extended_properties C ON C.major_id = B.object_id AND C.minor_id = B.column_id WHERE A.name = N'" + genTable.getName() + "' and B.name=N'" + column.getName() + "') EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'" + column.getComments() + "' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'" + genTable.getName() + "', @level2type=N'COLUMN',@level2name=N'" + column.getName() + "' EXEC sp_updateextendedproperty @name=N'MS_Description', @value=N'" + column.getComments() + "' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'" + genTable.getName() + "', @level2type=N'COLUMN',@level2name=N'" + column.getName() + "'");
                }
                responseEntity = ResponseEntity.ok((Object)"\u91cd\u65b0\u5efa\u8868\u6210\u529f!");
            }
        }
        this.tableService.syncSave(genTable);
        return responseEntity;
    }

    private boolean existsColumn(TableDTO tableDTO, String columnName) {
        List<TableColumnDTO> dbColumnList = this.dataBaseDictMapper.findTableColumnList(tableDTO);
        for (TableColumnDTO column : dbColumnList) {
            if (columnName == null || !columnName.equals(column.getName())) continue;
            return true;
        }
        return false;
    }

    @GetMapping(value={"queryGenCodeForm"})
    public ResponseEntity queryGenCodeForm(Scheme scheme) throws Exception {
        if (this.enabled) {
            scheme.setPackageName(this.packageName);
            scheme.setProjectPath(this.projectPath);
            scheme.setFrontProjectPath(this.frontPath);
            scheme.setFunctionAuthor(this.author);
        } else {
            CodeParam codeParam = (CodeParam)((Object)this.codeParamService.getById((Serializable)((Object)"1")));
            if (codeParam != null) {
                scheme.setPackageName(codeParam.getPackageName());
                scheme.setProjectPath(codeParam.getProjectPath());
                scheme.setFrontProjectPath(codeParam.getFrontPath());
                scheme.setFunctionAuthor(codeParam.getAuthor());
            }
        }
        Scheme oldGenScheme = (Scheme)((Object)((LambdaQueryChainWrapper)this.schemaService.lambdaQuery().eq(Scheme::getTableId, (Object)scheme.getTableId())).one());
        if (oldGenScheme != null) {
            scheme = oldGenScheme;
        }
        List genCodeTemplateGroupList = ((LambdaQueryChainWrapper)this.templateGroupService.lambdaQuery().orderByAsc(TemplateGroup::getSort)).list();
        return ResponseUtil.newInstance().add("scheme", (Object)scheme).add("templateGroupList", (Object)genCodeTemplateGroupList).add("tableList", this.tableService.findList(new TableDTO())).ok();
    }

    @PostMapping(value={"genCode"})
    public ResponseEntity genCode(@RequestBody SchemeDTO schemeDTO) throws Exception {
        String result = "";
        result = this.schemaService.saveOrUpdate(schemeDTO);
        return ResponseEntity.ok((Object)(schemeDTO.getTable().getName() + "\u4ee3\u7801\u751f\u6210\u6210\u529f<br/>" + result));
    }

    @GetMapping(value={"getFormUrl"})
    public ResponseEntity getFormUrl(@RequestParam(value="tableId", required=false) String tableId) {
        Scheme scheme = (Scheme)((Object)((LambdaQueryChainWrapper)this.schemaService.lambdaQuery().eq(Scheme::getTableId, (Object)tableId)).one());
        if (scheme == null) {
            return ResponseEntity.badRequest().body((Object)"\u83b7\u53d6\u8868\u5355\u5730\u5740\u5931\u8d25,\u8bf7\u5148\u751f\u6210\u4ee3\u7801!");
        }
        TableDTO tableDTO = this.tableService.getById(tableId);
        String classname = tableDTO.getClassName();
        String url = "/" + scheme.getModuleName() + (String)(StringUtils.isNotBlank((CharSequence)scheme.getSubModuleName()) ? "/" + StringUtils.lowerCase((String)scheme.getSubModuleName()) : "") + "/" + classname + "Form";
        url = "\u8868\u5355\u5730\u5740:" + url;
        return ResponseEntity.ok((Object)url);
    }
}

