/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jeeplus.core.query.QueryWrapperGenerator;
import com.jeeplus.devtools.domain.ValidateType;
import com.jeeplus.devtools.service.ValidateTypeService;
import com.jeeplus.devtools.service.dto.ValidateTypeDTO;
import com.jeeplus.devtools.service.mapstruct.ValidateTypeWrapper;
import jakarta.validation.Valid;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/devtools/validateType"})
public class ValidateTypeController {
    @Autowired
    private ValidateTypeService validateTypeService;

    @PreAuthorize(value="hasAuthority('gencode:validateType:list')")
    @GetMapping(value={"list"})
    public ResponseEntity<IPage<ValidateType>> list(ValidateType validateType, Page<ValidateType> page) throws Exception {
        QueryWrapper queryWrapper = QueryWrapperGenerator.buildQueryCondition((Object)((Object)validateType), ValidateType.class);
        if (page.orders().size() == 0) {
            queryWrapper.orderByAsc((Object)"sort");
        }
        IPage result = this.validateTypeService.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"queryById"})
    public ResponseEntity queryById(@RequestParam(value="id") String id) {
        ValidateType validateType = (ValidateType)((Object)this.validateTypeService.getById((Serializable)((Object)id)));
        return ResponseEntity.ok((Object)((Object)validateType));
    }

    @PostMapping(value={"save"})
    public ResponseEntity save(@Valid @RequestBody ValidateTypeDTO validateTypeDTO) throws Exception {
        ValidateType validateType = (ValidateType)((Object)ValidateTypeWrapper.INSTANCE.toEntity((Object)validateTypeDTO));
        this.validateTypeService.saveOrUpdate((Object)validateType);
        return ResponseEntity.ok((Object)"\u4fdd\u5b58\u9a8c\u8bc1\u7c7b\u578b\u6210\u529f");
    }

    @DeleteMapping(value={"delete"})
    public ResponseEntity delete(@RequestParam(value="ids") String ids) {
        Object[] idArray = ids.split(",");
        this.validateTypeService.removeByIds(Lists.newArrayList((Object[])idArray));
        return ResponseEntity.ok((Object)"\u5220\u9664\u9a8c\u8bc1\u7c7b\u578b\u6210\u529f");
    }
}

