/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.service;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.devtools.domain.CustomField;
import com.jeeplus.devtools.domain.CustomObj;
import com.jeeplus.devtools.mapper.CustomObjMapper;
import com.jeeplus.devtools.service.CustomFieldService;
import com.jeeplus.devtools.service.dto.CustomFieldDTO;
import com.jeeplus.devtools.service.dto.CustomObjDTO;
import com.jeeplus.devtools.service.mapstruct.CustomFieldWrapper;
import com.jeeplus.devtools.service.mapstruct.CustomObjWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CustomObjService
extends ServiceImpl<CustomObjMapper, CustomObj> {
    @Autowired
    private CustomFieldService customFieldService;

    public CustomObjDTO getById(String id) {
        CustomObjDTO customObjDTO = (CustomObjDTO)((Object)CustomObjWrapper.INSTANCE.toDTO((Object)((CustomObj)((Object)super.getById((Serializable)((Object)id))))));
        customObjDTO.setCustomFieldDTOList(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.customFieldService.lambdaQuery().eq(CustomField::getObjId, (Object)id)).orderByAsc(CustomField::getSort)).list().stream().map(CustomFieldWrapper.INSTANCE::toDTO).collect(Collectors.toList()));
        return customObjDTO;
    }

    public void saveOrUpdate(CustomObjDTO customObjDTO) {
        CustomObj customObj = (CustomObj)((Object)CustomObjWrapper.INSTANCE.toEntity((Object)customObjDTO));
        super.saveOrUpdate((Object)customObj);
        for (CustomFieldDTO customFieldDTO : customObjDTO.getCustomFieldDTOList()) {
            if (Integer.valueOf(1).equals(customFieldDTO.getDelFlag())) {
                this.customFieldService.removeById((Serializable)((Object)customFieldDTO.getId()));
                continue;
            }
            CustomField customField = CustomFieldWrapper.INSTANCE.toEntity(customFieldDTO);
            customField.setObjId(customObj.getId());
            this.customFieldService.saveOrUpdate((Object)customField);
        }
    }

    public void removeById(String id) {
        super.removeById((Serializable)((Object)id));
        ((LambdaUpdateChainWrapper)this.customFieldService.lambdaUpdate().eq(CustomField::getObjId, (Object)id)).remove();
    }

    public CustomObjDTO getByValue(String value) {
        List objs = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(CustomObj::getValue, (Object)value)).list();
        CustomObjDTO customObjDTO = null;
        if (objs.size() <= 0) {
            return new CustomObjDTO();
        }
        customObjDTO = (CustomObjDTO)((Object)CustomObjWrapper.INSTANCE.toDTO((Object)((CustomObj)((Object)objs.get(0)))));
        customObjDTO.setCustomFieldDTOList(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.customFieldService.lambdaQuery().eq(CustomField::getObjId, (Object)customObjDTO.getId())).orderByAsc(CustomField::getSort)).list().stream().map(CustomFieldWrapper.INSTANCE::toDTO).collect(Collectors.toList()));
        return customObjDTO;
    }
}

