/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.service;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.devtools.domain.DataBaseType;
import com.jeeplus.devtools.domain.TableFieldType;
import com.jeeplus.devtools.mapper.DataBaseTypeMapper;
import com.jeeplus.devtools.service.TableFieldTypeService;
import com.jeeplus.devtools.service.dto.DataBaseTypeDTO;
import com.jeeplus.devtools.service.dto.TableFieldTypeDTO;
import com.jeeplus.devtools.service.mapstruct.DataBaseTypeWrapper;
import com.jeeplus.devtools.service.mapstruct.TableFieldTypeWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataBaseTypeService
extends ServiceImpl<DataBaseTypeMapper, DataBaseType> {
    @Autowired
    private TableFieldTypeService tableFieldTypeService;

    public DataBaseTypeDTO getById(String id) {
        DataBaseTypeDTO dataBaseTypeDTO = (DataBaseTypeDTO)((Object)DataBaseTypeWrapper.INSTANCE.toDTO((Object)((DataBaseType)((Object)super.getById((Serializable)((Object)id))))));
        dataBaseTypeDTO.setTableFieldTypeDTOList(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tableFieldTypeService.lambdaQuery().eq(TableFieldType::getTypeId, (Object)id)).orderByAsc(TableFieldType::getSort)).list().stream().map(TableFieldTypeWrapper.INSTANCE::toDTO).collect(Collectors.toList()));
        return dataBaseTypeDTO;
    }

    public void saveOrUpdate(DataBaseTypeDTO dataBaseTypeDTO) {
        DataBaseType dataBaseType = (DataBaseType)((Object)DataBaseTypeWrapper.INSTANCE.toEntity((Object)dataBaseTypeDTO));
        super.saveOrUpdate((Object)dataBaseType);
        for (TableFieldTypeDTO tableFieldTypeDTO : dataBaseTypeDTO.getTableFieldTypeDTOList()) {
            if (Integer.valueOf(1).equals(tableFieldTypeDTO.getDelFlag())) {
                this.tableFieldTypeService.removeById((Serializable)((Object)tableFieldTypeDTO.getId()));
                continue;
            }
            TableFieldType tableFieldType = TableFieldTypeWrapper.INSTANCE.toEntity(tableFieldTypeDTO);
            tableFieldType.setTypeId(dataBaseType.getId());
            this.tableFieldTypeService.saveOrUpdate((Object)tableFieldType);
        }
    }

    public List<TableFieldType> getTableFiledByDbType(String type) {
        DataBaseType dataBaseType = (DataBaseType)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DataBaseType::getType, (Object)type)).one());
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tableFieldTypeService.lambdaQuery().eq(TableFieldType::getTypeId, (Object)dataBaseType.getId())).orderByAsc(TableFieldType::getSort)).list();
    }

    public DataBaseType getByType(String type) {
        DataBaseType dataBaseType = (DataBaseType)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DataBaseType::getType, (Object)type)).one());
        return dataBaseType;
    }

    public void removeById(String id) {
        super.removeById((Serializable)((Object)id));
        ((LambdaUpdateChainWrapper)this.tableFieldTypeService.lambdaUpdate().eq(TableFieldType::getTypeId, (Object)id)).remove();
    }
}

