/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.service;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeeplus.devtools.domain.Menu;
import com.jeeplus.devtools.domain.Scheme;
import com.jeeplus.devtools.domain.TemplateObj;
import com.jeeplus.devtools.mapper.SchemeMapper;
import com.jeeplus.devtools.service.MenuService;
import com.jeeplus.devtools.service.TableColumnService;
import com.jeeplus.devtools.service.TableService;
import com.jeeplus.devtools.service.TemplateObjService;
import com.jeeplus.devtools.service.dto.SchemeDTO;
import com.jeeplus.devtools.service.dto.TableColumnDTO;
import com.jeeplus.devtools.service.dto.TableDTO;
import com.jeeplus.devtools.service.dto.TemplateDTO;
import com.jeeplus.devtools.service.mapstruct.SchemeWrapper;
import com.jeeplus.devtools.util.CodeUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SchemaService
extends ServiceImpl<SchemeMapper, Scheme> {
    @Autowired
    private TableService tableService;
    @Autowired
    private TableColumnService tableColumnService;
    @Autowired
    private TemplateObjService templateObjService;
    @Autowired
    private MenuService menuService;

    public String saveOrUpdate(SchemeDTO schemeDTO) throws Exception {
        String result = this.generateCode(schemeDTO);
        super.saveOrUpdate((Object)SchemeWrapper.INSTANCE.toEntity(schemeDTO));
        return result;
    }

    @CacheEvict(cacheNames={"sys:cache:menu", "user:cache:dataRuleList", "user:cache:topMenu", "user:cache:menuList"}, allEntries=true)
    public void createMenu(SchemeDTO scheme, Menu topMenu) {
        Object permissionPrefix = StringUtils.lowerCase((String)scheme.getModuleName()) + (String)(StringUtils.isNotBlank((CharSequence)scheme.getSubModuleName()) ? ":" + StringUtils.lowerCase((String)scheme.getSubModuleName()) : "") + ":" + StringUtils.uncapitalize((String)scheme.getTable().getClassName());
        Object url = "/" + StringUtils.lowerCase((String)scheme.getModuleName()) + (String)(StringUtils.isNotBlank((CharSequence)scheme.getSubModuleName()) ? "/" + StringUtils.lowerCase((String)scheme.getSubModuleName()) : "") + "/" + scheme.getTable().getClassName() + "List";
        permissionPrefix = ((String)permissionPrefix).replace(".", ":");
        url = ((String)url).replace(".", "/");
        topMenu.setHref((String)url);
        topMenu.setIsShow("1");
        topMenu.setType("1");
        topMenu.setPermission((String)permissionPrefix + ":list");
        this.menuService.saveOrUpdate(topMenu);
        Menu addMenu = new Menu();
        addMenu.setName("\u589e\u52a0");
        addMenu.setIsShow("0");
        addMenu.setType("2");
        addMenu.setSort(30);
        addMenu.setPermission((String)permissionPrefix + ":add");
        addMenu.setParentId(topMenu.getId());
        this.menuService.saveOrUpdate(addMenu);
        Menu delMenu = new Menu();
        delMenu.setName("\u5220\u9664");
        delMenu.setIsShow("0");
        delMenu.setType("2");
        delMenu.setSort(60);
        delMenu.setPermission((String)permissionPrefix + ":del");
        delMenu.setParentId(topMenu.getId());
        this.menuService.saveOrUpdate(delMenu);
        Menu editMenu = new Menu();
        editMenu.setName("\u7f16\u8f91");
        editMenu.setIsShow("0");
        editMenu.setType("2");
        editMenu.setSort(90);
        editMenu.setPermission((String)permissionPrefix + ":edit");
        editMenu.setParentId(topMenu.getId());
        this.menuService.saveOrUpdate(editMenu);
        Menu viewMenu = new Menu();
        viewMenu.setName("\u67e5\u770b");
        viewMenu.setIsShow("0");
        viewMenu.setType("2");
        viewMenu.setSort(120);
        viewMenu.setPermission((String)permissionPrefix + ":view");
        viewMenu.setParentId(topMenu.getId());
        this.menuService.saveOrUpdate(viewMenu);
        Menu importMenu = new Menu();
        importMenu.setName("\u5bfc\u5165");
        importMenu.setIsShow("0");
        importMenu.setType("2");
        importMenu.setSort(150);
        importMenu.setPermission((String)permissionPrefix + ":import");
        importMenu.setParentId(topMenu.getId());
        this.menuService.saveOrUpdate(importMenu);
        Menu exportMenu = new Menu();
        exportMenu.setName("\u5bfc\u51fa");
        exportMenu.setIsShow("0");
        exportMenu.setType("2");
        exportMenu.setSort(180);
        exportMenu.setPermission((String)permissionPrefix + ":export");
        exportMenu.setParentId(topMenu.getId());
        this.menuService.saveOrUpdate(exportMenu);
    }

    private String generateCode(SchemeDTO schemeDTO) throws Exception {
        StringBuilder result = new StringBuilder();
        TableDTO tableDTO = this.tableService.getById(schemeDTO.getTable().getId());
        List genCodeTemplateObjList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.templateObjService.lambdaQuery().eq(TemplateObj::getGroupId, (Object)schemeDTO.getCategory())).orderByAsc(TemplateObj::getSort)).list();
        List<TemplateDTO> templateList = CodeUtils.getTemplateListByObj(genCodeTemplateObjList, false);
        List<TemplateDTO> childTableTemplateList = CodeUtils.getTemplateListByObj(genCodeTemplateObjList, true);
        if (childTableTemplateList.size() > 0) {
            TableDTO parentTable = new TableDTO();
            parentTable.setParentTable(tableDTO.getName());
            tableDTO.setChildList(this.tableService.findList(parentTable));
        }
        String childSimpleJavaField = "";
        for (TableDTO childTableDTO : tableDTO.getChildList()) {
            childTableDTO.setParent(tableDTO);
            childTableDTO.setColumnList(this.tableColumnService.findList(childTableDTO.getId()));
            schemeDTO.setTable(childTableDTO);
            for (TableColumnDTO c : childTableDTO.getColumnList()) {
                if (!c.getName().equals(childTableDTO.getParentTableFk())) continue;
                childSimpleJavaField = c.getSimpleJavaField();
            }
            Map<String, Object> childTableModel = CodeUtils.getDataModel(schemeDTO);
            childTableModel.put("childUrlPrefix", (childTableModel.get("moduleName") + (String)(StringUtils.isNotBlank((CharSequence)schemeDTO.getSubModuleName()) ? "/" + StringUtils.lowerCase((String)schemeDTO.getSubModuleName()) : "")).replace(".", "/"));
            childTableModel.put("functionName", childTableDTO.getComments());
            childTableModel.put("childSimpleJavaField", childSimpleJavaField);
            childTableModel.put("functionNameSimple", childTableDTO.getComments());
            for (TemplateDTO tpl : childTableTemplateList) {
                if (tpl.getFileName().endsWith(".vue") || tpl.getFileName().endsWith(".html") || tpl.getFileName().endsWith(".js") || tpl.getFileName().endsWith(".css")) {
                    result.append(CodeUtils.generateToFile(schemeDTO, tpl, childTableModel, true, schemeDTO.getFrontProjectPath()));
                    continue;
                }
                result.append(CodeUtils.generateToFile(schemeDTO, tpl, childTableModel, true, schemeDTO.getProjectPath()));
            }
        }
        schemeDTO.setTable(tableDTO);
        Map<String, Object> model = CodeUtils.getDataModel(schemeDTO);
        model.put("childSimpleJavaField", childSimpleJavaField);
        for (TemplateDTO tpl : templateList) {
            if (tpl.getFileName().endsWith(".vue") || tpl.getFileName().endsWith(".html") || tpl.getFileName().endsWith(".js") || tpl.getFileName().endsWith(".css")) {
                result.append(CodeUtils.generateToFile(schemeDTO, tpl, model, true, schemeDTO.getFrontProjectPath()));
                continue;
            }
            result.append(CodeUtils.generateToFile(schemeDTO, tpl, model, true, schemeDTO.getProjectPath()));
        }
        return result.toString();
    }
}

