/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.service;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.jeeplus.devtools.domain.TemplateGroup;
import com.jeeplus.devtools.domain.TemplateObj;
import com.jeeplus.devtools.mapper.TemplateGroupMapper;
import com.jeeplus.devtools.service.TableService;
import com.jeeplus.devtools.service.TemplateObjService;
import com.jeeplus.devtools.service.dto.TableDTO;
import com.jeeplus.devtools.service.dto.TemplateDTO;
import com.jeeplus.devtools.service.dto.TemplateGroupDTO;
import com.jeeplus.devtools.service.dto.TemplateObjDTO;
import com.jeeplus.devtools.service.mapstruct.TemplateGroupWrapper;
import com.jeeplus.devtools.service.mapstruct.TemplateObjWrapper;
import com.jeeplus.devtools.util.CodeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TemplateGroupService
extends ServiceImpl<TemplateGroupMapper, TemplateGroup> {
    @Autowired
    private TemplateObjService templateObjService;
    @Autowired
    private TableService tableService;

    public TemplateGroupDTO getById(String id) {
        TemplateGroup templateGroup = (TemplateGroup)((Object)super.getById((Serializable)((Object)id)));
        TemplateGroupDTO templateGroupDTO = (TemplateGroupDTO)((Object)TemplateGroupWrapper.INSTANCE.toDTO((Object)templateGroup));
        List<TemplateObjDTO> templateObjList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.templateObjService.lambdaQuery().eq(TemplateObj::getGroupId, (Object)id)).orderByAsc(TemplateObj::getSort)).list().stream().map(TemplateObjWrapper.INSTANCE::toDTO).collect(Collectors.toList());
        templateGroupDTO.setTemplateObjDTOList(templateObjList);
        return templateGroupDTO;
    }

    public TemplateGroup saveOrUpdate(TemplateGroupDTO templateGroupDTO) {
        TemplateGroup templateGroup = (TemplateGroup)((Object)TemplateGroupWrapper.INSTANCE.toEntity((Object)templateGroupDTO));
        super.saveOrUpdate((Object)templateGroup);
        for (TemplateObjDTO templateObjDTO : templateGroupDTO.getTemplateObjDTOList()) {
            if (0 == templateObjDTO.getDelFlag()) {
                TemplateObj templateObj = TemplateObjWrapper.INSTANCE.toEntity(templateObjDTO);
                templateObj.setGroupId(templateGroup.getId());
                this.templateObjService.saveOrUpdate((Object)templateObj);
                continue;
            }
            this.templateObjService.removeById((Serializable)((Object)templateObjDTO.getId()));
        }
        return templateGroup;
    }

    public List<String> queryGenFiles(String id, String tableId) throws Exception {
        List genCodeTemplateObjList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.templateObjService.lambdaQuery().eq(TemplateObj::getGroupId, (Object)id)).orderByAsc(TemplateObj::getSort)).list();
        ArrayList genFiles = Lists.newArrayList();
        List<TemplateDTO> templateList = CodeUtils.getTemplateListByObj(genCodeTemplateObjList, false);
        List<TemplateDTO> childTableTemplateList = CodeUtils.getTemplateListByObj(genCodeTemplateObjList, true);
        TableDTO tableDTO = this.tableService.getById(tableId);
        templateList.forEach(templateDTO -> genFiles.add(templateDTO.getFileName().replace("${className}", StringUtils.uncapitalize((String)tableDTO.getClassName())).replace("${ClassName}", StringUtils.capitalize((String)tableDTO.getClassName()))));
        TableDTO parentTable = new TableDTO();
        parentTable.setParentTable(tableDTO.getName());
        tableDTO.setChildList(this.tableService.findList(parentTable));
        for (TableDTO childTableDTO : tableDTO.getChildList()) {
            childTableTemplateList.forEach(templateDTO -> genFiles.add(templateDTO.getFileName().replace("${className}", StringUtils.uncapitalize((String)childTableDTO.getClassName())).replace("${ClassName}", StringUtils.capitalize((String)childTableDTO.getClassName()))));
        }
        return genFiles;
    }

    public void copy(TemplateGroupDTO templateGroupDTO) {
        templateGroupDTO.setId("");
        templateGroupDTO.setName(templateGroupDTO.getName() + "--\u526f\u672c");
        TemplateGroup templateGroup = (TemplateGroup)((Object)TemplateGroupWrapper.INSTANCE.toEntity((Object)templateGroupDTO));
        super.save((Object)templateGroup);
        for (TemplateObjDTO templateObjDTO : templateGroupDTO.getTemplateObjDTOList()) {
            TemplateObj templateObj = TemplateObjWrapper.INSTANCE.toEntity(templateObjDTO);
            templateObj.setId(null);
            templateObj.setGroupId(templateGroup.getId());
            this.templateObjService.saveOrUpdate((Object)templateObj);
        }
    }

    public void removeById(String id) {
        super.removeById((Serializable)((Object)id));
        ((LambdaUpdateChainWrapper)this.templateObjService.lambdaUpdate().eq(TemplateObj::getGroupId, (Object)id)).remove();
    }
}

