/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.devtools.util;

import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.core.query.QueryType;
import com.jeeplus.devtools.SerialNumberUtil;
import com.jeeplus.devtools.domain.CustomObj;
import com.jeeplus.devtools.domain.TemplateObj;
import com.jeeplus.devtools.service.CustomObjService;
import com.jeeplus.devtools.service.dto.SchemeDTO;
import com.jeeplus.devtools.service.dto.TableColumnDTO;
import com.jeeplus.devtools.service.dto.TableDTO;
import com.jeeplus.devtools.service.dto.TemplateDTO;
import com.jeeplus.devtools.util.EscapeUtil;
import com.jeeplus.devtools.util.FileUtils;
import com.jeeplus.devtools.util.FreeMarkers;
import com.jeeplus.devtools.util.JaxbMapper;
import com.jeeplus.devtools.util.RSAUtils;
import com.jeeplus.devtools.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;

public class CodeUtils {
    private static final Logger logger = LoggerFactory.getLogger(CodeUtils.class);
    public static String versionType = "4";
    public static String versionNum = "1.0";
    public static String publicKey = "65537";
    public static String module = "10505273754596557081671434295030415973606429506951684807777131787847491799631260039526551233364988707181909667810713811968930645493391757168098710180270981";
    private static final String LL = "http://www.jeeplus.org";
    public static String computer = null;

    public static String getM() {
        return "V" + SerialNumberUtil.getAllSn();
    }

    public static String getSerial(String license) {
        RSAPublicKey pubKey = RSAUtils.getPublicKey(module, publicKey);
        String ming = "";
        try {
            ming = RSAUtils.decryptByPublicKey(license, pubKey);
        }
        catch (Exception e) {
            ming = "ERROR";
        }
        return ming;
    }

    private static int decode(String s) {
        int i = 0;
        char[] ac = s.toCharArray();
        int k = ac.length;
        for (int j = 0; j < k; ++j) {
            i = 31 * i + ac[j];
        }
        return Math.abs(i);
    }

    private static String change(String s) {
        byte[] abyte0 = s.getBytes();
        char[] ac = new char[s.length()];
        for (int n : abyte0) {
            if (n >= 48 && n <= 57) {
                n = (n - 48 + 5) % 10 + 48;
            } else if (n >= 65 && n <= 90) {
                n = (n - 65 + 13) % 26 + 65;
            } else if (n >= 97 && n <= 122) {
                n = (n - 97 + 13) % 26 + 97;
            }
            ac[i] = (char)n;
        }
        return String.valueOf(ac);
    }

    public static String getJavaTypeByLabel(String type) {
        CustomObjService customObjService = (CustomObjService)((Object)SpringUtil.getBean(CustomObjService.class));
        CustomObj customObj = (CustomObj)((Object)((LambdaQueryChainWrapper)customObjService.lambdaQuery().eq(CustomObj::getLabel, (Object)type)).one());
        if (customObj == null) {
            return null;
        }
        return customObj.getValue();
    }

    public static void initColumnField(TableDTO genTable) {
        for (TableColumnDTO column : genTable.getColumnList()) {
            if (StringUtils.isNotBlank((CharSequence)column.getId())) continue;
            if (StringUtils.isBlank((CharSequence)column.getComments())) {
                column.setComments(column.getName());
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)column.getJdbcType(), (CharSequence)"CHAR") || StringUtils.startsWithIgnoreCase((CharSequence)column.getJdbcType(), (CharSequence)"VARCHAR") || StringUtils.startsWithIgnoreCase((CharSequence)column.getJdbcType(), (CharSequence)"NARCHAR")) {
                column.setJavaType("String");
            } else if (StringUtils.startsWithIgnoreCase((CharSequence)column.getJdbcType(), (CharSequence)"DATETIME") || StringUtils.startsWithIgnoreCase((CharSequence)column.getJdbcType(), (CharSequence)"DATE") || StringUtils.startsWithIgnoreCase((CharSequence)column.getJdbcType(), (CharSequence)"TIMESTAMP")) {
                column.setJavaType("java.util.Date");
                column.setShowType("dateselect");
            } else if (StringUtils.startsWithIgnoreCase((CharSequence)column.getJdbcType(), (CharSequence)"BIGINT") || StringUtils.startsWithIgnoreCase((CharSequence)column.getJdbcType(), (CharSequence)"INT") || StringUtils.startsWithIgnoreCase((CharSequence)column.getJdbcType(), (CharSequence)"INTEGER") || StringUtils.startsWithIgnoreCase((CharSequence)column.getJdbcType(), (CharSequence)"NUMBER")) {
                String[] ss = StringUtils.split((String)StringUtils.substringBetween((String)column.getJdbcType(), (String)"(", (String)")"), (String)",");
                if (ss != null && ss.length == 2 && Integer.parseInt(ss[1]) > 0) {
                    column.setJavaType("Double");
                } else if (ss != null && ss.length == 1 && Integer.parseInt(ss[0]) <= 10) {
                    column.setJavaType("Integer");
                } else {
                    column.setJavaType("Long");
                }
            }
            column.setJavaField(StringUtil.toCamelCase(column.getName()));
            column.setIsPk(genTable.getPkList().contains(column.getName()) ? "1" : "0");
            if (column.getIsNotBaseField().booleanValue()) {
                column.setIsForm("1");
            } else {
                column.setIsForm("0");
            }
            if (column.getIsNotTreeBaseField().booleanValue()) {
                column.setIsList("1");
            } else {
                column.setIsList("0");
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)"name") || StringUtils.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)"title")) {
                column.setIsQuery("1");
            } else {
                column.setIsQuery("0");
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)"name") || StringUtils.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)"title")) {
                column.setQueryType(QueryType.LIKE.name());
            } else {
                column.setQueryType(QueryType.EQ.name());
            }
            CustomObjService customObjService = (CustomObjService)((Object)SpringUtil.getBean(CustomObjService.class));
            if (StringUtils.startsWithIgnoreCase((CharSequence)column.getName(), (CharSequence)"user_id")) {
                column.setJavaType(CodeUtils.getJavaTypeByLabel("UserDTO"));
                column.setJavaField(column.getJavaField().replaceAll("Id", ".id|name"));
                column.setShowType("userselect");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)column.getName(), (CharSequence)"office_id")) {
                column.setJavaType(CodeUtils.getJavaTypeByLabel("OfficeDTO"));
                column.setJavaField(column.getJavaField().replaceAll("Id", ".id|name"));
                column.setShowType("officeselect");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)column.getName(), (CharSequence)"create_by_id") || StringUtils.startsWithIgnoreCase((CharSequence)column.getName(), (CharSequence)"update_by_id")) {
                column.setJavaType(CodeUtils.getJavaTypeByLabel("UserDTO"));
                column.setJavaField(column.getJavaField() + ".id");
                column.setShowType("userselect");
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)column.getName(), (CharSequence)"create_time") || StringUtils.startsWithIgnoreCase((CharSequence)column.getName(), (CharSequence)"update_time")) {
                column.setShowType("dateselect");
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)"remarks") || StringUtils.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)"content")) {
                column.setShowType("textarea");
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)"parent_id")) {
                column.setJavaType("This");
                column.setJavaField("parent.id|name");
                column.setShowType("treeselect");
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)"parent_ids")) {
                column.setShowType("input");
                column.setQueryType("like");
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)"del_flag")) {
                column.setShowType("radiobox");
                column.setDictType("del_flag");
                continue;
            }
            column.setShowType("input");
        }
    }

    public static String getTemplatePath() {
        try {
            File file = new DefaultResourceLoader().getResource("").getFile();
            if (file != null) {
                return file.getAbsolutePath() + File.separator + StringUtils.replaceEach((String)CodeUtils.class.getName(), (String[])new String[]{"util." + CodeUtils.class.getSimpleName(), "."}, (String[])new String[]{"template", File.separator});
            }
        }
        catch (Exception e) {
            logger.error("{}", (Throwable)e);
        }
        return "";
    }

    public static <T> T xmlToObject(String xmlContent, Class<?> clazz) {
        return (T)JaxbMapper.fromXml(xmlContent, clazz);
    }

    public static List<TemplateDTO> getTemplateListByObj(List<TemplateObj> genCodeTemplateObjList, boolean isChildTable) {
        ArrayList templateList = Lists.newArrayList();
        for (TemplateObj genCodeTemplateObj : genCodeTemplateObjList) {
            String contents = EscapeUtil.unescapeHtml(genCodeTemplateObj.getContents());
            TemplateDTO template = (TemplateDTO)((Object)CodeUtils.xmlToObject(contents, TemplateDTO.class));
            if (isChildTable) {
                if (!genCodeTemplateObj.getIsChild().equals("1")) continue;
                templateList.add(template);
                continue;
            }
            if (!genCodeTemplateObj.getIsChild().equals("0")) continue;
            templateList.add(template);
        }
        return templateList;
    }

    public static Map<String, Object> getDataModel(SchemeDTO schemeDTO) {
        HashMap model = Maps.newHashMap();
        model.put("packageName", StringUtils.lowerCase((String)schemeDTO.getPackageName()));
        model.put("moduleName", StringUtils.lowerCase((String)schemeDTO.getModuleName()));
        model.put("subModuleName", StringUtils.isNotBlank((CharSequence)schemeDTO.getSubModuleName()) ? StringUtils.lowerCase((String)schemeDTO.getSubModuleName()) : "");
        model.put("className", StringUtils.uncapitalize((String)schemeDTO.getTable().getClassName()));
        model.put("ClassName", StringUtils.capitalize((String)schemeDTO.getTable().getClassName()));
        model.put("functionName", schemeDTO.getFunctionName());
        model.put("functionNameSimple", schemeDTO.getFunctionNameSimple());
        model.put("functionAuthor", StringUtils.isNotBlank((CharSequence)schemeDTO.getFunctionAuthor()) ? schemeDTO.getFunctionAuthor() : "admin");
        model.put("functionVersion", DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        model.put("urlPrefix", (model.get("moduleName") + (String)(StringUtils.isNotBlank((CharSequence)schemeDTO.getSubModuleName()) ? "/" + StringUtils.lowerCase((String)schemeDTO.getSubModuleName()) : "") + "/" + model.get("className")).replace(".", "/"));
        model.put("viewPrefix", model.get("urlPrefix"));
        model.put("permissionPrefix", (model.get("moduleName") + (String)(StringUtils.isNotBlank((CharSequence)schemeDTO.getSubModuleName()) ? ":" + StringUtils.lowerCase((String)schemeDTO.getSubModuleName()) : "") + ":" + model.get("className")).replace(".", ":"));
        boolean isNeedJoinTable = false;
        boolean isNeedWrapper = schemeDTO.getTable().getParentExists();
        for (TableColumnDTO tableColumnDTO : schemeDTO.getTable().getColumnList()) {
            if (!tableColumnDTO.getIsNotBasicUserField() && !"officeselect".equals(tableColumnDTO.getShowType()) && (!"treeselect".equals(tableColumnDTO.getShowType()) || tableColumnDTO.getJavaType().equals("This")) && !"gridselect".equals(tableColumnDTO.getShowType())) continue;
            isNeedJoinTable = true;
            isNeedWrapper = true;
        }
        model.put("isNeedWrapper", isNeedWrapper);
        model.put("isNeedJoinTable", isNeedJoinTable);
        model.put("table", schemeDTO.getTable());
        return model;
    }

    public static String trimStart(String str) {
        int start;
        int last;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        char[] value = str.toCharArray();
        int end = last = str.length() - 1;
        for (start = 0; start <= end && value[start] <= ' '; ++start) {
        }
        if (start == 0 && end == last) {
            return str;
        }
        if (start >= end) {
            return "";
        }
        return str.substring(start, end);
    }

    public static String generateToFile(SchemeDTO schemeDTO, TemplateDTO tpl, Map<String, Object> model, boolean isReplaceFile, String projectPath) throws Exception {
        if (!("," + schemeDTO.getGenFiles() + ",").contains("," + FreeMarkers.renderString(tpl.getFileName(), model) + ",")) {
            return "";
        }
        String fileName = projectPath + File.separator + StringUtils.replaceEach((String)FreeMarkers.renderString(tpl.getFilePath() + "/", model), (String[])new String[]{"//", "/", "."}, (String[])new String[]{File.separator, File.separator, File.separator}) + FreeMarkers.renderString(tpl.getFileName(), model);
        logger.debug(" fileName === " + fileName);
        String content = FreeMarkers.renderString(CodeUtils.trimStart(tpl.getContent()), model);
        logger.debug(" content === \r\n" + content);
        if (isReplaceFile) {
            FileUtils.deleteFile(fileName);
        }
        if (FileUtils.createFile(fileName)) {
            FileUtils.writeToFile(fileName, content, true);
            logger.debug(" file create === " + fileName);
            return "\u751f\u6210\u6210\u529f\uff1a" + fileName + "<br/>";
        }
        logger.debug(" file extents === " + fileName);
        return "\u6587\u4ef6\u5df2\u5b58\u5728\uff1a" + fileName + "<br/>";
    }

    public static String getFormatDate(Date date, String str) {
        return new SimpleDateFormat(str).format(date);
    }

    public static synchronized String getNetWorkTime() {
        try {
            Locale locale = Locale.CHINA;
            String pattern = "yyyy-MM-dd";
            SimpleDateFormat df = new SimpleDateFormat(pattern, locale);
            Date date = new Date();
            df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            URL url = new URL("http://open.baidu.com/special/time/");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(2000);
            connection.setConnectTimeout(2000);
            connection.connect();
            long ld = connection.getDate();
            date = new Date(ld);
            return df.format(date);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CodeUtils.getFormatDate(new Date(), "yyyy-MM-dd");
    }

    public static String getMotherboardSN() {
        Object result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = (String)result + line;
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((String)result).trim();
    }

    public static String getHardDiskSN(String drive) {
        Object result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"" + drive + "\")\nWscript.Echo objDrive.SerialNumber";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = (String)result + line;
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((String)result).trim();
    }

    public static String getCPUSerial() {
        Object result = "";
        try {
            String line;
            File file = File.createTempFile("tmp", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_Processor\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.ProcessorId \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = (String)result + line;
            }
            input.close();
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((String)result).trim();
    }

    public static String getMac() {
        String result = "";
        try {
            String line;
            Process process = Runtime.getRuntime().exec("ipconfig /all");
            InputStreamReader ir = new InputStreamReader(process.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while ((line = input.readLine()) != null) {
                String MACAddr;
                if (line.indexOf("Physical Address") <= 0) continue;
                result = MACAddr = line.substring(line.indexOf("-") - 2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String getRegisterInfo() {
        return CodeUtils.getM();
    }

    public static Date transferString2Date(String s) {
        Date date = new Date();
        try {
            date = new SimpleDateFormat("yyyy-MM-dd").parse(s);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static long getCurrentTime() {
        Long currentTime = System.currentTimeMillis();
        URL url = null;
        try {
            url = new URL("http://www.baidu.com/");
            URLConnection uc = url.openConnection();
            uc.setReadTimeout(1000);
            uc.setConnectTimeout(1000);
            uc.connect();
            long ld = uc.getDate();
            currentTime = ld;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(ld);
            String string = formatter.format(calendar.getTime());
        }
        catch (Exception e) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            System.out.println(df.format(System.currentTimeMillis()));
            e.printStackTrace();
            return System.currentTimeMillis();
        }
        return currentTime;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(CodeUtils.getCurrentTime() > CodeUtils.transferString2Date("2022-2-14").getTime());
    }

    static {
        computer = CodeUtils.getRegisterInfo();
    }
}

