/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class AppName {
    public static final String DEFAULT_SUBSCRIBE_GROUP = "";
    public static final String APP_SEPARATOR = ".";
    public static final String APP_SEPARATOR_SPLIT = ".";
    private static final int APP_NAME_CACHE_SIZE = 10240;
    private static final ConcurrentMap<String, AppName> APP_NAME_CACHE = Maps.newConcurrentMap();
    private String code;
    private String subscribeGroup;
    private String fullName;

    public AppName() {
    }

    public AppName(String code) {
        this(code, DEFAULT_SUBSCRIBE_GROUP);
    }

    public AppName(String code, String subscribeGroup) {
        Preconditions.checkArgument((code != null && !code.isEmpty() && !code.contains(".") ? 1 : 0) != 0, (Object)"invalid app.");
        this.code = code;
        this.subscribeGroup = StringUtils.isBlank((CharSequence)subscribeGroup) ? DEFAULT_SUBSCRIBE_GROUP : subscribeGroup;
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = this.subscribeGroup == null || DEFAULT_SUBSCRIBE_GROUP.equals(this.subscribeGroup) ? this.code : this.code + "." + this.subscribeGroup;
        }
        return this.fullName;
    }

    public static AppName parse(String code, String subscribeGroup) {
        if (subscribeGroup == null || DEFAULT_SUBSCRIBE_GROUP.equals(subscribeGroup)) {
            subscribeGroup = DEFAULT_SUBSCRIBE_GROUP;
        }
        return new AppName(code, subscribeGroup);
    }

    public static AppName parse(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return null;
        }
        AppName appName = (AppName)APP_NAME_CACHE.get(fullName);
        if (appName == null) {
            String[] splits;
            if (APP_NAME_CACHE.size() > 10240) {
                APP_NAME_CACHE.clear();
            }
            appName = (splits = StringUtils.splitByWholeSeparator((String)fullName, (String)".")).length == 1 ? new AppName(splits[0]) : new AppName(splits[0], splits[1]);
            APP_NAME_CACHE.put(fullName, appName);
        }
        return appName;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String app) {
        this.code = app;
    }

    public String getSubscribeGroup() {
        return this.subscribeGroup;
    }

    public void setSubscribeGroup(String subscribeGroup) {
        this.subscribeGroup = subscribeGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppName that = (AppName)o;
        return Objects.equals(this.code, that.code) && Objects.equals(this.subscribeGroup, that.subscribeGroup);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.subscribeGroup);
    }

    public String toString() {
        return "AppName{code='" + this.code + '\'' + ", subscribeGroup='" + this.subscribeGroup + '\'' + '}';
    }
}

