/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model.domain;

import javax.validation.constraints.Pattern;
import org.joyqueue.model.domain.Identifier;

public class Identity {
    private Long id;
    @Pattern(regexp="^[a-zA-Z0-9]+[a-zA-Z0-9_,]*[a-zA-Z0-9]+$", message="Please enter correct code")
    private @Pattern(regexp="^[a-zA-Z0-9]+[a-zA-Z0-9_,]*[a-zA-Z0-9]+$", message="Please enter correct code") String code;
    private String name;

    public Identity() {
    }

    public Identity(Long id) {
        this.id = id;
    }

    public Identity(String code) {
        this.code = code;
    }

    public Identity(Long id, String code) {
        this.id = id;
        this.code = code;
    }

    public Identity(Long id, String code, String name) {
        this.id = id;
        this.code = code;
        this.name = name;
    }

    public Identity(Identifier identifier) {
        if (identifier != null) {
            this.id = identifier.getId();
            this.code = identifier.getCode();
            this.name = identifier.getName();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Identity{id=" + this.id + ", code='" + this.code + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Identity) {
            Identity i = (Identity)o;
            if (i.id == this.id) {
                if (i.code != null && i.code.equals(this.code)) {
                    return true;
                }
                if (this.code == null) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }
}

