/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model.domain;

public enum Permission {
    NONE,
    READ,
    WRITE,
    FULL;


    public static Permission valueOf(int ordinal) {
        if (ordinal < 0 || ordinal >= Permission.values().length) {
            throw new IndexOutOfBoundsException("Invalid ordinal");
        }
        return Permission.values()[ordinal];
    }

    public boolean contain(Permission permission) {
        return this == permission || this == FULL && permission != NONE;
    }

    public Permission addWrite() {
        if (this == null || this == NONE) {
            return WRITE;
        }
        if (this == READ) {
            return FULL;
        }
        return this;
    }

    public Permission removeWrite() {
        if (this == null) {
            return NONE;
        }
        if (this == NONE || this == READ) {
            return this;
        }
        if (this == WRITE) {
            return NONE;
        }
        return READ;
    }

    public Permission addRead() {
        if (this == null || this == NONE) {
            return READ;
        }
        if (this == WRITE) {
            return FULL;
        }
        return this;
    }

    public Permission removeRead() {
        if (this == null) {
            return NONE;
        }
        if (this == NONE || this == WRITE) {
            return this;
        }
        if (this == READ) {
            return NONE;
        }
        return WRITE;
    }

    public boolean canRead() {
        return this.contain(READ);
    }

    public boolean canWrite() {
        return this.contain(WRITE);
    }
}

