/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model.domain;

import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.joyqueue.domain.Topic;
import org.joyqueue.model.domain.Broker;
import org.joyqueue.model.domain.BrokerGroup;
import org.joyqueue.model.domain.Namespace;
import org.joyqueue.model.domain.nsr.BaseNsrModel;

public class Topic
extends BaseNsrModel {
    public static final int DEFAULT_QUEUE_SIZE = 5;
    public static final int DEFAULT_SEQ_QUEUE_SIZE = 1;
    public static final int TOPIC_TYPE_TOPIC = 0;
    public static final int TOPIC_TYPE_BROADCAST = 1;
    public static final int TOPIC_TYPE_SEQUENTIAL = 2;
    public static final int NEW = 2;
    @NotNull
    private String name;
    @Pattern(regexp="^[a-zA-Z0-9]+[a-zA-Z0-9_]*[a-zA-Z0-9]+$", message="Please enter correct code")
    private @Pattern(regexp="^[a-zA-Z0-9]+[a-zA-Z0-9_]*[a-zA-Z0-9]+$", message="Please enter correct code") String code;
    @Min(value=0L)
    @Max(value=99L)
    private @Min(value=0L) @Max(value=99L) int partitions = 5;
    private boolean archive = false;
    private int type;
    private int electType;
    private String labels;
    private List<String> dataCenters;
    private Namespace namespace = new Namespace("", "");
    private BrokerGroup brokerGroup;
    private List<Broker> brokers;
    @Min(value=0L)
    @Max(value=20L)
    private @Min(value=0L) @Max(value=20L) int brokerNum;
    private int replica = 3;
    private Topic.TopicPolicy policy;

    public Topic() {
    }

    public Topic(String code) {
        this.code = code;
    }

    public Topic(String id, String code) {
        this.id = id;
        this.code = code;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public int getElectType() {
        return this.electType;
    }

    public void setElectType(int electType) {
        this.electType = electType;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public BrokerGroup getBrokerGroup() {
        return this.brokerGroup;
    }

    public void setBrokerGroup(BrokerGroup brokerGroup) {
        this.brokerGroup = brokerGroup;
    }

    public List<Broker> getBrokers() {
        return this.brokers;
    }

    public void setBrokers(List<Broker> brokers) {
        this.brokers = brokers;
    }

    public int getBrokerNum() {
        return this.brokerNum;
    }

    public void setBrokerNum(int brokerNum) {
        this.brokerNum = brokerNum;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public int getReplica() {
        return this.replica;
    }

    public void setReplica(int replica) {
        this.replica = replica;
    }

    public List<String> getDataCenters() {
        return this.dataCenters;
    }

    public void setDataCenters(List<String> dataCenters) {
        this.dataCenters = dataCenters;
    }

    public Topic.TopicPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Topic.TopicPolicy policy) {
        this.policy = policy;
    }

    @Override
    public String toString() {
        return "Topic{name='" + this.name + '\'' + ", code='" + this.code + '\'' + ", partitions=" + this.partitions + ", archive=" + this.archive + ", type=" + this.type + ", electType=" + this.electType + ", labels='" + this.labels + '\'' + ", namespace=" + this.namespace + ", brokerGroup=" + this.brokerGroup + ", brokers=" + this.brokers + ", brokerNum=" + this.brokerNum + ", replica=" + this.replica + '}';
    }
}

