/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.joyqueue.network.command.AddConsumerRequest;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class AddConsumerRequestCodec
implements PayloadCodec<JoyQueueHeader, AddConsumerRequest>,
Type {
    public AddConsumerRequest decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        AddConsumerRequest addConsumerRequest = new AddConsumerRequest();
        int topicSize = buffer.readShort();
        ArrayList topics = Lists.newArrayListWithCapacity((int)topicSize);
        for (int i = 0; i < topicSize; ++i) {
            topics.add(Serializer.readString(buffer, 2));
        }
        addConsumerRequest.setTopics(topics);
        addConsumerRequest.setApp(Serializer.readString(buffer, 2));
        addConsumerRequest.setSequence(buffer.readLong());
        return addConsumerRequest;
    }

    @Override
    public void encode(AddConsumerRequest payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getTopics().size());
        for (String topic : payload.getTopics()) {
            Serializer.write(topic, buffer, 2);
        }
        Serializer.write(payload.getApp(), buffer, 2);
        buffer.writeLong(payload.getSequence());
    }

    @Override
    public int type() {
        return JoyQueueCommandType.ADD_CONSUMER_REQUEST.getCode();
    }
}

