/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.network.command.AddConsumerResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class AddConsumerResponseCodec
implements PayloadCodec<JoyQueueHeader, AddConsumerResponse>,
Type {
    public AddConsumerResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        HashMap result = Maps.newHashMap();
        int consumerSize = buffer.readShort();
        for (int i = 0; i < consumerSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            String consumerId = Serializer.readString(buffer, 2);
            result.put(topic, consumerId);
        }
        AddConsumerResponse addConsumerResponse = new AddConsumerResponse();
        addConsumerResponse.setConsumerIds(result);
        return addConsumerResponse;
    }

    @Override
    public void encode(AddConsumerResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getConsumerIds().size());
        for (Map.Entry<String, String> entry : payload.getConsumerIds().entrySet()) {
            Serializer.write(entry.getKey(), buffer, 2);
            Serializer.write(entry.getValue(), buffer, 2);
        }
    }

    @Override
    public int type() {
        return JoyQueueCommandType.ADD_CONSUMER_RESPONSE.getCode();
    }
}

