/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.network.command.AddProducerResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class AddProducerResponseCodec
implements PayloadCodec<JoyQueueHeader, AddProducerResponse>,
Type {
    public AddProducerResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        HashMap result = Maps.newHashMap();
        int producerSize = buffer.readShort();
        for (int i = 0; i < producerSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            String producerId = Serializer.readString(buffer, 2);
            result.put(topic, producerId);
        }
        AddProducerResponse addProducerResponse = new AddProducerResponse();
        addProducerResponse.setProducerIds(result);
        return addProducerResponse;
    }

    @Override
    public void encode(AddProducerResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getProducerIds().size());
        for (Map.Entry<String, String> entry : payload.getProducerIds().entrySet()) {
            Serializer.write(entry.getKey(), buffer, 2);
            Serializer.write(entry.getValue(), buffer, 2);
        }
    }

    @Override
    public int type() {
        return JoyQueueCommandType.ADD_PRODUCER_RESPONSE.getCode();
    }
}

