/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.CommitAckResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class CommitAckResponseCodec
implements PayloadCodec<JoyQueueHeader, CommitAckResponse>,
Type {
    public CommitAckResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        int size = buffer.readShort();
        HashBasedTable result = HashBasedTable.create();
        for (int i = 0; i < size; ++i) {
            String topic = Serializer.readString(buffer, 2);
            int partitionSize = buffer.readShort();
            for (int j = 0; j < partitionSize; ++j) {
                short partition = buffer.readShort();
                result.put((Object)topic, (Object)partition, (Object)JoyQueueCode.valueOf((int)buffer.readInt()));
            }
        }
        CommitAckResponse commitAckResponse = new CommitAckResponse();
        commitAckResponse.setResult((Table<String, Short, JoyQueueCode>)result);
        return commitAckResponse;
    }

    @Override
    public void encode(CommitAckResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getResult().size());
        for (Map.Entry entry : payload.getResult().rowMap().entrySet()) {
            Serializer.write((String)entry.getKey(), buffer, 2);
            buffer.writeShort(((Map)entry.getValue()).size());
            for (Map.Entry partitionEntry : ((Map)entry.getValue()).entrySet()) {
                buffer.writeShort((int)((Short)partitionEntry.getKey()).shortValue());
                buffer.writeInt(((JoyQueueCode)partitionEntry.getValue()).getCode());
            }
        }
    }

    @Override
    public int type() {
        return JoyQueueCommandType.COMMIT_ACK_RESPONSE.getCode();
    }
}

