/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FetchAssignedPartitionAckData;
import org.joyqueue.network.command.FetchAssignedPartitionResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class FetchAssignedPartitionResponseCodec
implements PayloadCodec<JoyQueueHeader, FetchAssignedPartitionResponse>,
Type {
    public FetchAssignedPartitionResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        FetchAssignedPartitionResponse fetchAssignedPartitionResponse = new FetchAssignedPartitionResponse();
        HashMap topicPartitions = Maps.newHashMap();
        int topicSize = buffer.readShort();
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            int partitionSize = buffer.readShort();
            ArrayList partitions = Lists.newArrayListWithCapacity((int)partitionSize);
            for (int j = 0; j < partitionSize; ++j) {
                partitions.add(buffer.readShort());
            }
            JoyQueueCode code = JoyQueueCode.valueOf((int)buffer.readInt());
            topicPartitions.put(topic, new FetchAssignedPartitionAckData(partitions, code));
        }
        fetchAssignedPartitionResponse.setTopicPartitions(topicPartitions);
        return fetchAssignedPartitionResponse;
    }

    @Override
    public void encode(FetchAssignedPartitionResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getTopicPartitions().size());
        for (Map.Entry<String, FetchAssignedPartitionAckData> entry : payload.getTopicPartitions().entrySet()) {
            Serializer.write(entry.getKey(), buffer, 2);
            FetchAssignedPartitionAckData data = entry.getValue();
            buffer.writeShort(data.getPartitions().size());
            for (Short partition : data.getPartitions()) {
                buffer.writeShort((int)partition.shortValue());
            }
            buffer.writeInt(data.getCode().getCode());
        }
    }

    @Override
    public int type() {
        return JoyQueueCommandType.FETCH_ASSIGNED_PARTITION_RESPONSE.getCode();
    }
}

