/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.domain.ConsumerPolicy;
import org.joyqueue.domain.ProducerPolicy;
import org.joyqueue.domain.TopicType;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FetchClusterResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.Topic;
import org.joyqueue.network.command.TopicPartition;
import org.joyqueue.network.command.TopicPartitionGroup;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;

public class FetchClusterResponseCodec
implements PayloadCodec<JoyQueueHeader, FetchClusterResponse>,
Type {
    private static final byte NONE_TOPIC_TYPE = -1;

    public FetchClusterResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        FetchClusterResponse fetchClusterResponse = new FetchClusterResponse();
        HashMap topics = Maps.newHashMap();
        HashMap brokers = Maps.newHashMap();
        int topicSize = buffer.readShort();
        for (int i = 0; i < topicSize; ++i) {
            Topic topic = this.decodeTopic(buffer);
            topics.put(topic.getTopic(), topic);
        }
        int brokerSize = buffer.readShort();
        for (int i = 0; i < brokerSize; ++i) {
            BrokerNode brokerNode = this.decodeBroker(header, buffer);
            brokers.put(brokerNode.getId(), brokerNode);
        }
        fetchClusterResponse.setTopics(topics);
        fetchClusterResponse.setBrokers(brokers);
        return fetchClusterResponse;
    }

    protected Topic decodeTopic(ByteBuf buffer) throws Exception {
        byte topicType;
        boolean isExistConsumerPolicy;
        String topicCode = Serializer.readString(buffer, 2);
        Topic topic = new Topic();
        topic.setTopic(topicCode);
        boolean isExistProducerPolicy = buffer.readBoolean();
        if (isExistProducerPolicy) {
            boolean isNearBy = buffer.readBoolean();
            boolean isSingle = buffer.readBoolean();
            boolean isArchive = buffer.readBoolean();
            int weightSize = buffer.readShort();
            HashMap weight = Maps.newHashMap();
            for (int i = 0; i < weightSize; ++i) {
                weight.put(Serializer.readString(buffer, 2), buffer.readShort());
            }
            int blackListSize = buffer.readShort();
            HashSet blackList = Sets.newHashSet();
            for (int i = 0; i < blackListSize; ++i) {
                blackList.add(Serializer.readString(buffer, 2));
            }
            int timeout = buffer.readInt();
            topic.setProducerPolicy(new ProducerPolicy(Boolean.valueOf(isNearBy), Boolean.valueOf(isSingle), Boolean.valueOf(isArchive), (Map)weight, (Set)blackList, Integer.valueOf(timeout)));
        }
        if (isExistConsumerPolicy = buffer.readBoolean()) {
            boolean isNearby = buffer.readBoolean();
            boolean isPaused = buffer.readBoolean();
            boolean isArchive = buffer.readBoolean();
            boolean isRetry = buffer.readBoolean();
            boolean isSeq = buffer.readBoolean();
            int ackTimeout = buffer.readInt();
            short batchSize = buffer.readShort();
            boolean isCurrent = buffer.readBoolean();
            int concurrent = buffer.readInt();
            int delay = buffer.readInt();
            int blackListSize = buffer.readShort();
            HashSet blackList = Sets.newHashSet();
            for (int i = 0; i < blackListSize; ++i) {
                blackList.add(Serializer.readString(buffer, 2));
            }
            int errTimes = buffer.readInt();
            int maxPartitionNum = buffer.readInt();
            int readRetryProbability = buffer.readInt();
            topic.setConsumerPolicy(new ConsumerPolicy(Boolean.valueOf(isNearby), Boolean.valueOf(isPaused), Boolean.valueOf(isArchive), Boolean.valueOf(isRetry), Boolean.valueOf(isSeq), Integer.valueOf(ackTimeout), Short.valueOf(batchSize), Integer.valueOf(concurrent), Integer.valueOf(delay), (Set)blackList, Integer.valueOf(errTimes), Integer.valueOf(maxPartitionNum), Integer.valueOf(readRetryProbability), null));
        }
        if ((topicType = buffer.readByte()) != -1) {
            topic.setType(TopicType.valueOf((byte)topicType));
        }
        HashMap partitionGroups = Maps.newHashMap();
        int partitionGroupSize = buffer.readShort();
        for (int i = 0; i < partitionGroupSize; ++i) {
            TopicPartitionGroup partitionGroup = new TopicPartitionGroup();
            HashMap partitions = Maps.newHashMap();
            partitionGroup.setId(buffer.readInt());
            partitionGroup.setLeader(buffer.readInt());
            partitionGroup.setPartitions(partitions);
            partitionGroups.put(partitionGroup.getId(), partitionGroup);
            int partitionSize = buffer.readShort();
            for (int j = 0; j < partitionSize; ++j) {
                TopicPartition partition = new TopicPartition();
                partition.setId(buffer.readShort());
                partitions.put(partition.getId(), partition);
            }
        }
        topic.setPartitionGroups(partitionGroups);
        topic.setCode(JoyQueueCode.valueOf((int)buffer.readInt()));
        return topic;
    }

    protected BrokerNode decodeBroker(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        BrokerNode result = new BrokerNode();
        result.setId(buffer.readInt());
        result.setHost(Serializer.readString(buffer, 2));
        result.setPort(buffer.readInt());
        result.setDataCenter(Serializer.readString(buffer, 2));
        result.setNearby(buffer.readBoolean());
        result.setWeight(buffer.readInt());
        if (header.getVersion() >= 2) {
            result.setSysCode(buffer.readInt());
            result.setPermission(buffer.readInt());
        }
        return result;
    }

    @Override
    public void encode(FetchClusterResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getTopics().size());
        for (Map.Entry<String, Topic> entry : payload.getTopics().entrySet()) {
            this.encodeTopic(entry.getValue(), buffer);
        }
        buffer.writeShort(payload.getBrokers().size());
        for (Map.Entry<Object, Serializable> entry : payload.getBrokers().entrySet()) {
            this.encodeBroker(payload.getHeader(), (BrokerNode)entry.getValue(), buffer);
        }
    }

    protected void encodeTopic(Topic topic, ByteBuf buffer) throws Exception {
        ProducerPolicy producerPolicy = topic.getProducerPolicy();
        ConsumerPolicy consumerPolicy = topic.getConsumerPolicy();
        Serializer.write(topic.getTopic(), buffer, 2);
        if (producerPolicy == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeBoolean(producerPolicy.getNearby().booleanValue());
            buffer.writeBoolean(producerPolicy.getSingle().booleanValue());
            buffer.writeBoolean(producerPolicy.getArchive().booleanValue());
            if (MapUtils.isEmpty((Map)producerPolicy.getWeight())) {
                buffer.writeShort(0);
            } else {
                buffer.writeShort(producerPolicy.getWeight().size());
                for (Map.Entry<Integer, TopicPartitionGroup> entry : producerPolicy.getWeight().entrySet()) {
                    Serializer.write((String)((Object)entry.getKey()), buffer, 2);
                    buffer.writeShort((int)((Short)((Object)entry.getValue())).shortValue());
                }
            }
            if (CollectionUtils.isEmpty((Collection)producerPolicy.getBlackList())) {
                buffer.writeShort(0);
            } else {
                buffer.writeShort(producerPolicy.getBlackList().size());
                for (String string : producerPolicy.getBlackList()) {
                    Serializer.write(string, buffer, 2);
                }
            }
            buffer.writeInt(producerPolicy.getTimeOut().intValue());
        }
        if (consumerPolicy == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeBoolean(consumerPolicy.getNearby().booleanValue());
            buffer.writeBoolean(consumerPolicy.getPaused().booleanValue());
            buffer.writeBoolean(consumerPolicy.getArchive().booleanValue());
            buffer.writeBoolean(consumerPolicy.getRetry().booleanValue());
            buffer.writeBoolean(consumerPolicy.getSeq().booleanValue());
            buffer.writeInt(consumerPolicy.getAckTimeout().intValue());
            buffer.writeShort((int)consumerPolicy.getBatchSize().shortValue());
            buffer.writeBoolean(false);
            buffer.writeInt(consumerPolicy.getConcurrent().intValue());
            buffer.writeInt(consumerPolicy.getDelay().intValue());
            if (CollectionUtils.isEmpty((Collection)consumerPolicy.getBlackList())) {
                buffer.writeShort(0);
            } else {
                buffer.writeShort(consumerPolicy.getBlackList().size());
                for (String string : consumerPolicy.getBlackList()) {
                    Serializer.write(string, buffer, 2);
                }
            }
            buffer.writeInt(consumerPolicy.getErrTimes().intValue());
            buffer.writeInt(consumerPolicy.getMaxPartitionNum().intValue());
            buffer.writeInt(consumerPolicy.getReadRetryProbability().intValue());
        }
        if (topic.getType() == null) {
            buffer.writeByte(-1);
        } else {
            buffer.writeByte((int)topic.getType().code());
        }
        if (MapUtils.isEmpty(topic.getPartitionGroups())) {
            buffer.writeShort(0);
        } else {
            buffer.writeShort(topic.getPartitionGroups().size());
            for (Map.Entry<Integer, TopicPartitionGroup> entry : topic.getPartitionGroups().entrySet()) {
                TopicPartitionGroup partitionGroup = entry.getValue();
                buffer.writeInt(entry.getKey().intValue());
                buffer.writeInt(partitionGroup.getLeader());
                buffer.writeShort(partitionGroup.getPartitions().size());
                for (Map.Entry<Short, TopicPartition> partitionEntry : partitionGroup.getPartitions().entrySet()) {
                    buffer.writeShort((int)partitionEntry.getKey().shortValue());
                }
            }
        }
        buffer.writeInt(topic.getCode().getCode());
    }

    protected void encodeBroker(Header header, BrokerNode brokerNode, ByteBuf buffer) throws Exception {
        buffer.writeInt(brokerNode.getId());
        Serializer.write(brokerNode.getHost(), buffer, 2);
        buffer.writeInt(brokerNode.getPort());
        Serializer.write(brokerNode.getDataCenter(), buffer, 2);
        buffer.writeBoolean(brokerNode.isNearby());
        buffer.writeInt(brokerNode.getWeight());
        if (header.getVersion() >= 2) {
            buffer.writeInt(brokerNode.getSysCode());
            buffer.writeInt(brokerNode.getPermission());
        }
    }

    @Override
    public int type() {
        return JoyQueueCommandType.FETCH_CLUSTER_RESPONSE.getCode();
    }
}

